/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.assist.impl;

import com.jeecms.cms.dao.assist.CmsAcquisitionDao;
import com.jeecms.cms.entity.assist.CmsAcquisition;
import com.jeecms.cms.entity.assist.CmsAcquisitionHistory;
import com.jeecms.cms.entity.assist.CmsAcquisitionTemp;
import com.jeecms.cms.entity.main.Content;
import com.jeecms.cms.entity.main.ContentExt;
import com.jeecms.cms.entity.main.ContentTxt;
import com.jeecms.cms.manager.assist.CmsAcquisitionMng;
import com.jeecms.cms.manager.main.ChannelMng;
import com.jeecms.cms.manager.main.CmsSiteMng;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.manager.main.ContentMng;
import com.jeecms.cms.manager.main.ContentTypeMng;
import com.jeecms.cms.service.ChannelDeleteChecker;
import com.jeecms.common.hibernate3.Updater;
import java.util.Date;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class CmsAcquisitionMngImpl
implements CmsAcquisitionMng,
ChannelDeleteChecker {
    private ChannelMng channelMng;
    private ContentMng contentMng;
    private ContentTypeMng contentTypeMng;
    private CmsSiteMng cmsSiteMng;
    private CmsUserMng cmsUserMng;
    private CmsAcquisitionDao dao;

    @Override
    @Transactional(readOnly=true)
    public List<CmsAcquisition> getList(Integer siteId) {
        return this.dao.getList(siteId);
    }

    @Override
    @Transactional
    public CmsAcquisition findById(Integer id) {
        CmsAcquisition entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public void stop(Integer id) {
        CmsAcquisition acqu = this.findById(id);
        if (acqu == null) {
            return;
        }
        if (acqu.getStatus() == 1) {
            acqu.setStatus(0);
        } else if (acqu.getStatus() == 2) {
            acqu.setCurrNum(0);
            acqu.setCurrItem(0);
            acqu.setTotalItem(0);
        }
    }

    @Override
    public void pause(Integer id) {
        CmsAcquisition acqu = this.findById(id);
        if (acqu == null) {
            return;
        }
        if (acqu.getStatus() == 1) {
            acqu.setStatus(2);
        }
    }

    @Override
    public CmsAcquisition start(Integer id) {
        CmsAcquisition acqu = this.findById(id);
        if (acqu == null) {
            return acqu;
        }
        acqu.setStatus(1);
        acqu.setStartTime(new Date());
        acqu.setEndTime(null);
        if (acqu.getCurrNum() <= 0) {
            acqu.setCurrNum(1);
        }
        if (acqu.getCurrItem() <= 0) {
            acqu.setCurrItem(1);
        }
        acqu.setTotalItem(0);
        return acqu;
    }

    @Override
    public void end(Integer id) {
        CmsAcquisition acqu = this.findById(id);
        if (acqu == null) {
            return;
        }
        acqu.setStatus(0);
        acqu.setEndTime(new Date());
        acqu.setCurrNum(0);
        acqu.setCurrItem(0);
        acqu.setTotalItem(0);
        acqu.setTotalItem(0);
    }

    @Override
    public boolean isNeedBreak(Integer id, int currNum, int currItem, int totalItem) {
        CmsAcquisition acqu = this.findById(id);
        if (acqu == null) {
            return true;
        }
        if (acqu.isPuase()) {
            acqu.setCurrNum(currNum);
            acqu.setCurrItem(currItem);
            acqu.setTotalItem(totalItem);
            acqu.setEndTime(new Date());
            return true;
        }
        if (acqu.isStop()) {
            acqu.setCurrNum(0);
            acqu.setCurrItem(0);
            acqu.setTotalItem(0);
            acqu.setEndTime(new Date());
            return true;
        }
        acqu.setCurrNum(currNum);
        acqu.setCurrItem(currItem);
        acqu.setTotalItem(totalItem);
        return false;
    }

    @Override
    public CmsAcquisition save(CmsAcquisition bean, Integer channelId, Integer typeId, Integer userId, Integer siteId) {
        bean.setChannel(this.channelMng.findById(channelId));
        bean.setType(this.contentTypeMng.findById(typeId));
        bean.setUser(this.cmsUserMng.findById(userId));
        bean.setSite(this.cmsSiteMng.findById(siteId));
        bean.init();
        this.dao.save(bean);
        return bean;
    }

    @Override
    public CmsAcquisition update(CmsAcquisition bean, Integer channelId, Integer typeId) {
        Updater updater = new Updater((Object)bean);
        bean = this.dao.updateByUpdater((Updater<CmsAcquisition>)updater);
        bean.setChannel(this.channelMng.findById(channelId));
        bean.setType(this.contentTypeMng.findById(typeId));
        return bean;
    }

    @Override
    public CmsAcquisition deleteById(Integer id) {
        CmsAcquisition bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public CmsAcquisition[] deleteByIds(Integer[] ids) {
        CmsAcquisition[] beans = new CmsAcquisition[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public Content saveContent(String title, String txt, Integer acquId, CmsAcquisition.AcquisitionResultType resultType, CmsAcquisitionTemp temp, CmsAcquisitionHistory history) {
        CmsAcquisition acqu = this.findById(acquId);
        Content c = new Content();
        c.setSite(acqu.getSite());
        ContentExt cext = new ContentExt();
        ContentTxt ctxt = new ContentTxt();
        cext.setTitle(title);
        ctxt.setTxt(txt);
        Content content = this.contentMng.save(c, cext, ctxt, null, null, null, null, null, null, null, null, null, (Integer)acqu.getChannel().getId(), acqu.getType().getId(), false, acqu.getUser(), false);
        history.setTitle(title);
        history.setContent(content);
        history.setDescription(resultType.name());
        temp.setTitle(title);
        temp.setDescription(resultType.name());
        return content;
    }

    @Override
    public String checkForChannelDelete(Integer channelId) {
        if (this.dao.countByChannelId(channelId) > 0) {
            return "cmsAcquisition.error.cannotDeleteChannel";
        }
        return null;
    }

    @Override
    public CmsAcquisition getStarted(Integer siteId) {
        return this.dao.getStarted(siteId);
    }

    @Override
    public Integer hasStarted(Integer siteId) {
        return this.getStarted(siteId) == null ? 0 : this.getMaxQueue(siteId) + 1;
    }

    @Override
    public Integer getMaxQueue(Integer siteId) {
        return this.dao.getMaxQueue(siteId);
    }

    @Override
    public void addToQueue(Integer[] ids, Integer queueNum) {
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            CmsAcquisition acqu = this.findById(id);
            if (acqu.getStatus() != 1 && acqu.getQueue() <= 0) {
                Integer n3 = queueNum;
                queueNum = n3 + 1;
                acqu.setQueue(n3);
            }
            ++n2;
        }
    }

    @Override
    public void cancel(Integer siteId, Integer id) {
        CmsAcquisition acqu = this.findById(id);
        Integer queue = acqu.getQueue();
        for (CmsAcquisition c : this.getLargerQueues(siteId, queue)) {
            c.setQueue(c.getQueue() - 1);
        }
        acqu.setQueue(0);
    }

    @Override
    public List<CmsAcquisition> getLargerQueues(Integer siteId, Integer queueNum) {
        return this.dao.getLargerQueues(siteId, queueNum);
    }

    @Override
    public CmsAcquisition popAcquFromQueue(Integer siteId) {
        CmsAcquisition acquisition = this.dao.popAcquFromQueue(siteId);
        if (acquisition != null) {
            Integer id = acquisition.getId();
            this.cancel(siteId, id);
        }
        return acquisition;
    }

    @Autowired
    public void setChannelMng(ChannelMng channelMng) {
        this.channelMng = channelMng;
    }

    @Autowired
    public void setContentMng(ContentMng contentMng) {
        this.contentMng = contentMng;
    }

    @Autowired
    public void setContentTypeMng(ContentTypeMng contentTypeMng) {
        this.contentTypeMng = contentTypeMng;
    }

    @Autowired
    public void setCmsSiteMng(CmsSiteMng cmsSiteMng) {
        this.cmsSiteMng = cmsSiteMng;
    }

    @Autowired
    public void setCmsUserMng(CmsUserMng cmsUserMng) {
        this.cmsUserMng = cmsUserMng;
    }

    @Autowired
    public void setDao(CmsAcquisitionDao dao) {
        this.dao = dao;
    }
}

