/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.assist.impl;

import com.jeecms.cms.dao.assist.CmsAdvertisingDao;
import com.jeecms.cms.entity.assist.CmsAdvertising;
import com.jeecms.cms.manager.assist.CmsAdvertisingMng;
import com.jeecms.cms.manager.assist.CmsAdvertisingSpaceMng;
import com.jeecms.common.hibernate3.Updater;
import com.jeecms.common.page.Pagination;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class CmsAdvertisingMngImpl
implements CmsAdvertisingMng {
    private CmsAdvertisingSpaceMng cmsAdvertisingSpaceMng;
    private CmsAdvertisingDao dao;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(Integer siteId, Integer adspaceId, Boolean enabled, int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(siteId, adspaceId, enabled, pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public List<CmsAdvertising> getList(Integer adspaceId, Boolean enabled) {
        return this.dao.getList(adspaceId, enabled);
    }

    @Override
    @Transactional(readOnly=true)
    public CmsAdvertising findById(Integer id) {
        CmsAdvertising entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public CmsAdvertising save(CmsAdvertising bean, Integer adspaceId, Map<String, String> attr) {
        bean.setAdspace(this.cmsAdvertisingSpaceMng.findById(adspaceId));
        bean.setAttr(attr);
        bean.init();
        this.dao.save(bean);
        return bean;
    }

    @Override
    public CmsAdvertising update(CmsAdvertising bean, Integer adspaceId, Map<String, String> attr) {
        Updater updater = new Updater((Object)bean);
        updater.include(CmsAdvertising.PROP_CODE);
        bean = this.dao.updateByUpdater((Updater<CmsAdvertising>)updater);
        bean.setAdspace(this.cmsAdvertisingSpaceMng.findById(adspaceId));
        bean.getAttr().clear();
        bean.getAttr().putAll(attr);
        return bean;
    }

    @Override
    public CmsAdvertising deleteById(Integer id) {
        CmsAdvertising bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public CmsAdvertising[] deleteByIds(Integer[] ids) {
        CmsAdvertising[] beans = new CmsAdvertising[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public void display(Integer id) {
        CmsAdvertising ad = this.findById(id);
        if (ad != null) {
            ad.setDisplayCount(ad.getDisplayCount() + 1L);
        }
    }

    @Override
    public void click(Integer id) {
        CmsAdvertising ad = this.findById(id);
        if (ad != null) {
            ad.setClickCount(ad.getClickCount() + 1L);
        }
    }

    @Autowired
    public void setCmsAdvertisingSpaceMng(CmsAdvertisingSpaceMng cmsAdvertisingSpaceMng) {
        this.cmsAdvertisingSpaceMng = cmsAdvertisingSpaceMng;
    }

    @Autowired
    public void setDao(CmsAdvertisingDao dao) {
        this.dao = dao;
    }
}

