/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.assist.impl;

import com.jeecms.cms.dao.assist.CmsCommentDao;
import com.jeecms.cms.entity.assist.CmsComment;
import com.jeecms.cms.entity.assist.CmsCommentExt;
import com.jeecms.cms.manager.assist.CmsCommentExtMng;
import com.jeecms.cms.manager.assist.CmsCommentMng;
import com.jeecms.cms.manager.assist.CmsSensitivityMng;
import com.jeecms.cms.manager.main.CmsSiteMng;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.manager.main.ContentCountMng;
import com.jeecms.cms.manager.main.ContentMng;
import com.jeecms.common.hibernate3.Updater;
import com.jeecms.common.page.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class CmsCommentMngImpl
implements CmsCommentMng {
    private CmsSensitivityMng cmsSensitivityMng;
    private CmsUserMng cmsUserMng;
    private CmsSiteMng cmsSiteMng;
    private ContentMng contentMng;
    private ContentCountMng contentCountMng;
    private CmsCommentExtMng cmsCommentExtMng;
    private CmsCommentDao dao;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(Integer siteId, Integer contentId, Integer greaterThen, Boolean checked, boolean recommend, boolean desc, int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(siteId, contentId, greaterThen, checked, recommend, desc, pageNo, pageSize, false);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPageForTag(Integer siteId, Integer contentId, Integer greaterThen, Boolean checked, boolean recommend, boolean desc, int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(siteId, contentId, greaterThen, checked, recommend, desc, pageNo, pageSize, true);
        return page;
    }

    @Override
    public Pagination getPageForMember(Integer siteId, Integer contentId, Integer toUserId, Integer fromUserId, Integer greaterThen, Boolean checked, Boolean recommend, boolean desc, int pageNo, int pageSize) {
        Pagination page = this.dao.getPageForMember(siteId, contentId, toUserId, fromUserId, greaterThen, checked, recommend, desc, pageNo, pageSize, false);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public List<CmsComment> getListForDel(Integer siteId, Integer userId, Integer commentUserId, String ip) {
        return this.dao.getListForDel(siteId, userId, commentUserId, ip);
    }

    @Override
    @Transactional(readOnly=true)
    public List<CmsComment> getListForTag(Integer siteId, Integer contentId, Integer greaterThen, Boolean checked, boolean recommend, boolean desc, int count) {
        return this.dao.getList(siteId, contentId, greaterThen, checked, recommend, desc, count, true);
    }

    @Override
    @Transactional(readOnly=true)
    public CmsComment findById(Integer id) {
        CmsComment entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public CmsComment comment(String text, String ip, Integer contentId, Integer siteId, Integer userId, boolean checked, boolean recommend) {
        CmsComment comment = new CmsComment();
        comment.setContent(this.contentMng.findById(contentId));
        comment.setSite(this.cmsSiteMng.findById(siteId));
        if (userId != null) {
            comment.setCommentUser(this.cmsUserMng.findById(userId));
        }
        comment.setChecked(checked);
        comment.setRecommend(recommend);
        comment.init();
        this.dao.save(comment);
        text = this.cmsSensitivityMng.replaceSensitivity(text);
        this.cmsCommentExtMng.save(ip, text, comment);
        this.contentCountMng.commentCount(contentId);
        return comment;
    }

    @Override
    public CmsComment update(CmsComment bean, CmsCommentExt ext) {
        Updater updater = new Updater((Object)bean);
        bean = this.dao.updateByUpdater((Updater<CmsComment>)updater);
        this.cmsCommentExtMng.update(ext);
        return bean;
    }

    @Override
    public int deleteByContentId(Integer contentId) {
        this.cmsCommentExtMng.deleteByContentId(contentId);
        return this.dao.deleteByContentId(contentId);
    }

    @Override
    public CmsComment deleteById(Integer id) {
        CmsComment bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public CmsComment[] deleteByIds(Integer[] ids) {
        CmsComment[] beans = new CmsComment[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public void ups(Integer id) {
        CmsComment comment = this.findById(id);
        comment.setUps((short)(comment.getUps() + 1));
    }

    @Override
    public void downs(Integer id) {
        CmsComment comment = this.findById(id);
        comment.setDowns((short)(comment.getDowns() + 1));
    }

    @Autowired
    public void setCmsSensitivityMng(CmsSensitivityMng cmsSensitivityMng) {
        this.cmsSensitivityMng = cmsSensitivityMng;
    }

    @Autowired
    public void setCmsUserMng(CmsUserMng cmsUserMng) {
        this.cmsUserMng = cmsUserMng;
    }

    @Autowired
    public void setCmsSiteMng(CmsSiteMng cmsSiteMng) {
        this.cmsSiteMng = cmsSiteMng;
    }

    @Autowired
    public void setContentMng(ContentMng contentMng) {
        this.contentMng = contentMng;
    }

    @Autowired
    public void setCmsCommentExtMng(CmsCommentExtMng cmsCommentExtMng) {
        this.cmsCommentExtMng = cmsCommentExtMng;
    }

    @Autowired
    public void setContentCountMng(ContentCountMng contentCountMng) {
        this.contentCountMng = contentCountMng;
    }

    @Autowired
    public void setDao(CmsCommentDao dao) {
        this.dao = dao;
    }
}

