/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.assist.impl;

import com.jeecms.cms.dao.assist.CmsFriendlinkDao;
import com.jeecms.cms.entity.assist.CmsFriendlink;
import com.jeecms.cms.manager.assist.CmsFriendlinkCtgMng;
import com.jeecms.cms.manager.assist.CmsFriendlinkMng;
import com.jeecms.common.hibernate3.Updater;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class CmsFriendlinkMngImpl
implements CmsFriendlinkMng {
    private CmsFriendlinkDao dao;
    private CmsFriendlinkCtgMng cmsFriendlinkCtgMng;

    @Override
    @Transactional(readOnly=true)
    public List<CmsFriendlink> getList(Integer siteId, Integer ctgId, Boolean enabled) {
        List<CmsFriendlink> list = this.dao.getList(siteId, ctgId, enabled);
        return list;
    }

    @Override
    @Transactional(readOnly=true)
    public int countByCtgId(Integer ctgId) {
        return this.dao.countByCtgId(ctgId);
    }

    @Override
    @Transactional(readOnly=true)
    public CmsFriendlink findById(Integer id) {
        CmsFriendlink entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public int updateViews(Integer id) {
        CmsFriendlink link = this.findById(id);
        if (link != null) {
            link.setViews(link.getViews() + 1);
        }
        return link.getViews();
    }

    @Override
    public CmsFriendlink save(CmsFriendlink bean, Integer ctgId) {
        bean.setCategory(this.cmsFriendlinkCtgMng.findById(ctgId));
        bean.init();
        this.dao.save(bean);
        return bean;
    }

    @Override
    public CmsFriendlink update(CmsFriendlink bean, Integer ctgId) {
        Updater updater = new Updater((Object)bean);
        bean = this.dao.updateByUpdater((Updater<CmsFriendlink>)updater);
        if (ctgId != null) {
            bean.setCategory(this.cmsFriendlinkCtgMng.findById(ctgId));
        }
        bean.blankToNull();
        return bean;
    }

    @Override
    public void updatePriority(Integer[] ids, Integer[] priorities) {
        if (ids == null || priorities == null || ids.length <= 0 || ids.length != priorities.length) {
            return;
        }
        int i = 0;
        int len = ids.length;
        while (i < len) {
            CmsFriendlink link = this.findById(ids[i]);
            link.setPriority(priorities[i]);
            ++i;
        }
    }

    @Override
    public CmsFriendlink deleteById(Integer id) {
        CmsFriendlink bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public CmsFriendlink[] deleteByIds(Integer[] ids) {
        CmsFriendlink[] beans = new CmsFriendlink[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(CmsFriendlinkDao dao) {
        this.dao = dao;
    }

    @Autowired
    public void setCmsFriendlinkCtgMng(CmsFriendlinkCtgMng cmsFriendlinkCtgMng) {
        this.cmsFriendlinkCtgMng = cmsFriendlinkCtgMng;
    }
}

