/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.assist.impl;

import com.jeecms.cms.dao.assist.CmsGuestbookDao;
import com.jeecms.cms.entity.assist.CmsGuestbook;
import com.jeecms.cms.entity.assist.CmsGuestbookExt;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.manager.assist.CmsGuestbookCtgMng;
import com.jeecms.cms.manager.assist.CmsGuestbookExtMng;
import com.jeecms.cms.manager.assist.CmsGuestbookMng;
import com.jeecms.cms.manager.main.CmsSiteMng;
import com.jeecms.common.hibernate3.Updater;
import com.jeecms.common.page.Pagination;
import java.sql.Timestamp;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class CmsGuestbookMngImpl
implements CmsGuestbookMng {
    private CmsGuestbookCtgMng cmsGuestbookCtgMng;
    private CmsGuestbookExtMng cmsGuestbookExtMng;
    private CmsSiteMng cmsSiteMng;
    private CmsGuestbookDao dao;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(Integer siteId, Integer ctgId, Integer userId, Boolean recommend, Boolean checked, boolean desc, boolean cacheable, int pageNo, int pageSize) {
        return this.dao.getPage(siteId, ctgId, userId, recommend, checked, desc, cacheable, pageNo, pageSize);
    }

    @Override
    @Transactional(readOnly=true)
    public List<CmsGuestbook> getList(Integer siteId, Integer ctgId, Boolean recommend, Boolean checked, boolean desc, boolean cacheable, int first, int max) {
        return this.dao.getList(siteId, ctgId, recommend, checked, desc, cacheable, first, max);
    }

    @Override
    @Transactional(readOnly=true)
    public CmsGuestbook findById(Integer id) {
        CmsGuestbook entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public CmsGuestbook save(CmsGuestbook bean, CmsGuestbookExt ext, Integer ctgId, String ip) {
        bean.setCtg(this.cmsGuestbookCtgMng.findById(ctgId));
        bean.setIp(ip);
        bean.setCreateTime(new Timestamp(System.currentTimeMillis()));
        bean.init();
        this.dao.save(bean);
        this.cmsGuestbookExtMng.save(ext, bean);
        return bean;
    }

    @Override
    public CmsGuestbook save(CmsUser member, Integer siteId, Integer ctgId, String ip, String title, String content, String email, String phone, String qq) {
        CmsGuestbook guestbook = new CmsGuestbook();
        guestbook.setMember(member);
        guestbook.setSite(this.cmsSiteMng.findById(siteId));
        guestbook.setIp(ip);
        CmsGuestbookExt ext = new CmsGuestbookExt();
        ext.setTitle(title);
        ext.setContent(content);
        ext.setEmail(email);
        ext.setPhone(phone);
        ext.setQq(qq);
        return this.save(guestbook, ext, ctgId, ip);
    }

    @Override
    public CmsGuestbook update(CmsGuestbook bean, CmsGuestbookExt ext, Integer ctgId) {
        Updater updater = new Updater((Object)bean);
        bean = this.dao.updateByUpdater((Updater<CmsGuestbook>)updater);
        bean.setCtg(this.cmsGuestbookCtgMng.findById(ctgId));
        this.cmsGuestbookExtMng.update(ext);
        return bean;
    }

    @Override
    public CmsGuestbook deleteById(Integer id) {
        CmsGuestbook bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public CmsGuestbook[] deleteByIds(Integer[] ids) {
        CmsGuestbook[] beans = new CmsGuestbook[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(CmsGuestbookDao dao) {
        this.dao = dao;
    }

    @Autowired
    public void setCmsGuestbookExtMng(CmsGuestbookExtMng cmsGuestbookExtMng) {
        this.cmsGuestbookExtMng = cmsGuestbookExtMng;
    }

    @Autowired
    public void setCmsGuestbookCtgMng(CmsGuestbookCtgMng cmsGuestbookCtgMng) {
        this.cmsGuestbookCtgMng = cmsGuestbookCtgMng;
    }

    @Autowired
    public void setCmsSiteMng(CmsSiteMng cmsSiteMng) {
        this.cmsSiteMng = cmsSiteMng;
    }
}

