/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.assist.impl;

import com.jeecms.cms.dao.assist.CmsKeywordDao;
import com.jeecms.cms.entity.assist.CmsKeyword;
import com.jeecms.cms.manager.assist.CmsKeywordMng;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.htmlparser.Node;
import org.htmlparser.lexer.Lexer;
import org.htmlparser.nodes.TextNode;
import org.htmlparser.util.ParserException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class CmsKeywordMngImpl
implements CmsKeywordMng {
    private CmsKeywordDao dao;

    @Override
    @Transactional(readOnly=true)
    public List<CmsKeyword> getListBySiteId(Integer siteId, boolean onlyEnabled, boolean cacheable) {
        List<CmsKeyword> list = this.dao.getListGlobal(onlyEnabled, cacheable);
        return list;
    }

    @Override
    @Transactional(readOnly=true)
    public String attachKeyword(Integer siteId, String txt) {
        if (StringUtils.isBlank((String)txt)) {
            return txt;
        }
        List<CmsKeyword> list = this.getListBySiteId(siteId, true, true);
        int len = list.size();
        if (len <= 0) {
            return txt;
        }
        String[] searchArr = new String[len];
        String[] replacementArr = new String[len];
        int i = 0;
        for (CmsKeyword k : list) {
            searchArr[i] = k.getName();
            replacementArr[i] = k.getUrl();
            ++i;
        }
        try {
            Node node;
            Lexer lexer = new Lexer(txt);
            StringBuilder sb = new StringBuilder((int)((double)txt.length() * 1.2));
            while ((node = lexer.nextNode()) != null) {
                if (node instanceof TextNode) {
                    sb.append(StringUtils.replaceEach((String)node.toHtml(), (String[])searchArr, (String[])replacementArr));
                    continue;
                }
                sb.append(node.toHtml());
            }
            return sb.toString();
        }
        catch (ParserException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public CmsKeyword findById(Integer id) {
        CmsKeyword entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public CmsKeyword save(CmsKeyword bean) {
        bean.init();
        this.dao.save(bean);
        return bean;
    }

    @Override
    public void updateKeywords(Integer[] ids, String[] names, String[] urls, Boolean[] disableds) {
        int i = 0;
        int len = ids.length;
        while (i < len) {
            CmsKeyword keyword = this.findById(ids[i]);
            keyword.setName(names[i]);
            keyword.setUrl(urls[i]);
            keyword.setDisabled(disableds[i]);
            ++i;
        }
    }

    @Override
    public CmsKeyword deleteById(Integer id) {
        CmsKeyword bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public CmsKeyword[] deleteByIds(Integer[] ids) {
        CmsKeyword[] beans = new CmsKeyword[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(CmsKeywordDao dao) {
        this.dao = dao;
    }
}

