/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.assist.impl;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.assist.CmsResourceMng;
import com.jeecms.common.file.FileWrap;
import com.jeecms.common.util.Zipper;
import com.jeecms.common.web.springmvc.RealPathResolver;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class CmsResourceMngImpl
implements CmsResourceMng {
    private static final Logger log = LoggerFactory.getLogger(CmsResourceMngImpl.class);
    private FileFilter filter = new FileFilter(){

        public boolean accept(File file) {
            return file.isDirectory() || FileWrap.editableExt((String)FilenameUtils.getExtension((String)file.getName()));
        }
    };
    private RealPathResolver realPathResolver;

    @Override
    public List<FileWrap> listFile(String path, boolean dirAndEditable) {
        File parent = new File(this.realPathResolver.get(path));
        if (parent.exists()) {
            File[] files = dirAndEditable ? parent.listFiles(this.filter) : parent.listFiles();
            Arrays.sort(files, new FileWrap.FileComparator());
            ArrayList<FileWrap> list = new ArrayList<FileWrap>(files.length);
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                list.add(new FileWrap(f, this.realPathResolver.get("")));
                ++n2;
            }
            return list;
        }
        return new ArrayList<FileWrap>(0);
    }

    @Override
    public boolean createDir(String path, String dirName) {
        File parent = new File(this.realPathResolver.get(path));
        parent.mkdirs();
        File dir = new File(parent, dirName);
        return dir.mkdir();
    }

    @Override
    public void saveFile(String path, MultipartFile file) throws IllegalStateException, IOException {
        File dest = new File(this.realPathResolver.get(path), file.getOriginalFilename());
        file.transferTo(dest);
    }

    @Override
    public void createFile(String path, String filename, String data) throws IOException {
        File parent = new File(this.realPathResolver.get(path));
        parent.mkdirs();
        File file = new File(parent, filename);
        FileUtils.writeStringToFile((File)file, (String)data, (String)"UTF-8");
    }

    @Override
    public String readFile(String name) throws IOException {
        File file = new File(this.realPathResolver.get(name));
        return FileUtils.readFileToString((File)file, (String)"UTF-8");
    }

    @Override
    public void updateFile(String name, String data) throws IOException {
        File file = new File(this.realPathResolver.get(name));
        FileUtils.writeStringToFile((File)file, (String)data, (String)"UTF-8");
    }

    @Override
    public int delete(String[] names) {
        int count = 0;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            File f = new File(this.realPathResolver.get(name));
            if (FileUtils.deleteQuietly((File)f)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    @Override
    public void rename(String origName, String destName) {
        File orig = new File(this.realPathResolver.get(origName));
        File dest = new File(this.realPathResolver.get(destName));
        orig.renameTo(dest);
    }

    @Override
    public void copyTplAndRes(CmsSite from, CmsSite to) throws IOException {
        String fromSol = from.getTplSolution();
        String toSol = to.getTplSolution();
        File tplFrom = new File(this.realPathResolver.get(from.getTplPath()), fromSol);
        File tplTo = new File(this.realPathResolver.get(to.getTplPath()), toSol);
        FileUtils.copyDirectory((File)tplFrom, (File)tplTo);
        File resFrom = new File(this.realPathResolver.get(from.getResPath()), fromSol);
        if (resFrom.exists()) {
            File resTo = new File(this.realPathResolver.get(to.getResPath()), toSol);
            FileUtils.copyDirectory((File)resFrom, (File)resTo);
        }
    }

    @Override
    public void delTplAndRes(CmsSite site) throws IOException {
        File tpl = new File(this.realPathResolver.get(site.getTplPath()));
        File res = new File(this.realPathResolver.get(site.getResPath()));
        FileUtils.deleteDirectory((File)tpl);
        FileUtils.deleteDirectory((File)res);
    }

    @Override
    public String[] getSolutions(String path) {
        File tpl = new File(this.realPathResolver.get(path));
        return tpl.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return dir.isDirectory();
            }
        });
    }

    @Override
    public List<Zipper.FileEntry> export(CmsSite site, String solution) {
        ArrayList<Zipper.FileEntry> fileEntrys = new ArrayList<Zipper.FileEntry>();
        File tpl = new File(this.realPathResolver.get(site.getTplPath()), solution);
        fileEntrys.add(new Zipper.FileEntry("", "", tpl));
        File res = new File(this.realPathResolver.get(site.getResPath()), solution);
        if (res.exists()) {
            File[] fileArray = res.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File r = fileArray[n2];
                fileEntrys.add(new Zipper.FileEntry("${res}", r));
                ++n2;
            }
        }
        return fileEntrys;
    }

    @Override
    public void imoport(File file, CmsSite site) throws IOException {
        String name;
        String resRoot = site.getResPath();
        String tplRoot = site.getTplPath();
        ZipFile zip = new ZipFile(file, "GBK");
        byte[] buf = new byte[1024];
        InputStream is = null;
        OutputStream os = null;
        String solution = null;
        Enumeration en = zip.getEntries();
        while (en.hasMoreElements()) {
            name = ((ZipEntry)en.nextElement()).getName();
            if (name.startsWith("${res}")) continue;
            solution = name.substring(0, name.indexOf("/"));
            break;
        }
        if (solution == null) {
            return;
        }
        en = zip.getEntries();
        while (en.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)en.nextElement();
            if (entry.isDirectory()) continue;
            name = entry.getName();
            log.debug("unzip file\uff1a{}", (Object)name);
            String filename = name.startsWith("${res}") ? String.valueOf(resRoot) + "/" + solution + name.substring("${res}".length()) : String.valueOf(tplRoot) + "/" + name;
            log.debug("\u89e3\u538b\u5730\u5740\uff1a{}", (Object)filename);
            File outFile = new File(this.realPathResolver.get(filename));
            File pfile = outFile.getParentFile();
            if (!pfile.exists()) {
                pfile.mkdirs();
            }
            try {
                int len;
                is = zip.getInputStream(entry);
                os = new FileOutputStream(outFile);
                while ((len = is.read(buf)) != -1) {
                    os.write(buf, 0, len);
                }
            }
            finally {
                if (is != null) {
                    is.close();
                    is = null;
                }
                if (os != null) {
                    os.close();
                    os = null;
                }
            }
        }
    }

    @Autowired
    public void setRealPathResolver(RealPathResolver realPathResolver) {
        this.realPathResolver = realPathResolver;
    }
}

