/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.assist.impl;

import com.jeecms.cms.dao.assist.CmsSensitivityDao;
import com.jeecms.cms.entity.assist.CmsSensitivity;
import com.jeecms.cms.manager.assist.CmsSensitivityMng;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class CmsSensitivityMngImpl
implements CmsSensitivityMng {
    private CmsSensitivityDao dao;

    @Override
    @Transactional(readOnly=true)
    public String replaceSensitivity(String s) {
        if (StringUtils.isBlank((String)s)) {
            return s;
        }
        List<CmsSensitivity> list = this.getList(true);
        for (CmsSensitivity sen : list) {
            s = StringUtils.replace((String)s, (String)sen.getSearch(), (String)sen.getReplacement());
        }
        return s;
    }

    @Override
    @Transactional(readOnly=true)
    public List<CmsSensitivity> getList(boolean cacheable) {
        return this.dao.getList(cacheable);
    }

    @Override
    @Transactional(readOnly=true)
    public CmsSensitivity findById(Integer id) {
        CmsSensitivity entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public CmsSensitivity save(CmsSensitivity bean) {
        this.dao.save(bean);
        return bean;
    }

    @Override
    public void updateEnsitivity(Integer[] ids, String[] searchs, String[] replacements) {
        int i = 0;
        int len = ids.length;
        while (i < len) {
            CmsSensitivity ensitivity = this.findById(ids[i]);
            ensitivity.setSearch(searchs[i]);
            ensitivity.setReplacement(replacements[i]);
            ++i;
        }
    }

    @Override
    public CmsSensitivity deleteById(Integer id) {
        CmsSensitivity bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public CmsSensitivity[] deleteByIds(Integer[] ids) {
        CmsSensitivity[] beans = new CmsSensitivity[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(CmsSensitivityDao dao) {
        this.dao = dao;
    }
}

