/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.assist.impl;

import com.jeecms.cms.dao.assist.CmsSiteFlowDao;
import com.jeecms.cms.entity.assist.CmsSiteFlow;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.assist.CmsSiteFlowMng;
import com.jeecms.cms.statistic.FlowBean;
import com.jeecms.common.util.DateFormatUtils;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CmsSiteFlowMngImpl
implements CmsSiteFlowMng {
    @Autowired
    private CmsSiteFlowDao dao;

    public CmsSiteFlow save(CmsSite site, String ip, String page, String sessionId) {
        CmsSiteFlow cmsSiteFlow = new CmsSiteFlow();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        cmsSiteFlow.setSite(site);
        cmsSiteFlow.setAccessIp(ip);
        cmsSiteFlow.setAccessPage(page);
        cmsSiteFlow.setAccessTime(now);
        cmsSiteFlow.setAccessDate(DateFormatUtils.formatDate((Date)now));
        cmsSiteFlow.setSessionId(sessionId);
        return this.dao.save(cmsSiteFlow);
    }

    @Transactional(readOnly=true)
    public CmsSiteFlow findUniqueByProperties(Integer siteId, String accessDate, String sessionId, String page) {
        return this.dao.findUniqueByProperties(siteId, accessDate, sessionId, page);
    }

    public int freshCacheToDB(Ehcache cache) {
        int count = 0;
        List list = cache.getKeys();
        for (FlowBean bean : list) {
            Element element = cache.get((Object)bean);
            if (element == null) {
                return count;
            }
            CmsSiteFlow cmsSiteFlow = (CmsSiteFlow)element.getValue();
            if (cmsSiteFlow.getId() != null || cmsSiteFlow.getSessionId() == null) continue;
            this.dao.save(cmsSiteFlow);
        }
        return count;
    }
}

