/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.assist.impl;

import com.jeecms.cms.dao.assist.CmsVoteItemDao;
import com.jeecms.cms.entity.assist.CmsVoteItem;
import com.jeecms.cms.entity.assist.CmsVoteTopic;
import com.jeecms.cms.manager.assist.CmsVoteItemMng;
import com.jeecms.common.hibernate3.Updater;
import com.jeecms.common.page.Pagination;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class CmsVoteItemMngImpl
implements CmsVoteItemMng {
    private CmsVoteItemDao dao;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public CmsVoteItem findById(Integer id) {
        CmsVoteItem entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public Collection<CmsVoteItem> save(Collection<CmsVoteItem> items, CmsVoteTopic topic) {
        for (CmsVoteItem item : items) {
            item.setTopic(topic);
            item.init();
            this.dao.save(item);
        }
        return items;
    }

    @Override
    public Collection<CmsVoteItem> update(Collection<CmsVoteItem> items, CmsVoteTopic topic) {
        Set<CmsVoteItem> set = topic.getItems();
        HashSet<CmsVoteItem> toDel = new HashSet<CmsVoteItem>();
        for (CmsVoteItem item : set) {
            if (items.contains(item)) continue;
            toDel.add(item);
        }
        set.removeAll(toDel);
        HashSet<CmsVoteItem> toAdd = new HashSet<CmsVoteItem>();
        for (CmsVoteItem item : items) {
            if (set.contains(item)) {
                Updater updater = new Updater((Object)item);
                this.dao.updateByUpdater((Updater<CmsVoteItem>)updater);
                continue;
            }
            toAdd.add(item);
        }
        this.save(toAdd, topic);
        set.addAll(toAdd);
        return set;
    }

    @Override
    public CmsVoteItem deleteById(Integer id) {
        CmsVoteItem bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public CmsVoteItem[] deleteByIds(Integer[] ids) {
        CmsVoteItem[] beans = new CmsVoteItem[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(CmsVoteItemDao dao) {
        this.dao = dao;
    }
}

