/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.assist.impl;

import com.jeecms.cms.dao.assist.CmsVoteRecordDao;
import com.jeecms.cms.entity.assist.CmsVoteRecord;
import com.jeecms.cms.entity.assist.CmsVoteTopic;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.manager.assist.CmsVoteRecordMng;
import java.sql.Timestamp;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class CmsVoteRecordMngImpl
implements CmsVoteRecordMng {
    private CmsVoteRecordDao dao;

    public CmsVoteRecord save(CmsVoteTopic topic, CmsUser user, String ip, String cookie) {
        CmsVoteRecord record = new CmsVoteRecord();
        record.setTopic(topic);
        record.setIp(ip);
        record.setCookie(cookie);
        record.setTime(new Timestamp(System.currentTimeMillis()));
        this.dao.save(record);
        return record;
    }

    public int deleteByTopic(Integer topicId) {
        return this.dao.deleteByTopic(topicId);
    }

    public Date lastVoteTimeByUserId(Integer userId, Integer topicId) {
        CmsVoteRecord record = this.dao.findByUserId(userId, topicId);
        return record != null ? record.getTime() : null;
    }

    public Date lastVoteTimeByIp(String ip, Integer topicId) {
        CmsVoteRecord record = this.dao.findByIp(ip, topicId);
        return record != null ? record.getTime() : null;
    }

    public Date lastVoteTimeByCookie(String cookie, Integer topicId) {
        CmsVoteRecord record = this.dao.findByCookie(cookie, topicId);
        return record != null ? record.getTime() : null;
    }

    @Autowired
    public void setDao(CmsVoteRecordDao dao) {
        this.dao = dao;
    }
}

