/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.assist.impl;

import com.jeecms.cms.dao.assist.CmsVoteTopicDao;
import com.jeecms.cms.entity.assist.CmsVoteItem;
import com.jeecms.cms.entity.assist.CmsVoteTopic;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.manager.assist.CmsVoteItemMng;
import com.jeecms.cms.manager.assist.CmsVoteRecordMng;
import com.jeecms.cms.manager.assist.CmsVoteTopicMng;
import com.jeecms.common.hibernate3.Updater;
import com.jeecms.common.page.Pagination;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class CmsVoteTopicMngImpl
implements CmsVoteTopicMng {
    private CmsVoteItemMng cmsVoteItemMng;
    private CmsVoteRecordMng cmsVoteRecordMng;
    private CmsVoteTopicDao dao;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(Integer siteId, int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(siteId, pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public CmsVoteTopic findById(Integer id) {
        CmsVoteTopic entity = this.dao.findById(id);
        return entity;
    }

    @Override
    @Transactional(readOnly=true)
    public CmsVoteTopic getDefTopic(Integer siteId) {
        return this.dao.getDefTopic(siteId);
    }

    @Override
    public CmsVoteTopic save(CmsVoteTopic bean, List<CmsVoteItem> items) {
        int totalCount = 0;
        for (CmsVoteItem item : items) {
            if (item.getVoteCount() == null) continue;
            totalCount += item.getVoteCount().intValue();
        }
        bean.setTotalCount(totalCount);
        bean.init();
        this.dao.save(bean);
        this.cmsVoteItemMng.save(items, bean);
        return bean;
    }

    @Override
    public CmsVoteTopic update(CmsVoteTopic bean, Collection<CmsVoteItem> items) {
        Updater updater = new Updater((Object)bean);
        updater.include(CmsVoteTopic.PROP_START_TIME);
        updater.include(CmsVoteTopic.PROP_END_TIME);
        bean = this.dao.updateByUpdater((Updater<CmsVoteTopic>)updater);
        int totalCount = 0;
        for (CmsVoteItem item : items) {
            totalCount += item.getVoteCount().intValue();
        }
        bean.setTotalCount(totalCount);
        this.cmsVoteItemMng.update(items, bean);
        return bean;
    }

    @Override
    public CmsVoteTopic vote(Integer topicId, Integer[] itemIds, CmsUser user, String ip, String cookie) {
        CmsVoteTopic topic = this.findById(topicId);
        Set<CmsVoteItem> items = topic.getItems();
        int totalCount = topic.getTotalCount();
        for (CmsVoteItem item : items) {
            if (!ArrayUtils.contains((Object[])itemIds, (Object)item.getId())) continue;
            item.setVoteCount(item.getVoteCount() + 1);
            ++totalCount;
        }
        topic.setTotalCount(totalCount);
        if ((topic.getRepeateHour() == null || topic.getRepeateHour() > 0) && (topic.getRestrictMember().booleanValue() || topic.getRestrictIp().booleanValue() || topic.getRestrictCookie().booleanValue())) {
            this.cmsVoteRecordMng.save(topic, user, ip, cookie);
        }
        return topic;
    }

    @Override
    public CmsVoteTopic deleteById(Integer id) {
        CmsVoteTopic bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public CmsVoteTopic[] deleteByIds(Integer[] ids) {
        CmsVoteTopic[] beans = new CmsVoteTopic[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setCmsVoteItemMng(CmsVoteItemMng cmsVoteItemMng) {
        this.cmsVoteItemMng = cmsVoteItemMng;
    }

    @Autowired
    public void setCmsVoteRecordMng(CmsVoteRecordMng cmsVoteRecordMng) {
        this.cmsVoteRecordMng = cmsVoteRecordMng;
    }

    @Autowired
    public void setDao(CmsVoteTopicDao dao) {
        this.dao = dao;
    }
}

