/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.main.impl;

import com.jeecms.cms.dao.main.ChannelDao;
import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.ChannelExt;
import com.jeecms.cms.entity.main.ChannelTxt;
import com.jeecms.cms.entity.main.CmsGroup;
import com.jeecms.cms.entity.main.CmsModel;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.CmsUserSite;
import com.jeecms.cms.manager.main.ChannelExtMng;
import com.jeecms.cms.manager.main.ChannelMng;
import com.jeecms.cms.manager.main.ChannelTxtMng;
import com.jeecms.cms.manager.main.CmsGroupMng;
import com.jeecms.cms.manager.main.CmsModelMng;
import com.jeecms.cms.manager.main.CmsSiteMng;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.service.ChannelDeleteChecker;
import com.jeecms.common.hibernate3.Updater;
import com.jeecms.common.page.Pagination;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class ChannelMngImpl
implements ChannelMng {
    private List<ChannelDeleteChecker> deleteCheckerList;
    private CmsSiteMng cmsSiteMng;
    private CmsModelMng cmsModelMng;
    private ChannelExtMng channelExtMng;
    private ChannelTxtMng channelTxtMng;
    private CmsUserMng cmsUserMng;
    private CmsGroupMng cmsGroupMng;
    private ChannelDao dao;

    @Override
    @Transactional(readOnly=true)
    public List<Channel> getTopList(Integer siteId, boolean hasContentOnly) {
        return this.dao.getTopList(siteId, hasContentOnly, false, false);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Channel> getTopListByRigth(Integer userId, Integer siteId, boolean hasContentOnly) {
        CmsUser user = this.cmsUserMng.findById(userId);
        CmsUserSite us = user.getUserSite(siteId);
        if (us.getAllChannel().booleanValue()) {
            return this.getTopList(siteId, hasContentOnly);
        }
        return this.dao.getTopListByRigth(userId, siteId, hasContentOnly);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Channel> getTopListForTag(Integer siteId, boolean hasContentOnly) {
        return this.dao.getTopList(siteId, hasContentOnly, true, true);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getTopPageForTag(Integer siteId, boolean hasContentOnly, int pageNo, int pageSize) {
        return this.dao.getTopPage(siteId, hasContentOnly, false, false, pageNo, pageSize);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Channel> getChildList(Integer parentId, boolean hasContentOnly) {
        return this.dao.getChildList(parentId, hasContentOnly, false, false);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Channel> getChildListByRight(Integer userId, Integer siteId, Integer parentId, boolean hasContentOnly) {
        CmsUser user = this.cmsUserMng.findById(userId);
        CmsUserSite us = user.getUserSite(siteId);
        if (us.getAllChannel().booleanValue()) {
            return this.getChildList(parentId, hasContentOnly);
        }
        return this.dao.getChildListByRight(userId, parentId, hasContentOnly);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Channel> getChildListForTag(Integer parentId, boolean hasContentOnly) {
        return this.dao.getChildList(parentId, hasContentOnly, true, true);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getChildPageForTag(Integer parentId, boolean hasContentOnly, int pageNo, int pageSize) {
        return this.dao.getChildPage(parentId, hasContentOnly, true, true, pageNo, pageSize);
    }

    @Override
    @Transactional(readOnly=true)
    public Channel findById(Integer id) {
        Channel entity = this.dao.findById(id);
        return entity;
    }

    @Override
    @Transactional(readOnly=true)
    public Channel findByPath(String path, Integer siteId) {
        return this.dao.findByPath(path, siteId, false);
    }

    @Override
    @Transactional(readOnly=true)
    public Channel findByPathForTag(String path, Integer siteId) {
        return this.dao.findByPath(path, siteId, true);
    }

    @Override
    public Channel save(Channel bean, ChannelExt ext, ChannelTxt txt, Integer[] viewGroupIds, Integer[] contriGroupIds, Integer[] userIds, Integer siteId, Integer parentId, Integer modelId) {
        CmsGroup g;
        Integer gid;
        int n;
        int n2;
        Integer[] integerArray;
        if (parentId != null) {
            bean.setParent(this.findById(parentId));
        }
        bean.setSite(this.cmsSiteMng.findById(siteId));
        CmsModel model = this.cmsModelMng.findById(modelId);
        bean.setModel(model);
        bean.setHasContent(model.getHasContent());
        bean.init();
        this.dao.save(bean);
        this.channelExtMng.save(ext, bean);
        this.channelTxtMng.save(txt, bean);
        if (viewGroupIds != null && viewGroupIds.length > 0) {
            integerArray = viewGroupIds;
            n2 = viewGroupIds.length;
            n = 0;
            while (n < n2) {
                gid = integerArray[n];
                g = this.cmsGroupMng.findById(gid);
                bean.addToViewGroups(g);
                ++n;
            }
        }
        if (contriGroupIds != null && contriGroupIds.length > 0) {
            integerArray = contriGroupIds;
            n2 = contriGroupIds.length;
            n = 0;
            while (n < n2) {
                gid = integerArray[n];
                g = this.cmsGroupMng.findById(gid);
                bean.addToContriGroups(g);
                ++n;
            }
        }
        if (userIds != null && userIds.length > 0) {
            Integer[] integerArray2 = userIds;
            int n3 = userIds.length;
            n2 = 0;
            while (n2 < n3) {
                Integer uid = integerArray2[n2];
                CmsUser u = this.cmsUserMng.findById(uid);
                bean.addToUsers(u);
                ++n2;
            }
        }
        return bean;
    }

    @Override
    public Channel update(Channel bean, ChannelExt ext, ChannelTxt txt, Integer[] viewGroupIds, Integer[] contriGroupIds, Integer[] userIds, Integer parentId, Map<String, String> attr) {
        Object gid;
        int n;
        int n2;
        Integer[] integerArray;
        CmsGroup g2;
        Updater updater = new Updater((Object)bean);
        bean = this.dao.updateByUpdater((Updater<Channel>)updater);
        Channel parent = parentId != null ? this.findById(parentId) : null;
        bean.setParent(parent);
        this.channelExtMng.update(ext);
        this.channelTxtMng.update(txt, bean);
        Map<String, String> attrOrig = bean.getAttr();
        attrOrig.clear();
        attrOrig.putAll(attr);
        for (CmsGroup g2 : bean.getViewGroups()) {
            g2.getViewChannels().remove(bean);
        }
        bean.getViewGroups().clear();
        if (viewGroupIds != null && viewGroupIds.length > 0) {
            integerArray = viewGroupIds;
            n2 = viewGroupIds.length;
            n = 0;
            while (n < n2) {
                gid = integerArray[n];
                g2 = this.cmsGroupMng.findById((Integer)gid);
                bean.addToViewGroups(g2);
                ++n;
            }
        }
        for (CmsGroup g2 : bean.getContriGroups()) {
            g2.getContriChannels().remove(bean);
        }
        bean.getContriGroups().clear();
        if (contriGroupIds != null && contriGroupIds.length > 0) {
            integerArray = contriGroupIds;
            n2 = contriGroupIds.length;
            n = 0;
            while (n < n2) {
                gid = integerArray[n];
                g2 = this.cmsGroupMng.findById((Integer)gid);
                bean.addToContriGroups(g2);
                ++n;
            }
        }
        for (CmsUser u : bean.getUsers()) {
            u.getChannels().remove(bean);
        }
        bean.getUsers().clear();
        if (userIds != null && userIds.length > 0) {
            integerArray = userIds;
            n2 = userIds.length;
            n = 0;
            while (n < n2) {
                CmsUser u;
                Integer uid = integerArray[n];
                u = this.cmsUserMng.findById(uid);
                bean.addToUsers(u);
                ++n;
            }
        }
        return bean;
    }

    @Override
    public Channel deleteById(Integer id) {
        Channel entity = this.dao.findById(id);
        for (CmsGroup group : entity.getViewGroups()) {
            group.getViewChannels().remove(entity);
        }
        for (CmsGroup group : entity.getContriGroups()) {
            group.getContriChannels().remove(entity);
        }
        entity = this.dao.deleteById(id);
        return entity;
    }

    @Override
    public Channel[] deleteByIds(Integer[] ids) {
        Channel[] beans = new Channel[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public String checkDelete(Integer id) {
        String msg = null;
        for (ChannelDeleteChecker checker : this.deleteCheckerList) {
            msg = checker.checkForChannelDelete(id);
            if (msg == null) continue;
            return msg;
        }
        return msg;
    }

    @Override
    public Channel[] updatePriority(Integer[] ids, Integer[] priority) {
        int len = ids.length;
        Channel[] beans = new Channel[len];
        int i = 0;
        while (i < len) {
            beans[i] = this.findById(ids[i]);
            beans[i].setPriority(priority[i]);
            ++i;
        }
        return beans;
    }

    public void setDeleteCheckerList(List<ChannelDeleteChecker> deleteCheckerList) {
        this.deleteCheckerList = deleteCheckerList;
    }

    @Autowired
    public void setCmsSiteMng(CmsSiteMng cmsSiteMng) {
        this.cmsSiteMng = cmsSiteMng;
    }

    @Autowired
    public void setCmsModelMng(CmsModelMng cmsModelMng) {
        this.cmsModelMng = cmsModelMng;
    }

    @Autowired
    public void setChannelExtMng(ChannelExtMng channelExtMng) {
        this.channelExtMng = channelExtMng;
    }

    @Autowired
    public void setChannelTxtMng(ChannelTxtMng channelTxtMng) {
        this.channelTxtMng = channelTxtMng;
    }

    @Autowired
    public void setCmsUserMng(CmsUserMng cmsUserMng) {
        this.cmsUserMng = cmsUserMng;
    }

    @Autowired
    public void setCmsGroupMng(CmsGroupMng cmsGroupMng) {
        this.cmsGroupMng = cmsGroupMng;
    }

    @Autowired
    public void setDao(ChannelDao dao) {
        this.dao = dao;
    }
}

