/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.main.impl;

import com.jeecms.cms.dao.main.CmsLogDao;
import com.jeecms.cms.entity.main.CmsLog;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.manager.main.CmsLogMng;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.web.RequestUtils;
import com.jeecms.common.web.springmvc.MessageResolver;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.util.UrlPathHelper;

@Service
@Transactional
public class CmsLogMngImpl
implements CmsLogMng {
    private CmsUserMng cmsUserMng;
    private CmsLogDao dao;

    @Transactional(readOnly=true)
    public Pagination getPage(Integer category, Integer siteId, String username, String title, String ip, int pageNo, int pageSize) {
        CmsUser user;
        Pagination page = StringUtils.isBlank((String)username) ? this.dao.getPage(category, siteId, null, title, ip, pageNo, pageSize) : ((user = this.cmsUserMng.findByUsername(username)) != null ? this.dao.getPage(category, siteId, (Integer)user.getId(), title, ip, pageNo, pageSize) : new Pagination(1, pageSize, 0, new ArrayList(0)));
        return page;
    }

    @Transactional(readOnly=true)
    public CmsLog findById(Integer id) {
        CmsLog entity = this.dao.findById(id);
        return entity;
    }

    public CmsLog save(Integer category, CmsSite site, CmsUser user, String url, String ip, Date date, String title, String content) {
        CmsLog log = new CmsLog();
        log.setSite(site);
        log.setUser(user);
        log.setCategory(category);
        log.setIp(ip);
        log.setTime(date);
        log.setUrl(url);
        log.setTitle(title);
        log.setContent(content);
        this.save(log);
        return log;
    }

    public CmsLog loginSuccess(HttpServletRequest request, CmsUser user, String title) {
        String ip = RequestUtils.getIpAddr((HttpServletRequest)request);
        UrlPathHelper helper = new UrlPathHelper();
        String uri = helper.getOriginatingRequestUri(request);
        Date date = new Date();
        CmsLog log = this.save(1, null, user, uri, ip, date, MessageResolver.getMessage((HttpServletRequest)request, (String)title, (Object[])new Object[0]), null);
        return log;
    }

    public CmsLog loginFailure(HttpServletRequest request, String title, String content) {
        String ip = RequestUtils.getIpAddr((HttpServletRequest)request);
        UrlPathHelper helper = new UrlPathHelper();
        String uri = helper.getOriginatingRequestUri(request);
        Date date = new Date();
        CmsLog log = this.save(2, null, null, uri, ip, date, MessageResolver.getMessage((HttpServletRequest)request, (String)title, (Object[])new Object[0]), content);
        return log;
    }

    public CmsLog operating(HttpServletRequest request, String title, String content) {
        CmsSite site = CmsUtils.getSite(request);
        CmsUser user = CmsUtils.getUser(request);
        String ip = RequestUtils.getIpAddr((HttpServletRequest)request);
        UrlPathHelper helper = new UrlPathHelper();
        String uri = helper.getOriginatingRequestUri(request);
        Date date = new Date();
        CmsLog log = this.save(3, site, user, uri, ip, date, MessageResolver.getMessage((HttpServletRequest)request, (String)title, (Object[])new Object[0]), content);
        return log;
    }

    public CmsLog save(CmsLog bean) {
        this.dao.save(bean);
        return bean;
    }

    public int deleteBatch(Integer category, Integer siteId, Integer days) {
        Date date = null;
        if (days != null && days > 0) {
            Calendar cal = Calendar.getInstance();
            cal.add(5, -days.intValue());
            date = cal.getTime();
        }
        return this.dao.deleteBatch(category, siteId, date);
    }

    public CmsLog deleteById(Integer id) {
        CmsLog bean = this.dao.deleteById(id);
        return bean;
    }

    public CmsLog[] deleteByIds(Integer[] ids) {
        CmsLog[] beans = new CmsLog[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setCmsUserMng(CmsUserMng cmsUserMng) {
        this.cmsUserMng = cmsUserMng;
    }

    @Autowired
    public void setDao(CmsLogDao dao) {
        this.dao = dao;
    }
}

