/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.main.impl;

import com.jeecms.cms.dao.main.CmsModelItemDao;
import com.jeecms.cms.entity.main.CmsModelItem;
import com.jeecms.cms.manager.main.CmsModelItemMng;
import com.jeecms.cms.manager.main.CmsModelMng;
import com.jeecms.common.hibernate3.Updater;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class CmsModelItemMngImpl
implements CmsModelItemMng {
    private CmsModelMng cmsModelMng;
    private CmsModelItemDao dao;

    @Override
    @Transactional(readOnly=true)
    public List<CmsModelItem> getList(Integer modelId, boolean isChannel, boolean hasDisabled) {
        return this.dao.getList(modelId, isChannel, hasDisabled);
    }

    @Override
    @Transactional(readOnly=true)
    public CmsModelItem findById(Integer id) {
        CmsModelItem entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public CmsModelItem save(CmsModelItem bean, Integer modelId) {
        bean.setModel(this.cmsModelMng.findById(modelId));
        return this.save(bean);
    }

    @Override
    public CmsModelItem save(CmsModelItem bean) {
        bean.init();
        this.dao.save(bean);
        return bean;
    }

    @Override
    public void saveList(List<CmsModelItem> list) {
        for (CmsModelItem item : list) {
            this.save(item);
        }
    }

    @Override
    public void updatePriority(Integer[] wids, Integer[] priority, String[] label, Boolean[] single, Boolean[] display) {
        int i = 0;
        int len = wids.length;
        while (i < len) {
            CmsModelItem item = this.findById(wids[i]);
            item.setLabel(label[i]);
            item.setPriority(priority[i]);
            item.setSingle(single[i]);
            item.setDisplay(display[i]);
            ++i;
        }
    }

    @Override
    public CmsModelItem update(CmsModelItem bean) {
        Updater updater = new Updater((Object)bean);
        CmsModelItem entity = this.dao.updateByUpdater((Updater<CmsModelItem>)updater);
        entity.emptyToNull();
        return entity;
    }

    @Override
    public CmsModelItem deleteById(Integer id) {
        CmsModelItem bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public CmsModelItem[] deleteByIds(Integer[] ids) {
        CmsModelItem[] beans = new CmsModelItem[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setCmsModelMng(CmsModelMng cmsModelMng) {
        this.cmsModelMng = cmsModelMng;
    }

    @Autowired
    public void setDao(CmsModelItemDao dao) {
        this.dao = dao;
    }
}

