/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.main.impl;

import com.jeecms.cms.dao.main.CmsModelDao;
import com.jeecms.cms.entity.main.CmsModel;
import com.jeecms.cms.manager.main.CmsModelMng;
import com.jeecms.common.hibernate3.Updater;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class CmsModelMngImpl
implements CmsModelMng {
    private CmsModelDao dao;

    @Override
    @Transactional(readOnly=true)
    public List<CmsModel> getList(boolean containDisabled) {
        return this.dao.getList(containDisabled);
    }

    @Override
    public CmsModel getDefModel() {
        return this.dao.getDefModel();
    }

    @Override
    @Transactional(readOnly=true)
    public CmsModel findById(Integer id) {
        CmsModel entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public CmsModel save(CmsModel bean) {
        bean.init();
        this.dao.save(bean);
        return bean;
    }

    @Override
    public CmsModel update(CmsModel bean) {
        Updater updater = new Updater((Object)bean);
        CmsModel entity = this.dao.updateByUpdater((Updater<CmsModel>)updater);
        return entity;
    }

    @Override
    public CmsModel deleteById(Integer id) {
        CmsModel bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public CmsModel[] deleteByIds(Integer[] ids) {
        CmsModel[] beans = new CmsModel[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public CmsModel[] updatePriority(Integer[] ids, Integer[] priority, Boolean[] disabled, Integer defId) {
        int len = ids.length;
        CmsModel[] beans = new CmsModel[len];
        int i = 0;
        while (i < len) {
            beans[i] = this.findById(ids[i]);
            beans[i].setPriority(priority[i]);
            beans[i].setDisabled(disabled[i]);
            if (beans[i].getId().equals(defId)) {
                beans[i].setDef(true);
            } else {
                beans[i].setDef(false);
            }
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(CmsModelDao dao) {
        this.dao = dao;
    }
}

