/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.main.impl;

import com.jeecms.cms.dao.main.CmsSiteDao;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.manager.assist.CmsResourceMng;
import com.jeecms.cms.manager.main.CmsSiteMng;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.manager.main.CmsUserSiteMng;
import com.jeecms.common.hibernate3.Updater;
import com.jeecms.core.manager.FtpMng;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class CmsSiteMngImpl
implements CmsSiteMng {
    private static final Logger log = LoggerFactory.getLogger(CmsSiteMngImpl.class);
    private CmsUserMng cmsUserMng;
    private CmsUserSiteMng cmsUserSiteMng;
    private CmsResourceMng cmsResourceMng;
    private FtpMng ftpMng;
    private CmsSiteDao dao;

    @Override
    @Transactional(readOnly=true)
    public List<CmsSite> getList() {
        return this.dao.getList(false);
    }

    @Override
    @Transactional(readOnly=true)
    public List<CmsSite> getListFromCache() {
        return this.dao.getList(true);
    }

    @Override
    @Transactional(readOnly=true)
    public CmsSite findByDomain(String domain, boolean cacheable) {
        return this.dao.findByDomain(domain, cacheable);
    }

    @Override
    @Transactional(readOnly=true)
    public CmsSite findById(Integer id) {
        CmsSite entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public CmsSite save(CmsSite currSite, CmsUser currUser, CmsSite bean, Integer uploadFtpId) throws IOException {
        if (uploadFtpId != null) {
            bean.setUploadFtp(this.ftpMng.findById(uploadFtpId));
        }
        bean.init();
        this.dao.save(bean);
        this.cmsResourceMng.copyTplAndRes(currSite, bean);
        this.cmsUserMng.addSiteToUser(currUser, bean, bean.getFinalStep());
        return bean;
    }

    @Override
    public CmsSite update(CmsSite bean, Integer uploadFtpId) {
        CmsSite entity = this.findById(bean.getId());
        if (uploadFtpId != null) {
            entity.setUploadFtp(this.ftpMng.findById(uploadFtpId));
        } else {
            entity.setUploadFtp(null);
        }
        Updater updater = new Updater((Object)bean);
        entity = this.dao.updateByUpdater((Updater<CmsSite>)updater);
        return entity;
    }

    @Override
    public void updateTplSolution(Integer siteId, String solution) {
        CmsSite site = this.findById(siteId);
        site.setTplSolution(solution);
    }

    @Override
    public CmsSite deleteById(Integer id) {
        this.cmsUserSiteMng.deleteBySiteId(id);
        CmsSite bean = this.dao.deleteById(id);
        try {
            this.cmsResourceMng.delTplAndRes(bean);
        }
        catch (IOException e) {
            log.error("delete Template and Resource fail!", (Throwable)e);
        }
        return bean;
    }

    @Override
    public CmsSite[] deleteByIds(Integer[] ids) {
        CmsSite[] beans = new CmsSite[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setCmsUserMng(CmsUserMng cmsUserMng) {
        this.cmsUserMng = cmsUserMng;
    }

    @Autowired
    public void setCmsUserSiteMng(CmsUserSiteMng cmsUserSiteMng) {
        this.cmsUserSiteMng = cmsUserSiteMng;
    }

    @Autowired
    public void setCmsResourceMng(CmsResourceMng cmsResourceMng) {
        this.cmsResourceMng = cmsResourceMng;
    }

    @Autowired
    public void setFtpMng(FtpMng ftpMng) {
        this.ftpMng = ftpMng;
    }

    @Autowired
    public void setDao(CmsSiteDao dao) {
        this.dao = dao;
    }
}

