/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.main.impl;

import com.jeecms.cms.dao.main.CmsTopicDao;
import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsTopic;
import com.jeecms.cms.manager.main.ChannelMng;
import com.jeecms.cms.manager.main.CmsTopicMng;
import com.jeecms.cms.service.ChannelDeleteChecker;
import com.jeecms.common.hibernate3.Updater;
import com.jeecms.common.page.Pagination;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class CmsTopicMngImpl
implements CmsTopicMng,
ChannelDeleteChecker {
    private ChannelMng channelMng;
    private CmsTopicDao dao;

    @Override
    @Transactional(readOnly=true)
    public List<CmsTopic> getListForTag(Integer channelId, boolean recommend, Integer count) {
        return this.dao.getList(channelId, recommend, count, true);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPageForTag(Integer channelId, boolean recommend, int pageNo, int pageSize) {
        return this.dao.getPage(channelId, recommend, pageNo, pageSize, true);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(null, false, pageNo, pageSize, false);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public List<CmsTopic> getListByChannel(Integer channelId) {
        List<CmsTopic> list = this.dao.getGlobalTopicList();
        Channel c = this.channelMng.findById(channelId);
        list.addAll(this.dao.getListByChannelIds(c.getNodeIds()));
        return list;
    }

    @Override
    @Transactional(readOnly=true)
    public CmsTopic findById(Integer id) {
        CmsTopic entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public CmsTopic save(CmsTopic bean, Integer channelId) {
        if (channelId != null) {
            bean.setChannel(this.channelMng.findById(channelId));
        }
        bean.init();
        this.dao.save(bean);
        return bean;
    }

    @Override
    public CmsTopic update(CmsTopic bean, Integer channelId) {
        Updater updater = new Updater((Object)bean);
        CmsTopic entity = this.dao.updateByUpdater((Updater<CmsTopic>)updater);
        if (channelId != null) {
            entity.setChannel(this.channelMng.findById(channelId));
        } else {
            entity.setChannel(null);
        }
        entity.blankToNull();
        return entity;
    }

    @Override
    public CmsTopic deleteById(Integer id) {
        this.dao.deleteContentRef(id);
        CmsTopic bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public CmsTopic[] deleteByIds(Integer[] ids) {
        CmsTopic[] beans = new CmsTopic[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public CmsTopic[] updatePriority(Integer[] ids, Integer[] priority) {
        int len = ids.length;
        CmsTopic[] beans = new CmsTopic[len];
        int i = 0;
        while (i < len) {
            beans[i] = this.findById(ids[i]);
            beans[i].setPriority(priority[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public String checkForChannelDelete(Integer channelId) {
        if (this.dao.countByChannelId(channelId) > 0) {
            return "cmsTopic.error.cannotDeleteChannel";
        }
        return null;
    }

    @Autowired
    public void setDao(CmsTopicDao dao) {
        this.dao = dao;
    }

    @Autowired
    public void setChannelMng(ChannelMng channelMng) {
        this.channelMng = channelMng;
    }
}

