/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.main.impl;

import com.jeecms.cms.dao.main.CmsUserDao;
import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsGroup;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.CmsUserExt;
import com.jeecms.cms.manager.main.ChannelMng;
import com.jeecms.cms.manager.main.CmsGroupMng;
import com.jeecms.cms.manager.main.CmsRoleMng;
import com.jeecms.cms.manager.main.CmsSiteMng;
import com.jeecms.cms.manager.main.CmsUserExtMng;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.manager.main.CmsUserSiteMng;
import com.jeecms.cms.manager.main.ContentMng;
import com.jeecms.common.email.EmailSender;
import com.jeecms.common.email.MessageTemplate;
import com.jeecms.common.hibernate3.Updater;
import com.jeecms.common.page.Pagination;
import com.jeecms.core.entity.UnifiedUser;
import com.jeecms.core.manager.UnifiedUserMng;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class CmsUserMngImpl
implements CmsUserMng {
    private CmsUserSiteMng cmsUserSiteMng;
    private CmsSiteMng cmsSiteMng;
    private ChannelMng channelMng;
    private CmsRoleMng cmsRoleMng;
    private CmsGroupMng cmsGroupMng;
    private UnifiedUserMng unifiedUserMng;
    private CmsUserExtMng cmsUserExtMng;
    private CmsUserDao dao;
    @Autowired
    private ContentMng contentMng;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(String username, String email, Integer siteId, Integer groupId, Boolean disabled, Boolean admin, Integer rank, int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(username, email, siteId, groupId, disabled, admin, rank, pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public List getList(String username, String email, Integer siteId, Integer groupId, Boolean disabled, Boolean admin, Integer rank) {
        List list = this.dao.getList(username, email, siteId, groupId, disabled, admin, rank);
        return list;
    }

    @Override
    @Transactional(readOnly=true)
    public List<CmsUser> getAdminList(Integer siteId, Boolean allChannel, Boolean disabled, Integer rank) {
        return this.dao.getAdminList(siteId, allChannel, disabled, rank);
    }

    @Override
    @Transactional(readOnly=true)
    public CmsUser findById(Integer id) {
        CmsUser entity = this.dao.findById(id);
        return entity;
    }

    @Override
    @Transactional(readOnly=true)
    public CmsUser findByUsername(String username) {
        CmsUser entity = this.dao.findByUsername(username);
        return entity;
    }

    @Override
    public CmsUser registerMember(String username, String email, String password, String ip, Integer groupId, CmsUserExt userExt) {
        return this.registerMember(username, email, password, ip, groupId, userExt, true, null, null);
    }

    @Override
    public CmsUser registerMember(String username, String email, String password, String ip, Integer groupId, CmsUserExt userExt, Boolean activation, EmailSender sender, MessageTemplate msgTpl) {
        UnifiedUser unifiedUser = this.unifiedUserMng.save(username, email, password, ip, activation, sender, msgTpl);
        CmsUser user = new CmsUser();
        user.forMember(unifiedUser);
        CmsGroup group = null;
        group = groupId != null ? this.cmsGroupMng.findById(groupId) : this.cmsGroupMng.getRegDef();
        if (group == null) {
            throw new RuntimeException("register default member group not found!");
        }
        user.setGroup(group);
        user.init();
        this.dao.save(user);
        this.cmsUserExtMng.save(userExt, user);
        return user;
    }

    @Override
    public void updateLoginInfo(Integer userId, String ip) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        CmsUser user = this.findById(userId);
        if (user != null) {
            user.setLoginCount(user.getLoginCount() + 1);
            user.setLastLoginIp(ip);
            user.setLastLoginTime(now);
        }
    }

    @Override
    public void updateUploadSize(Integer userId, Integer size) {
        CmsUser user = this.findById(userId);
        user.setUploadTotal(user.getUploadTotal() + (long)size.intValue());
        if (user.getUploadDate() != null && CmsUser.isToday(user.getUploadDate())) {
            size = size + user.getUploadSize();
        }
        user.setUploadDate(new Date(System.currentTimeMillis()));
        user.setUploadSize(size);
    }

    @Override
    public boolean isPasswordValid(Integer id, String password) {
        return this.unifiedUserMng.isPasswordValid(id, password);
    }

    @Override
    public void updatePwdEmail(Integer id, String password, String email) {
        CmsUser user = this.findById(id);
        if (!StringUtils.isBlank((String)email)) {
            user.setEmail(email);
        } else {
            user.setEmail(null);
        }
        this.unifiedUserMng.update(id, password, email);
    }

    @Override
    public CmsUser saveAdmin(String username, String email, String password, String ip, boolean viewOnly, boolean selfAdmin, int rank, Integer groupId, Integer[] roleIds, Integer[] channelIds, Integer[] siteIds, Byte[] steps, Boolean[] allChannels, CmsUserExt userExt) {
        int n;
        UnifiedUser unifiedUser = this.unifiedUserMng.save(username, email, password, ip);
        CmsUser user = new CmsUser();
        user.forAdmin(unifiedUser, viewOnly, selfAdmin, rank);
        CmsGroup group = null;
        group = groupId != null ? this.cmsGroupMng.findById(groupId) : this.cmsGroupMng.getRegDef();
        if (group == null) {
            throw new RuntimeException("register default member group not setted!");
        }
        user.setGroup(group);
        user.init();
        this.dao.save(user);
        this.cmsUserExtMng.save(userExt, user);
        if (roleIds != null) {
            Integer[] integerArray = roleIds;
            n = roleIds.length;
            int n2 = 0;
            while (n2 < n) {
                Integer rid = integerArray[n2];
                user.addToRoles(this.cmsRoleMng.findById(rid));
                ++n2;
            }
        }
        if (channelIds != null) {
            Integer[] integerArray = channelIds;
            int n3 = channelIds.length;
            n = 0;
            while (n < n3) {
                Integer cid = integerArray[n];
                Channel channel = this.channelMng.findById(cid);
                channel.addToUsers(user);
                ++n;
            }
        }
        if (siteIds != null) {
            int i = 0;
            int len = siteIds.length;
            while (i < len) {
                CmsSite site = this.cmsSiteMng.findById(siteIds[i]);
                this.cmsUserSiteMng.save(site, user, steps[i], allChannels[i]);
                ++i;
            }
        }
        return user;
    }

    @Override
    public void addSiteToUser(CmsUser user, CmsSite site, Byte checkStep) {
        this.cmsUserSiteMng.save(site, user, checkStep, true);
    }

    @Override
    public CmsUser updateAdmin(CmsUser bean, CmsUserExt ext, String password, Integer groupId, Integer[] roleIds, Integer[] channelIds, Integer siteId, Byte step, Boolean allChannel) {
        CmsUser user = this.updateAdmin(bean, ext, password, groupId, roleIds, channelIds);
        this.cmsUserSiteMng.updateByUser(user, siteId, step, allChannel);
        return user;
    }

    @Override
    public CmsUser updateAdmin(CmsUser bean, CmsUserExt ext, String password, Integer groupId, Integer[] roleIds, Integer[] channelIds, Integer[] siteIds, Byte[] steps, Boolean[] allChannels) {
        CmsUser user = this.updateAdmin(bean, ext, password, groupId, roleIds, channelIds);
        this.cmsUserSiteMng.updateByUser(user, siteIds, steps, allChannels);
        return user;
    }

    private CmsUser updateAdmin(CmsUser bean, CmsUserExt ext, String password, Integer groupId, Integer[] roleIds, Integer[] channelIds) {
        Updater updater = new Updater((Object)bean);
        updater.include("email");
        CmsUser user = this.dao.updateByUpdater((Updater<CmsUser>)updater);
        user.setGroup(this.cmsGroupMng.findById(groupId));
        this.cmsUserExtMng.update(ext, user);
        user.getRoles().clear();
        if (roleIds != null) {
            Integer[] integerArray = roleIds;
            int n = roleIds.length;
            int n2 = 0;
            while (n2 < n) {
                Integer rid = integerArray[n2];
                user.addToRoles(this.cmsRoleMng.findById(rid));
                ++n2;
            }
        }
        Set<Channel> channels = user.getChannels();
        for (Channel channel : channels) {
            channel.getUsers().remove(user);
        }
        user.getChannels().clear();
        if (channelIds != null) {
            Integer[] integerArray = channelIds;
            int n = channelIds.length;
            int n3 = 0;
            while (n3 < n) {
                Integer cid = integerArray[n3];
                Channel channel = this.channelMng.findById(cid);
                channel.addToUsers(user);
                ++n3;
            }
        }
        this.unifiedUserMng.update((Integer)bean.getId(), password, bean.getEmail());
        return user;
    }

    @Override
    public CmsUser updateMember(Integer id, String email, String password, Boolean isDisabled, CmsUserExt ext, Integer groupId) {
        CmsUser entity = this.findById(id);
        if (!StringUtils.isBlank((String)email)) {
            entity.setEmail(email);
        }
        if (isDisabled != null) {
            entity.setDisabled(isDisabled);
        }
        if (groupId != null) {
            entity.setGroup(this.cmsGroupMng.findById(groupId));
        }
        this.cmsUserExtMng.update(ext, entity);
        this.unifiedUserMng.update(id, password, email);
        return entity;
    }

    @Override
    public CmsUser updateUserConllection(CmsUser user, Integer cid, Integer operate) {
        Updater updater = new Updater((Object)user);
        user = this.dao.updateByUpdater((Updater<CmsUser>)updater);
        if (operate.equals(1)) {
            user.addToCollection(this.contentMng.findById(cid));
        } else if (operate.equals(0)) {
            user.delFromCollection(this.contentMng.findById(cid));
        }
        return user;
    }

    @Override
    public CmsUser deleteById(Integer id) {
        this.unifiedUserMng.deleteById(id);
        CmsUser bean = this.dao.deleteById(id);
        bean.clearCollection();
        return bean;
    }

    @Override
    public CmsUser[] deleteByIds(Integer[] ids) {
        CmsUser[] beans = new CmsUser[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public boolean usernameNotExist(String username) {
        return this.dao.countByUsername(username) <= 0;
    }

    @Override
    public boolean usernameNotExistInMember(String username) {
        return this.dao.countMemberByUsername(username) <= 0;
    }

    @Override
    public boolean emailNotExist(String email) {
        return this.dao.countByEmail(email) <= 0;
    }

    @Autowired
    public void setCmsUserSiteMng(CmsUserSiteMng cmsUserSiteMng) {
        this.cmsUserSiteMng = cmsUserSiteMng;
    }

    @Autowired
    public void setCmsSiteMng(CmsSiteMng cmsSiteMng) {
        this.cmsSiteMng = cmsSiteMng;
    }

    @Autowired
    public void setChannelMng(ChannelMng channelMng) {
        this.channelMng = channelMng;
    }

    @Autowired
    public void setCmsRoleMng(CmsRoleMng cmsRoleMng) {
        this.cmsRoleMng = cmsRoleMng;
    }

    @Autowired
    public void setUnifiedUserMng(UnifiedUserMng unifiedUserMng) {
        this.unifiedUserMng = unifiedUserMng;
    }

    @Autowired
    public void setCmsUserExtMng(CmsUserExtMng cmsUserExtMng) {
        this.cmsUserExtMng = cmsUserExtMng;
    }

    @Autowired
    public void setCmsGroupMng(CmsGroupMng cmsGroupMng) {
        this.cmsGroupMng = cmsGroupMng;
    }

    @Autowired
    public void setDao(CmsUserDao dao) {
        this.dao = dao;
    }
}

