/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.main.impl;

import com.jeecms.cms.dao.main.CmsUserSiteDao;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.CmsUserSite;
import com.jeecms.cms.manager.main.CmsSiteMng;
import com.jeecms.cms.manager.main.CmsUserSiteMng;
import com.jeecms.common.hibernate3.Updater;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class CmsUserSiteMngImpl
implements CmsUserSiteMng {
    private CmsSiteMng cmsSiteMng;
    private CmsUserSiteDao dao;

    @Override
    @Transactional(readOnly=true)
    public CmsUserSite findById(Integer id) {
        CmsUserSite entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public CmsUserSite save(CmsSite site, CmsUser user, Byte step, Boolean allChannel) {
        CmsUserSite bean = new CmsUserSite();
        bean.setSite(site);
        bean.setUser(user);
        bean.setCheckStep(step);
        bean.setAllChannel(allChannel);
        this.dao.save(bean);
        return bean;
    }

    @Override
    public CmsUserSite update(CmsUserSite bean) {
        Updater updater = new Updater((Object)bean);
        bean = this.dao.updateByUpdater((Updater<CmsUserSite>)updater);
        return bean;
    }

    @Override
    public void updateByUser(CmsUser user, Integer siteId, Byte step, Boolean allChannel) {
        Set<CmsUserSite> uss = user.getUserSites();
        if (siteId == null || step == null || allChannel == null) {
            return;
        }
        for (CmsUserSite us : uss) {
            if (!siteId.equals(us.getSite().getId())) continue;
            us.setCheckStep(step);
            us.setAllChannel(allChannel);
        }
    }

    @Override
    public void updateByUser(CmsUser user, Integer[] siteIds, Byte[] steps, Boolean[] allChannels) {
        int i;
        boolean contains;
        Set<CmsUserSite> uss = user.getUserSites();
        if (siteIds == null) {
            user.getUserSites().clear();
            for (CmsUserSite us : uss) {
                this.dao.delete(us);
            }
            return;
        }
        HashSet<CmsUserSite> toDel = new HashSet<CmsUserSite>();
        for (CmsUserSite us : uss) {
            contains = false;
            i = 0;
            while (i < siteIds.length) {
                if (siteIds[i].equals(us.getSite().getId())) {
                    contains = true;
                    break;
                }
                ++i;
            }
            if (contains) {
                us.setCheckStep(steps[i]);
                us.setAllChannel(allChannels[i]);
                continue;
            }
            toDel.add(us);
        }
        this.delete(toDel, uss);
        i = 0;
        HashSet<CmsUserSite> toSave = new HashSet<CmsUserSite>();
        Integer[] integerArray = siteIds;
        int n = siteIds.length;
        int n2 = 0;
        while (n2 < n) {
            Integer sid = integerArray[n2];
            contains = false;
            for (CmsUserSite us : uss) {
                if (!us.getSite().getId().equals(sid)) continue;
                contains = true;
                break;
            }
            if (!contains) {
                toSave.add(this.save(this.cmsSiteMng.findById(sid), user, steps[i], allChannels[i]));
            }
            ++i;
            ++n2;
        }
        uss.addAll(toSave);
    }

    @Override
    public int deleteBySiteId(Integer siteId) {
        return this.dao.deleteBySiteId(siteId);
    }

    private void delete(Collection<CmsUserSite> coll, Set<CmsUserSite> set) {
        if (coll == null) {
            return;
        }
        for (CmsUserSite us : coll) {
            this.dao.delete(us);
            set.remove(us);
        }
    }

    @Override
    public CmsUserSite deleteById(Integer id) {
        CmsUserSite bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public CmsUserSite[] deleteByIds(Integer[] ids) {
        CmsUserSite[] beans = new CmsUserSite[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setCmsSiteMng(CmsSiteMng cmsSiteMng) {
        this.cmsSiteMng = cmsSiteMng;
    }

    @Autowired
    public void setDao(CmsUserSiteDao dao) {
        this.dao = dao;
    }
}

