/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.main.impl;

import com.jeecms.cms.dao.main.ContentCountDao;
import com.jeecms.cms.entity.main.CmsConfig;
import com.jeecms.cms.entity.main.Content;
import com.jeecms.cms.entity.main.ContentCount;
import com.jeecms.cms.manager.main.CmsConfigMng;
import com.jeecms.cms.manager.main.ContentCountMng;
import com.jeecms.common.hibernate3.Updater;
import java.util.Calendar;
import java.util.Date;
import net.sf.ehcache.Ehcache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class ContentCountMngImpl
implements ContentCountMng {
    private int interval = 3600000;
    private CmsConfigMng cmsConfigMng;
    private ContentCountDao dao;

    public int contentUp(Integer id) {
        ContentCount c = this.dao.findById(id);
        if (c == null) {
            return 0;
        }
        int count = c.getUps() + 1;
        c.setUps(count);
        c.setUpsMonth(c.getUpsMonth() + 1);
        c.setUpsWeek((short)(c.getUpsWeek() + 1));
        c.setUpsDay((short)(c.getUpsDay() + 1));
        return count;
    }

    public int contentDown(Integer id) {
        ContentCount c = this.dao.findById(id);
        if (c == null) {
            return 0;
        }
        int count = c.getDowns() + 1;
        c.setDowns(count);
        return count;
    }

    public void downloadCount(Integer contentId) {
        ContentCount c = this.findById(contentId);
        c.setDownloads(c.getDownloads() + 1);
        c.setDownloadsMonth(c.getDownloadsMonth() + 1);
        c.setDownloadsWeek((short)(c.getCommentsWeek() + 1));
        c.setDownloadsDay((short)(c.getDownloadsDay() + 1));
    }

    public void commentCount(Integer contentId) {
        ContentCount c = this.findById(contentId);
        c.setComments(c.getComments() + 1);
        c.setCommentsMonth(c.getCommentsMonth() + 1);
        c.setCommentsWeek((short)(c.getCommentsWeek() + 1));
        c.setCommentsDay((short)(c.getCommentsDay() + 1));
    }

    public int freshCacheToDB(Ehcache cache) {
        CmsConfig config = this.cmsConfigMng.get();
        this.clearCount(config);
        int count = this.dao.freshCacheToDB(cache);
        this.copyCount(config);
        return count;
    }

    private int clearCount(CmsConfig config) {
        Calendar curr = Calendar.getInstance();
        Calendar last = Calendar.getInstance();
        last.setTime(config.getCountClearTime());
        int currDay = curr.get(6);
        int lastDay = last.get(6);
        if (currDay != lastDay) {
            int currWeek = curr.get(3);
            int lastWeek = last.get(3);
            int currMonth = curr.get(2);
            int lastMonth = last.get(2);
            this.cmsConfigMng.updateCountClearTime(curr.getTime());
            return this.dao.clearCount(currWeek != lastWeek, currMonth != lastMonth);
        }
        return 0;
    }

    private int copyCount(CmsConfig config) {
        long last;
        long curr = System.currentTimeMillis();
        if (curr > (long)this.interval + (last = config.getCountCopyTime().getTime())) {
            this.cmsConfigMng.updateCountCopyTime(new Date(curr));
            return this.dao.copyCount();
        }
        return 0;
    }

    @Transactional(readOnly=true)
    public ContentCount findById(Integer id) {
        ContentCount entity = this.dao.findById(id);
        return entity;
    }

    public ContentCount save(ContentCount count, Content content) {
        count.setContent(content);
        count.init();
        this.dao.save(count);
        content.setContentCount(count);
        return count;
    }

    public ContentCount update(ContentCount bean) {
        Updater updater = new Updater((Object)bean);
        ContentCount entity = this.dao.updateByUpdater((Updater<ContentCount>)updater);
        return entity;
    }

    public void setInterval(int interval) {
        this.interval = interval * 60 * 1000;
    }

    @Autowired
    public void setCmsConfigMng(CmsConfigMng cmsConfigMng) {
        this.cmsConfigMng = cmsConfigMng;
    }

    @Autowired
    public void setDao(ContentCountDao dao) {
        this.dao = dao;
    }
}

