/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.main.impl;

import com.jeecms.cms.dao.main.ContentDao;
import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsGroup;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsTopic;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.entity.main.CmsUserSite;
import com.jeecms.cms.entity.main.Content;
import com.jeecms.cms.entity.main.ContentCheck;
import com.jeecms.cms.entity.main.ContentCount;
import com.jeecms.cms.entity.main.ContentExt;
import com.jeecms.cms.entity.main.ContentTag;
import com.jeecms.cms.entity.main.ContentTxt;
import com.jeecms.cms.manager.assist.CmsCommentMng;
import com.jeecms.cms.manager.main.ChannelMng;
import com.jeecms.cms.manager.main.CmsGroupMng;
import com.jeecms.cms.manager.main.CmsTopicMng;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.manager.main.ContentCheckMng;
import com.jeecms.cms.manager.main.ContentCountMng;
import com.jeecms.cms.manager.main.ContentExtMng;
import com.jeecms.cms.manager.main.ContentMng;
import com.jeecms.cms.manager.main.ContentTagMng;
import com.jeecms.cms.manager.main.ContentTxtMng;
import com.jeecms.cms.manager.main.ContentTypeMng;
import com.jeecms.cms.service.ChannelDeleteChecker;
import com.jeecms.cms.service.ContentListener;
import com.jeecms.cms.staticpage.StaticPageSvc;
import com.jeecms.cms.staticpage.exception.ContentNotCheckedException;
import com.jeecms.cms.staticpage.exception.GeneratedZeroStaticPageException;
import com.jeecms.cms.staticpage.exception.StaticPageNotOpenException;
import com.jeecms.cms.staticpage.exception.TemplateNotFoundException;
import com.jeecms.cms.staticpage.exception.TemplateParseException;
import com.jeecms.common.hibernate3.Updater;
import com.jeecms.common.page.Pagination;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class ContentMngImpl
implements ContentMng,
ChannelDeleteChecker {
    private List<ContentListener> listenerList;
    private ChannelMng channelMng;
    private ContentExtMng contentExtMng;
    private ContentTxtMng contentTxtMng;
    private ContentTypeMng contentTypeMng;
    private ContentCountMng contentCountMng;
    private ContentCheckMng contentCheckMng;
    private ContentTagMng contentTagMng;
    private CmsGroupMng cmsGroupMng;
    private CmsUserMng cmsUserMng;
    private CmsTopicMng cmsTopicMng;
    private CmsCommentMng cmsCommentMng;
    private ContentDao dao;
    private StaticPageSvc staticPageSvc;

    @Override
    @Transactional(readOnly=true)
    public Pagination getPageByRight(String title, Integer typeId, Integer inputUserId, boolean topLevel, boolean recommend, Content.ContentStatus status, Byte checkStep, Integer siteId, Integer channelId, Integer userId, int orderBy, int pageNo, int pageSize) {
        CmsUser user = this.cmsUserMng.findById(userId);
        CmsUserSite us = user.getUserSite(siteId);
        boolean allChannel = us.getAllChannel();
        boolean selfData = user.getSelfAdmin();
        Pagination p = allChannel && selfData ? this.dao.getPageBySelf(title, typeId, inputUserId, topLevel, recommend, status, checkStep, siteId, channelId, userId, orderBy, pageNo, pageSize) : (allChannel && !selfData ? this.dao.getPage(title, typeId, inputUserId, topLevel, recommend, status, checkStep, siteId, channelId, orderBy, pageNo, pageSize) : this.dao.getPageByRight(title, typeId, inputUserId, topLevel, recommend, status, checkStep, siteId, channelId, userId, selfData, orderBy, pageNo, pageSize));
        return p;
    }

    @Override
    public Pagination getPageForMember(String title, Integer channelId, Integer siteId, Integer memberId, int pageNo, int pageSize) {
        return this.dao.getPage(title, null, memberId, false, false, Content.ContentStatus.all, null, siteId, channelId, 0, pageNo, pageSize);
    }

    @Override
    @Transactional(readOnly=true)
    public Content getSide(Integer id, Integer siteId, Integer channelId, boolean next) {
        return this.dao.getSide(id, siteId, channelId, next, true);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Content> getListByIdsForTag(Integer[] ids, int orderBy) {
        if (ids.length == 1) {
            ArrayList<Content> list;
            Content content = this.findById(ids[0]);
            if (content != null) {
                list = new ArrayList<Content>(1);
                list.add(content);
            } else {
                list = new ArrayList(0);
            }
            return list;
        }
        return this.dao.getListByIdsForTag(ids, orderBy);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPageBySiteIdsForTag(Integer[] siteIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy, int pageNo, int pageSize) {
        return this.dao.getPageBySiteIdsForTag(siteIds, typeIds, titleImg, recommend, title, orderBy, pageNo, pageSize);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Content> getListBySiteIdsForTag(Integer[] siteIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy, Integer first, Integer count) {
        return this.dao.getListBySiteIdsForTag(siteIds, typeIds, titleImg, recommend, title, orderBy, first, count);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPageByChannelIdsForTag(Integer[] channelIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy, int option, int pageNo, int pageSize) {
        return this.dao.getPageByChannelIdsForTag(channelIds, typeIds, titleImg, recommend, title, orderBy, option, pageNo, pageSize);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Content> getListByChannelIdsForTag(Integer[] channelIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy, int option, Integer first, Integer count) {
        return this.dao.getListByChannelIdsForTag(channelIds, typeIds, titleImg, recommend, title, orderBy, option, first, count);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPageByChannelPathsForTag(String[] paths, Integer[] siteIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy, int pageNo, int pageSize) {
        return this.dao.getPageByChannelPathsForTag(paths, siteIds, typeIds, titleImg, recommend, title, orderBy, pageNo, pageSize);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Content> getListByChannelPathsForTag(String[] paths, Integer[] siteIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy, Integer first, Integer count) {
        return this.dao.getListByChannelPathsForTag(paths, siteIds, typeIds, titleImg, recommend, title, orderBy, first, count);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPageByTopicIdForTag(Integer topicId, Integer[] siteIds, Integer[] channelIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy, int pageNo, int pageSize) {
        return this.dao.getPageByTopicIdForTag(topicId, siteIds, channelIds, typeIds, titleImg, recommend, title, orderBy, pageNo, pageSize);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Content> getListByTopicIdForTag(Integer topicId, Integer[] siteIds, Integer[] channelIds, Integer[] typeIds, Boolean titleImg, Boolean recommend, String title, int orderBy, Integer first, Integer count) {
        return this.dao.getListByTopicIdForTag(topicId, siteIds, channelIds, typeIds, titleImg, recommend, title, orderBy, first, count);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPageByTagIdsForTag(Integer[] tagIds, Integer[] siteIds, Integer[] channelIds, Integer[] typeIds, Integer excludeId, Boolean titleImg, Boolean recommend, String title, int orderBy, int pageNo, int pageSize) {
        return this.dao.getPageByTagIdsForTag(tagIds, siteIds, channelIds, typeIds, excludeId, titleImg, recommend, title, orderBy, pageNo, pageSize);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Content> getListByTagIdsForTag(Integer[] tagIds, Integer[] siteIds, Integer[] channelIds, Integer[] typeIds, Integer excludeId, Boolean titleImg, Boolean recommend, String title, int orderBy, Integer first, Integer count) {
        return this.dao.getListByTagIdsForTag(tagIds, siteIds, channelIds, typeIds, excludeId, titleImg, recommend, title, orderBy, first, count);
    }

    @Override
    @Transactional(readOnly=true)
    public Content findById(Integer id) {
        Content entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public Content save(Content bean, ContentExt ext, ContentTxt txt, Integer[] channelIds, Integer[] topicIds, Integer[] viewGroupIds, String[] tagArr, String[] attachmentPaths, String[] attachmentNames, String[] attachmentFilenames, String[] picPaths, String[] picDescs, Integer channelId, Integer typeId, Boolean draft, CmsUser user, boolean forMember) {
        int len;
        int i;
        int n;
        int n2;
        Integer[] integerArray;
        Byte userStep;
        bean.setChannel(this.channelMng.findById(channelId));
        bean.setType(this.contentTypeMng.findById(typeId));
        bean.setUser(user);
        if (forMember) {
            userStep = 0;
        } else {
            CmsSite site = bean.getSite();
            userStep = user.getCheckStep(site.getId());
        }
        if (draft != null && draft.booleanValue()) {
            bean.setStatus((byte)0);
        } else if (userStep >= bean.getChannel().getFinalStepExtends()) {
            bean.setStatus((byte)2);
        } else {
            bean.setStatus((byte)1);
        }
        bean.setHasTitleImg(!StringUtils.isBlank((String)ext.getTitleImg()));
        bean.init();
        this.preSave(bean);
        this.dao.save(bean);
        this.contentExtMng.save(ext, bean);
        this.contentTxtMng.save(txt, bean);
        ContentCheck check = new ContentCheck();
        check.setCheckStep(userStep);
        this.contentCheckMng.save(check, bean);
        this.contentCountMng.save(new ContentCount(), bean);
        if (channelIds != null && channelIds.length > 0) {
            integerArray = channelIds;
            n2 = channelIds.length;
            n = 0;
            while (n < n2) {
                Integer cid = integerArray[n];
                bean.addToChannels(this.channelMng.findById(cid));
                ++n;
            }
        }
        bean.addToChannels(this.channelMng.findById(channelId));
        if (topicIds != null && topicIds.length > 0) {
            integerArray = topicIds;
            n2 = topicIds.length;
            n = 0;
            while (n < n2) {
                Integer tid = integerArray[n];
                bean.addToTopics(this.cmsTopicMng.findById(tid));
                ++n;
            }
        }
        if (viewGroupIds != null && viewGroupIds.length > 0) {
            integerArray = viewGroupIds;
            n2 = viewGroupIds.length;
            n = 0;
            while (n < n2) {
                Integer gid = integerArray[n];
                bean.addToGroups(this.cmsGroupMng.findById(gid));
                ++n;
            }
        }
        List<ContentTag> tags = this.contentTagMng.saveTags(tagArr);
        bean.setTags(tags);
        if (attachmentPaths != null && attachmentPaths.length > 0) {
            i = 0;
            len = attachmentPaths.length;
            while (i < len) {
                if (!StringUtils.isBlank((String)attachmentPaths[i])) {
                    bean.addToAttachmemts(attachmentPaths[i], attachmentNames[i], attachmentFilenames[i]);
                }
                ++i;
            }
        }
        if (picPaths != null && picPaths.length > 0) {
            i = 0;
            len = picPaths.length;
            while (i < len) {
                if (!StringUtils.isBlank((String)picPaths[i])) {
                    bean.addToPictures(picPaths[i], picDescs[i]);
                }
                ++i;
            }
        }
        this.afterSave(bean);
        return bean;
    }

    @Override
    public Content update(Content bean, ContentExt ext, ContentTxt txt, String[] tagArr, Integer[] channelIds, Integer[] topicIds, Integer[] viewGroupIds, String[] attachmentPaths, String[] attachmentNames, String[] attachmentFilenames, String[] picPaths, String[] picDescs, Map<String, String> attr, Integer channelId, Integer typeId, Boolean draft, CmsUser user, boolean forMember) {
        int n;
        Byte userStep;
        Content entity = this.findById(bean.getId());
        List<Map<String, Object>> mapList = this.preChange(entity);
        Updater updater = new Updater((Object)bean);
        bean = this.dao.updateByUpdater((Updater<Content>)updater);
        if (forMember) {
            userStep = 0;
        } else {
            CmsSite site = bean.getSite();
            userStep = user.getCheckStep(site.getId());
        }
        Channel.AfterCheckEnum after = bean.getChannel().getAfterCheckEnum();
        if (after == Channel.AfterCheckEnum.BACK_UPDATE && bean.getCheckStep() > userStep) {
            bean.getContentCheck().setCheckStep(userStep);
            if (bean.getCheckStep() >= bean.getChannel().getFinalStepExtends()) {
                bean.setStatus((byte)2);
            } else {
                bean.setStatus((byte)1);
            }
        }
        if (draft != null) {
            if (draft.booleanValue()) {
                bean.setStatus((byte)0);
            } else if (bean.getStatus() == 0) {
                if (bean.getCheckStep() >= bean.getChannel().getFinalStepExtends()) {
                    bean.setStatus((byte)2);
                } else {
                    bean.setStatus((byte)1);
                }
            }
        }
        bean.setHasTitleImg(!StringUtils.isBlank((String)ext.getTitleImg()));
        if (channelId != null) {
            bean.setChannel(this.channelMng.findById(channelId));
        }
        if (typeId != null) {
            bean.setType(this.contentTypeMng.findById(typeId));
        }
        this.contentExtMng.update(ext);
        this.contentTxtMng.update(txt, bean);
        if (attr != null) {
            Map<String, String> attrOrig = bean.getAttr();
            attrOrig.clear();
            attrOrig.putAll(attr);
        }
        Set<Channel> channels = bean.getChannels();
        channels.clear();
        if (channelIds != null && channelIds.length > 0) {
            Integer[] integerArray = channelIds;
            n = channelIds.length;
            int n2 = 0;
            while (n2 < n) {
                Integer cid = integerArray[n2];
                channels.add(this.channelMng.findById(cid));
                ++n2;
            }
        }
        channels.add(bean.getChannel());
        Set<CmsTopic> topics = bean.getTopics();
        topics.clear();
        if (topicIds != null && topicIds.length > 0) {
            Integer[] integerArray = topicIds;
            int n3 = topicIds.length;
            n = 0;
            while (n < n3) {
                Integer tid = integerArray[n];
                topics.add(this.cmsTopicMng.findById(tid));
                ++n;
            }
        }
        Set<CmsGroup> groups = bean.getViewGroups();
        groups.clear();
        if (viewGroupIds != null && viewGroupIds.length > 0) {
            Integer[] integerArray = viewGroupIds;
            int n4 = viewGroupIds.length;
            int n5 = 0;
            while (n5 < n4) {
                Integer gid = integerArray[n5];
                groups.add(this.cmsGroupMng.findById(gid));
                ++n5;
            }
        }
        this.contentTagMng.updateTags(bean.getTags(), tagArr);
        bean.getAttachments().clear();
        if (attachmentPaths != null && attachmentPaths.length > 0) {
            int i = 0;
            int len = attachmentPaths.length;
            while (i < len) {
                if (!StringUtils.isBlank((String)attachmentPaths[i])) {
                    bean.addToAttachmemts(attachmentPaths[i], attachmentNames[i], attachmentFilenames[i]);
                }
                ++i;
            }
        }
        bean.getPictures().clear();
        if (picPaths != null && picPaths.length > 0) {
            int i = 0;
            int len = picPaths.length;
            while (i < len) {
                if (!StringUtils.isBlank((String)picPaths[i])) {
                    bean.addToPictures(picPaths[i], picDescs[i]);
                }
                ++i;
            }
        }
        this.afterChange(bean, mapList);
        return bean;
    }

    @Override
    public Content check(Integer id, CmsUser user) {
        Content content = this.findById(id);
        List<Map<String, Object>> mapList = this.preChange(content);
        ContentCheck check = content.getContentCheck();
        byte userStep = user.getCheckStep(content.getSite().getId());
        byte contentStep = check.getCheckStep();
        byte finalStep = content.getChannel().getFinalStepExtends();
        if (userStep < contentStep) {
            return content;
        }
        check.setRejected(false);
        if (userStep > contentStep) {
            check.setCheckOpinion(null);
        }
        check.setCheckStep(userStep);
        if (userStep >= finalStep) {
            content.setStatus((byte)2);
            check.setCheckOpinion(null);
        }
        this.afterChange(content, mapList);
        return content;
    }

    @Override
    public Content[] check(Integer[] ids, CmsUser user) {
        Content[] beans = new Content[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.check(ids[i], user);
            ++i;
        }
        return beans;
    }

    @Override
    public Content reject(Integer id, CmsUser user, Byte step, String opinion) {
        byte contentStep;
        Content content = this.findById(id);
        Integer siteId = content.getSite().getId();
        byte userStep = user.getCheckStep(siteId);
        if (userStep < (contentStep = content.getCheckStep().byteValue())) {
            return content;
        }
        List<Map<String, Object>> mapList = this.preChange(content);
        ContentCheck check = content.getContentCheck();
        if (!StringUtils.isBlank((String)opinion)) {
            check.setCheckOpinion(opinion);
        }
        check.setRejected(true);
        content.setStatus((byte)1);
        if (step != null) {
            if (step < userStep) {
                check.setCheckStep(step);
            } else {
                check.setCheckStep(userStep);
            }
        } else if (contentStep >= userStep && contentStep == userStep) {
            check.setCheckStep((byte)(check.getCheckStep() - 1));
        }
        this.afterChange(content, mapList);
        return content;
    }

    @Override
    public Content[] reject(Integer[] ids, CmsUser user, Byte step, String opinion) {
        Content[] beans = new Content[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.reject(ids[i], user, step, opinion);
            ++i;
        }
        return beans;
    }

    @Override
    public Content cycle(Integer id) {
        Content content = this.findById(id);
        List<Map<String, Object>> mapList = this.preChange(content);
        content.setStatus((byte)3);
        this.afterChange(content, mapList);
        return content;
    }

    @Override
    public Content[] cycle(Integer[] ids) {
        Content[] beans = new Content[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.cycle(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public Content recycle(Integer id) {
        byte finalStep;
        Content content = this.findById(id);
        List<Map<String, Object>> mapList = this.preChange(content);
        byte contentStep = content.getCheckStep();
        if (contentStep >= (finalStep = content.getChannel().getFinalStepExtends().byteValue()) && !content.getRejected().booleanValue()) {
            content.setStatus((byte)2);
        } else {
            content.setStatus((byte)1);
        }
        this.afterChange(content, mapList);
        return content;
    }

    @Override
    public Content[] recycle(Integer[] ids) {
        Content[] beans = new Content[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.recycle(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public Content deleteById(Integer id) {
        Content bean = this.findById(id);
        this.preDelete(bean);
        this.contentTagMng.removeTags(bean.getTags());
        this.cmsCommentMng.deleteByContentId(id);
        bean.clear();
        bean = this.dao.deleteById(id);
        this.afterDelete(bean);
        return bean;
    }

    @Override
    public Content[] deleteByIds(Integer[] ids) {
        Content[] beans = new Content[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public Content[] contentStatic(Integer[] ids) throws TemplateNotFoundException, TemplateParseException, GeneratedZeroStaticPageException, StaticPageNotOpenException, ContentNotCheckedException {
        int count = 0;
        ArrayList<Content> list = new ArrayList<Content>();
        int i = 0;
        int len = ids.length;
        while (i < len) {
            Content content = this.findById(ids[i]);
            try {
                if (!content.getChannel().getStaticContent().booleanValue()) {
                    throw new StaticPageNotOpenException("content.staticNotOpen", count, content.getTitle());
                }
                if (!content.isChecked()) {
                    throw new ContentNotCheckedException("content.notChecked", count, content.getTitle());
                }
                if (this.staticPageSvc.content(content)) {
                    list.add(content);
                    ++count;
                }
            }
            catch (IOException e) {
                throw new TemplateNotFoundException("content.tplContentNotFound", count, content.getTitle());
            }
            catch (TemplateException e) {
                throw new TemplateParseException("content.tplContentException", count, content.getTitle());
            }
            ++i;
        }
        if (count == 0) {
            throw new GeneratedZeroStaticPageException("content.staticGenerated");
        }
        Content[] beans = new Content[count];
        return list.toArray(beans);
    }

    @Override
    public Pagination getPageForCollection(Integer siteId, Integer memberId, int pageNo, int pageSize) {
        return this.dao.getPageForCollection(siteId, memberId, pageNo, pageSize);
    }

    @Override
    public String checkForChannelDelete(Integer channelId) {
        int count = this.dao.countByChannelId(channelId);
        if (count > 0) {
            return "content.error.cannotDeleteChannel";
        }
        return null;
    }

    private void preSave(Content content) {
        if (this.listenerList != null) {
            for (ContentListener listener : this.listenerList) {
                listener.preSave(content);
            }
        }
    }

    private void afterSave(Content content) {
        if (this.listenerList != null) {
            for (ContentListener listener : this.listenerList) {
                listener.afterSave(content);
            }
        }
    }

    private List<Map<String, Object>> preChange(Content content) {
        if (this.listenerList != null) {
            int len = this.listenerList.size();
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(len);
            for (ContentListener listener : this.listenerList) {
                list.add(listener.preChange(content));
            }
            return list;
        }
        return null;
    }

    private void afterChange(Content content, List<Map<String, Object>> mapList) {
        if (this.listenerList != null) {
            Assert.notNull(mapList);
            Assert.isTrue((mapList.size() == this.listenerList.size() ? 1 : 0) != 0);
            int len = this.listenerList.size();
            int i = 0;
            while (i < len) {
                ContentListener listener = this.listenerList.get(i);
                listener.afterChange(content, mapList.get(i));
                ++i;
            }
        }
    }

    private void preDelete(Content content) {
        if (this.listenerList != null) {
            for (ContentListener listener : this.listenerList) {
                listener.preDelete(content);
            }
        }
    }

    private void afterDelete(Content content) {
        if (this.listenerList != null) {
            for (ContentListener listener : this.listenerList) {
                listener.afterDelete(content);
            }
        }
    }

    public void setListenerList(List<ContentListener> listenerList) {
        this.listenerList = listenerList;
    }

    @Autowired
    public void setChannelMng(ChannelMng channelMng) {
        this.channelMng = channelMng;
    }

    @Autowired
    public void setContentTypeMng(ContentTypeMng contentTypeMng) {
        this.contentTypeMng = contentTypeMng;
    }

    @Autowired
    public void setContentCountMng(ContentCountMng contentCountMng) {
        this.contentCountMng = contentCountMng;
    }

    @Autowired
    public void setContentExtMng(ContentExtMng contentExtMng) {
        this.contentExtMng = contentExtMng;
    }

    @Autowired
    public void setContentTxtMng(ContentTxtMng contentTxtMng) {
        this.contentTxtMng = contentTxtMng;
    }

    @Autowired
    public void setContentCheckMng(ContentCheckMng contentCheckMng) {
        this.contentCheckMng = contentCheckMng;
    }

    @Autowired
    public void setCmsTopicMng(CmsTopicMng cmsTopicMng) {
        this.cmsTopicMng = cmsTopicMng;
    }

    @Autowired
    public void setContentTagMng(ContentTagMng contentTagMng) {
        this.contentTagMng = contentTagMng;
    }

    @Autowired
    public void setCmsGroupMng(CmsGroupMng cmsGroupMng) {
        this.cmsGroupMng = cmsGroupMng;
    }

    @Autowired
    public void setCmsUserMng(CmsUserMng cmsUserMng) {
        this.cmsUserMng = cmsUserMng;
    }

    @Autowired
    public void setCmsCommentMng(CmsCommentMng cmsCommentMng) {
        this.cmsCommentMng = cmsCommentMng;
    }

    @Autowired
    public void setDao(ContentDao dao) {
        this.dao = dao;
    }

    @Autowired
    public void setStaticPageSvc(StaticPageSvc staticPageSvc) {
        this.staticPageSvc = staticPageSvc;
    }
}

