/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.manager.main.impl;

import com.jeecms.cms.dao.main.ContentTagDao;
import com.jeecms.cms.entity.main.ContentTag;
import com.jeecms.cms.manager.main.ContentTagMng;
import com.jeecms.common.hibernate3.Updater;
import com.jeecms.common.page.Pagination;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class ContentTagMngImpl
implements ContentTagMng {
    private static final Logger log = LoggerFactory.getLogger(ContentTagMngImpl.class);
    private ContentTagDao dao;

    @Override
    @Transactional(readOnly=true)
    public List<ContentTag> getListForTag(Integer count) {
        return this.dao.getList(count, true);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPageForTag(int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(null, pageNo, pageSize, true);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(String name, int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(name, pageNo, pageSize, false);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public ContentTag findById(Integer id) {
        ContentTag entity = this.dao.findById(id);
        return entity;
    }

    @Override
    @Transactional(readOnly=true)
    public ContentTag findByName(String name) {
        return this.dao.findByName(name, false);
    }

    @Override
    @Transactional(readOnly=true)
    public ContentTag findByNameForTag(String name) {
        return this.dao.findByName(name, true);
    }

    @Override
    public List<ContentTag> saveTags(String[] tagArr) {
        if (tagArr == null || tagArr.length <= 0) {
            return null;
        }
        ArrayList<ContentTag> list = new ArrayList<ContentTag>();
        HashSet<String> tagSet = new HashSet<String>();
        String[] stringArray = tagArr;
        int n = tagArr.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            for (String t : tagSet) {
                if (!t.equalsIgnoreCase(name)) continue;
            }
            tagSet.add(name);
            ContentTag tag = this.saveTag(name);
            list.add(tag);
            ++n2;
        }
        return list;
    }

    @Override
    public ContentTag saveTag(String name) {
        ContentTag tag = this.findByName(name);
        if (tag != null) {
            tag.setCount(tag.getCount() + 1);
        } else {
            tag = new ContentTag();
            tag.setName(name);
            tag = this.save(tag);
        }
        return tag;
    }

    @Override
    public List<ContentTag> updateTags(List<ContentTag> tags, String[] tagArr) {
        if (tagArr == null) {
            tagArr = new String[]{};
        }
        ArrayList<ContentTag> list = new ArrayList<ContentTag>();
        String[] stringArray = tagArr;
        int n = tagArr.length;
        int n2 = 0;
        while (n2 < n) {
            String t = stringArray[n2];
            ContentTag bean = null;
            for (ContentTag tag : tags) {
                if (!t.equalsIgnoreCase(tag.getName())) continue;
                bean = tag;
                break;
            }
            if (bean == null) {
                bean = this.saveTag(t);
            }
            list.add(bean);
            ++n2;
        }
        HashSet<ContentTag> toBeRemove = new HashSet<ContentTag>();
        for (ContentTag tag : tags) {
            boolean contains = false;
            String[] stringArray2 = tagArr;
            int n3 = tagArr.length;
            int n4 = 0;
            while (n4 < n3) {
                String t = stringArray2[n4];
                if (t.equalsIgnoreCase(tag.getName())) {
                    contains = true;
                    break;
                }
                ++n4;
            }
            if (contains) continue;
            toBeRemove.add(tag);
        }
        tags.clear();
        tags.addAll(list);
        this.removeTags(toBeRemove);
        return tags;
    }

    @Override
    public void removeTags(Collection<ContentTag> tags) {
        HashSet<ContentTag> toRemove = new HashSet<ContentTag>();
        for (ContentTag tag : tags) {
            tag.setCount(tag.getCount() - 1);
            if (tag.getCount() > 0) continue;
            toRemove.add(tag);
        }
        for (ContentTag tag : toRemove) {
            if (this.dao.countContentRef(tag.getId()) <= 1) {
                this.dao.deleteById(tag.getId());
                continue;
            }
            log.warn("ContentTag ref to Content > 1, while ContentTag.ref_counter <= 0");
        }
    }

    @Override
    public ContentTag save(ContentTag bean) {
        bean.init();
        this.dao.save(bean);
        return bean;
    }

    @Override
    public ContentTag update(ContentTag bean) {
        Updater updater = new Updater((Object)bean);
        ContentTag entity = this.dao.updateByUpdater((Updater<ContentTag>)updater);
        return entity;
    }

    @Override
    public ContentTag deleteById(Integer id) {
        this.dao.deleteContentRef(id);
        ContentTag bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public ContentTag[] deleteByIds(Integer[] ids) {
        ContentTag[] beans = new ContentTag[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(ContentTagDao dao) {
        this.dao = dao;
    }
}

