/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.service;

import com.jeecms.cms.entity.assist.CmsAcquisition;
import com.jeecms.cms.entity.assist.CmsAcquisitionHistory;
import com.jeecms.cms.entity.assist.CmsAcquisitionTemp;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.Content;
import com.jeecms.cms.manager.assist.CmsAcquisitionHistoryMng;
import com.jeecms.cms.manager.assist.CmsAcquisitionMng;
import com.jeecms.cms.manager.assist.CmsAcquisitionTempMng;
import com.jeecms.cms.service.AcquisitionSvc;
import java.io.IOException;
import java.net.URI;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AcquisitionSvcImpl
implements AcquisitionSvc {
    private Logger log = LoggerFactory.getLogger(AcquisitionSvcImpl.class);
    private CmsAcquisitionMng cmsAcquisitionMng;
    private CmsAcquisitionHistoryMng cmsAcquisitionHistoryMng;
    private CmsAcquisitionTempMng cmsAcquisitionTempMng;

    public boolean start(Integer id) {
        CmsAcquisition acqu = this.cmsAcquisitionMng.findById(id);
        if (acqu == null || acqu.getStatus() == 1) {
            return false;
        }
        AcquisitionThread thread = new AcquisitionThread(acqu);
        thread.start();
        return true;
    }

    private void end(CmsAcquisition acqu) {
        Integer siteId = acqu.getSite().getId();
        this.cmsAcquisitionMng.end(acqu.getId());
        CmsAcquisition acquisition = this.cmsAcquisitionMng.popAcquFromQueue(siteId);
        if (acquisition != null) {
            Integer id = acquisition.getId();
            this.start(id);
        }
    }

    @Autowired
    public void setCmsAcquisitionMng(CmsAcquisitionMng cmsAcquisitionMng) {
        this.cmsAcquisitionMng = cmsAcquisitionMng;
    }

    @Autowired
    public void setCmsAcquisitionHistoryMng(CmsAcquisitionHistoryMng cmsAcquisitionHistoryMng) {
        this.cmsAcquisitionHistoryMng = cmsAcquisitionHistoryMng;
    }

    @Autowired
    public void setCmsAcquisitionTempMng(CmsAcquisitionTempMng cmsAcquisitionTempMng) {
        this.cmsAcquisitionTempMng = cmsAcquisitionTempMng;
    }

    private CmsAcquisitionTemp newTemp(String channelUrl, String contentUrl, Integer id, Float curr, Float total, CmsSite site) {
        CmsAcquisitionTemp temp = new CmsAcquisitionTemp();
        temp.setChannelUrl(channelUrl);
        temp.setContentUrl(contentUrl);
        temp.setSeq(id);
        NumberFormat nf = NumberFormat.getPercentInstance();
        String percent = nf.format(curr.floatValue() / total.floatValue());
        temp.setPercent(Integer.parseInt(percent.substring(0, percent.length() - 1)));
        temp.setSite(site);
        return temp;
    }

    private CmsAcquisitionHistory newHistory(String channelUrl, String contentUrl, CmsAcquisition acqu) {
        CmsAcquisitionHistory history = new CmsAcquisitionHistory();
        history.setChannelUrl(channelUrl);
        history.setContentUrl(contentUrl);
        history.setAcquisition(acqu);
        return history;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AcquisitionThread
    extends Thread {
        private CmsAcquisition acqu;

        public AcquisitionThread(CmsAcquisition acqu) {
            super(String.valueOf(acqu.getClass().getName()) + "#" + acqu.getId());
            this.acqu = acqu;
        }

        @Override
        public void run() {
            if (this.acqu == null) {
                return;
            }
            this.acqu = AcquisitionSvcImpl.this.cmsAcquisitionMng.start(this.acqu.getId());
            String[] plans = this.acqu.getAllPlans();
            DefaultHttpClient client = new DefaultHttpClient();
            CharsetHandler handler = new CharsetHandler(this.acqu.getPageEncoding());
            int currNum = this.acqu.getCurrNum();
            int currItem = this.acqu.getCurrItem();
            Integer acquId = this.acqu.getId();
            int i = plans.length - currNum;
            while (i >= 0) {
                String url = plans[i];
                List<String> contentList = this.getContentList((HttpClient)client, handler, url, this.acqu.getLinksetStart(), this.acqu.getLinksetEnd(), this.acqu.getLinkStart(), this.acqu.getLinkEnd());
                int j = contentList.size() - currItem;
                while (j >= 0) {
                    if (AcquisitionSvcImpl.this.cmsAcquisitionMng.isNeedBreak(this.acqu.getId(), plans.length - i, contentList.size() - j, contentList.size())) {
                        client.getConnectionManager().shutdown();
                        AcquisitionSvcImpl.this.log.info("Acquisition#{} breaked", (Object)this.acqu.getId());
                        return;
                    }
                    if (this.acqu.getPauseTime() > 0) {
                        try {
                            Thread.sleep(this.acqu.getPauseTime().intValue());
                        }
                        catch (InterruptedException e) {
                            AcquisitionSvcImpl.this.log.warn(null, (Throwable)e);
                        }
                    }
                    String link = contentList.get(j);
                    float curr = contentList.size() - j;
                    float total = contentList.size();
                    CmsAcquisitionTemp temp = AcquisitionSvcImpl.this.newTemp(url, link, contentList.size() - j, Float.valueOf(curr), Float.valueOf(total), this.acqu.getSite());
                    CmsAcquisitionHistory history = AcquisitionSvcImpl.this.newHistory(url, link, this.acqu);
                    this.saveContent((HttpClient)client, handler, acquId, link, this.acqu.getTitleStart(), this.acqu.getTitleEnd(), this.acqu.getContentStart(), this.acqu.getContentEnd(), temp, history);
                    --j;
                }
                currItem = 1;
                --i;
            }
            client.getConnectionManager().shutdown();
            AcquisitionSvcImpl.this.end(this.acqu);
            AcquisitionSvcImpl.this.log.info("Acquisition#{} complete", (Object)this.acqu.getId());
        }

        private List<String> getContentList(HttpClient client, CharsetHandler handler, String url, String linksetStart, String linksetEnd, String linkStart, String linkEnd) {
            ArrayList<String> list = new ArrayList<String>();
            try {
                HttpGet httpget = new HttpGet(new URI(url));
                String base = url.substring(0, url.indexOf("/", url.indexOf("//") + 2));
                String html = (String)client.execute((HttpUriRequest)httpget, (ResponseHandler)handler);
                int start = html.indexOf(linksetStart);
                if (start == -1) {
                    return list;
                }
                int end = html.indexOf(linksetEnd, start += linksetStart.length());
                if (end == -1) {
                    return list;
                }
                String s = html.substring(start, end);
                start = 0;
                AcquisitionSvcImpl.this.log.info(s);
                while ((start = s.indexOf(linkStart, start)) != -1) {
                    end = s.indexOf(linkEnd, start += linkStart.length());
                    if (end == -1) {
                        return list;
                    }
                    String link = s.substring(start, end);
                    if (!link.startsWith("http")) {
                        link = String.valueOf(base) + link;
                    }
                    AcquisitionSvcImpl.this.log.debug("content link: {}", (Object)link);
                    list.add(link);
                    start = end + linkEnd.length();
                }
            }
            catch (Exception e) {
                AcquisitionSvcImpl.this.log.warn(null, (Throwable)e);
            }
            return list;
        }

        private Content saveContent(HttpClient client, CharsetHandler handler, Integer acquId, String url, String titleStart, String titleEnd, String contentStart, String contentEnd, CmsAcquisitionTemp temp, CmsAcquisitionHistory history) {
            CmsAcquisition acqu = AcquisitionSvcImpl.this.cmsAcquisitionMng.findById(acquId);
            history.setAcquisition(acqu);
            try {
                HttpGet httpget = new HttpGet(new URI(url));
                String html = (String)client.execute((HttpUriRequest)httpget, (ResponseHandler)handler);
                int start = html.indexOf(titleStart);
                if (start == -1) {
                    return this.handerResult(temp, history, null, CmsAcquisition.AcquisitionResultType.TITLESTARTNOTFOUND);
                }
                int end = html.indexOf(titleEnd, start += titleStart.length());
                if (end == -1) {
                    return this.handerResult(temp, history, null, CmsAcquisition.AcquisitionResultType.TITLEENDNOTFOUND);
                }
                String title = html.substring(start, end);
                if (AcquisitionSvcImpl.this.cmsAcquisitionHistoryMng.checkExistByProperties(true, title).booleanValue()) {
                    return this.handerResult(temp, history, title, CmsAcquisition.AcquisitionResultType.TITLEEXIST, true);
                }
                start = html.indexOf(contentStart);
                if (start == -1) {
                    return this.handerResult(temp, history, title, CmsAcquisition.AcquisitionResultType.CONTENTSTARTNOTFOUND);
                }
                end = html.indexOf(contentEnd, start += contentStart.length());
                if (end == -1) {
                    return this.handerResult(temp, history, title, CmsAcquisition.AcquisitionResultType.CONTENTENDNOTFOUND);
                }
                String txt = html.substring(start, end);
                Content content = AcquisitionSvcImpl.this.cmsAcquisitionMng.saveContent(title, txt, acquId, CmsAcquisition.AcquisitionResultType.SUCCESS, temp, history);
                AcquisitionSvcImpl.this.cmsAcquisitionTempMng.save(temp);
                AcquisitionSvcImpl.this.cmsAcquisitionHistoryMng.save(history);
                return content;
            }
            catch (Exception e) {
                AcquisitionSvcImpl.this.log.warn(null, (Throwable)e);
                return this.handerResult(temp, history, null, CmsAcquisition.AcquisitionResultType.UNKNOW);
            }
        }

        private Content handerResult(CmsAcquisitionTemp temp, CmsAcquisitionHistory history, String title, CmsAcquisition.AcquisitionResultType errorType) {
            return this.handerResult(temp, history, title, errorType, false);
        }

        private Content handerResult(CmsAcquisitionTemp temp, CmsAcquisitionHistory history, String title, CmsAcquisition.AcquisitionResultType errorType, Boolean repeat) {
            temp.setDescription(errorType.name());
            temp.setTitle(title);
            AcquisitionSvcImpl.this.cmsAcquisitionTempMng.save(temp);
            if (!repeat.booleanValue()) {
                history.setTitle(title);
                history.setDescription(errorType.name());
                AcquisitionSvcImpl.this.cmsAcquisitionHistoryMng.save(history);
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class CharsetHandler
    implements ResponseHandler<String> {
        private String charset;

        public CharsetHandler(String charset) {
            this.charset = charset;
        }

        public String handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            StatusLine statusLine = response.getStatusLine();
            if (statusLine.getStatusCode() >= 300) {
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                if (!StringUtils.isBlank((String)this.charset)) {
                    return EntityUtils.toString((HttpEntity)entity, (String)this.charset);
                }
                return EntityUtils.toString((HttpEntity)entity);
            }
            return null;
        }
    }
}

