/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.service;

import com.jeecms.cms.entity.assist.CmsSiteFlow;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.assist.CmsSiteFlowMng;
import com.jeecms.cms.service.CmsSiteFlowCache;
import com.jeecms.cms.statistic.FlowBean;
import com.jeecms.common.ipseek.IPSeeker;
import com.jeecms.common.util.DateFormatUtils;
import com.jeecms.common.util.ParseURLKeyword;
import java.sql.Timestamp;
import java.util.Date;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.apache.commons.lang.StringUtils;
import org.hibernate.HibernateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class CmsSiteFlowCacheImpl
implements CmsSiteFlowCache,
DisposableBean {
    private Logger log = LoggerFactory.getLogger(CmsSiteFlowCacheImpl.class);
    private int interval = 30000;
    private long refreshTime = System.currentTimeMillis();
    @Autowired
    private CmsSiteFlowMng manager;
    @Autowired
    private IPSeeker ipSeeker;
    @Autowired
    @Qualifier(value="cmsSiteFlow")
    private Ehcache cache;

    public void flow(CmsSite site, String ip, String sessionId, String page, String referer) {
        CmsSiteFlow cmsSiteFlow = this.create(site, ip, sessionId, page, referer);
        FlowBean flowBean = new FlowBean(cmsSiteFlow.getAccessDate(), sessionId, page);
        if (this.cache.get((Object)flowBean) == null) {
            CmsSiteFlow bean = null;
            try {
                bean = this.manager.findUniqueByProperties(site.getId(), cmsSiteFlow.getAccessDate(), sessionId, page);
            }
            catch (HibernateException e) {
                this.cache.remove((Object)flowBean);
            }
            if (bean != null) {
                this.cache.put(new Element((Object)flowBean, (Object)bean));
            } else {
                this.cache.put(new Element((Object)flowBean, (Object)cmsSiteFlow));
            }
        }
        this.refreshToDB();
    }

    private CmsSiteFlow create(CmsSite site, String ip, String sessionId, String page, String referer) {
        CmsSiteFlow bean = new CmsSiteFlow();
        Timestamp now = new Timestamp(System.currentTimeMillis());
        bean.setSite(site);
        bean.setAccessIp(ip);
        bean.setAccessPage(page);
        bean.setAccessTime(now);
        bean.setAccessDate(DateFormatUtils.formatDate((Date)now));
        bean.setSessionId(sessionId);
        bean.setRefererPage(referer);
        bean.setRefererWebSite(CmsSiteFlowCacheImpl.getRefererWebSite(referer));
        bean.setArea(this.ipSeeker.getIPLocation(ip).getCountry());
        bean.setRefererKeyword(ParseURLKeyword.getKeyword((String)referer));
        return bean;
    }

    private void refreshToDB() {
        long time = System.currentTimeMillis();
        if (time > this.refreshTime + (long)this.interval) {
            this.refreshTime = time;
            int count = this.manager.freshCacheToDB(this.cache);
            this.cache.removeAll();
            this.log.info("refresh cache flows to DB: {}", (Object)count);
        }
    }

    public void destroy() throws Exception {
        int count = this.manager.freshCacheToDB(this.cache);
        this.log.info("Bean destroy.refresh cache flows to DB: {}", (Object)count);
    }

    private static String getRefererWebSite(String referer) {
        if (StringUtils.isBlank((String)referer)) {
            return "";
        }
        int start = 0;
        int i = 0;
        int count = 3;
        while (i < count && start != -1) {
            start = referer.indexOf(47, start + 1);
            ++i;
        }
        if (start <= 0) {
            throw new IllegalStateException("referer website uri not like 'http://.../...' pattern: " + referer);
        }
        return referer.substring(0, start);
    }

    public void setInterval(int interval) {
        this.interval = interval * 1000;
    }
}

