/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.service;

import com.jeecms.cms.entity.main.ContentCount;
import com.jeecms.cms.manager.main.ContentCountMng;
import com.jeecms.cms.service.ContentCountCache;
import java.io.Serializable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ContentCountCacheImpl
implements ContentCountCache,
DisposableBean {
    private Logger log = LoggerFactory.getLogger(ContentCountCacheImpl.class);
    private int interval = 600000;
    private long refreshTime = System.currentTimeMillis();
    private ContentCountMng contentCountMng;
    private Ehcache cache;

    public int[] viewAndGet(Integer id) {
        ContentCount count = this.contentCountMng.findById(id);
        if (count == null) {
            return null;
        }
        Element e = this.cache.get((Serializable)id);
        Integer views = e != null ? Integer.valueOf((Integer)e.getValue() + 1) : Integer.valueOf(1);
        this.cache.put(new Element((Serializable)id, (Serializable)views));
        this.refreshToDB();
        return new int[]{views + count.getViews(), count.getComments(), count.getDownloads(), count.getUps(), count.getDowns()};
    }

    private void refreshToDB() {
        long time = System.currentTimeMillis();
        if (time > this.refreshTime + (long)this.interval) {
            this.refreshTime = time;
            int count = this.contentCountMng.freshCacheToDB(this.cache);
            this.cache.removeAll();
            this.log.info("refresh cache views to DB: {}", (Object)count);
        }
    }

    public void destroy() throws Exception {
        int count = this.contentCountMng.freshCacheToDB(this.cache);
        this.log.info("Bean destroy.refresh cache views to DB: {}", (Object)count);
    }

    public void setInterval(int interval) {
        this.interval = interval * 60 * 1000;
    }

    @Autowired
    public void setContentCountMng(ContentCountMng contentCountMng) {
        this.contentCountMng = contentCountMng;
    }

    @Autowired
    public void setCache(@Qualifier(value="contentCount") Ehcache cache) {
        this.cache = cache;
    }
}

