/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.staticpage;

import com.jeecms.cms.entity.main.Content;
import com.jeecms.cms.service.ContentListenerAbstract;
import com.jeecms.cms.staticpage.StaticPageSvc;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component
public class ContentStaticPageListener
extends ContentListenerAbstract {
    private static final Logger log = LoggerFactory.getLogger(ContentStaticPageListener.class);
    private static final String IS_CHECKED = "isChecked";
    private StaticPageSvc staticPageSvc;

    @Override
    public void afterSave(Content content) {
        if (content.isChecked()) {
            try {
                this.staticPageSvc.contentRelated(content);
            }
            catch (IOException e) {
                log.error("", (Throwable)e);
            }
            catch (TemplateException e) {
                log.error("", (Throwable)e);
            }
        }
    }

    @Override
    public Map<String, Object> preChange(Content content) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(IS_CHECKED, content.isChecked());
        return map;
    }

    @Override
    public void afterChange(Content content, Map<String, Object> map) {
        boolean pre = (Boolean)map.get(IS_CHECKED);
        boolean curr = content.isChecked();
        try {
            if (pre && !curr) {
                this.staticPageSvc.deleteContent(content);
            } else if (!pre && curr) {
                this.staticPageSvc.contentRelated(content);
            } else if (pre && curr) {
                this.staticPageSvc.contentRelated(content);
            }
        }
        catch (IOException e) {
            log.error("", (Throwable)e);
        }
        catch (TemplateException e) {
            log.error("", (Throwable)e);
        }
    }

    @Override
    public void afterDelete(Content content) {
        this.staticPageSvc.deleteContent(content);
    }

    @Autowired
    public void setStaticPageSvc(StaticPageSvc staticPageSvc) {
        this.staticPageSvc = staticPageSvc;
    }
}

