/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.staticpage;

import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.manager.main.ChannelMng;
import com.jeecms.cms.staticpage.StaticPageSvc;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.common.web.ResponseUtils;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class StaticAct {
    private static final Logger log = LoggerFactory.getLogger(StaticAct.class);
    @Autowired
    private StaticPageSvc staticPageSvc;
    @Autowired
    private ChannelMng channelMng;

    @RequestMapping(value={"/static/v_welcome.do"})
    public String welcome() {
        return "static/welcome";
    }

    @RequestMapping(value={"/static/v_index.do"})
    public String indexInput(HttpServletRequest request, ModelMap model) {
        return "static/index";
    }

    @RequestMapping(value={"/static/o_index.do"})
    public void indexSubmit(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        try {
            CmsSite site = CmsUtils.getSite(request);
            this.staticPageSvc.index(site);
            ResponseUtils.renderJson((HttpServletResponse)response, (String)"{'success':true}");
        }
        catch (IOException e) {
            log.error("static index error!", (Throwable)e);
            ResponseUtils.renderJson((HttpServletResponse)response, (String)("{'success':false,'msg':'" + e.getMessage() + "'}"));
        }
        catch (TemplateException e) {
            log.error("static index error!", (Throwable)e);
            ResponseUtils.renderJson((HttpServletResponse)response, (String)("{'success':false,'msg':'" + e.getMessage() + "'}"));
        }
    }

    @RequestMapping(value={"/static/o_index_remove.do"})
    public void indexRemove(HttpServletRequest request, HttpServletResponse response) {
        CmsSite site = CmsUtils.getSite(request);
        String msg = this.staticPageSvc.deleteIndex(site) ? "{'success':true}" : "{'success':false}";
        ResponseUtils.renderJson((HttpServletResponse)response, (String)msg);
    }

    @RequestMapping(value={"/static/v_channel.do"})
    public String channelInput(HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        List<Channel> topList = this.channelMng.getTopList(site.getId(), false);
        List<Channel> channelList = Channel.getListForSelect(topList, null, null, false);
        model.addAttribute("channelList", channelList);
        return "static/channel";
    }

    @RequestMapping(value={"/static/o_channel.do"})
    public void channelSubmit(Integer channelId, Boolean containChild, HttpServletRequest request, HttpServletResponse response) {
        String msg;
        CmsSite site = CmsUtils.getSite(request);
        if (containChild == null) {
            containChild = true;
        }
        try {
            int count = this.staticPageSvc.channel(site.getId(), channelId, containChild);
            msg = "{'success':true,'count':" + count + "}";
        }
        catch (IOException e) {
            log.error("static channel error!", (Throwable)e);
            msg = "{'success':false,'msg':'" + e.getMessage() + "'}";
        }
        catch (TemplateException e) {
            log.error("static channel error!", (Throwable)e);
            msg = "{'success':false,'msg':'" + e.getMessage() + "'}";
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)msg);
    }

    @RequestMapping(value={"/static/v_content.do"})
    public String contentInput(HttpServletRequest request, ModelMap model) {
        CmsSite site = CmsUtils.getSite(request);
        List<Channel> topList = this.channelMng.getTopList(site.getId(), true);
        List<Channel> channelList = Channel.getListForSelect(topList, null, null, true);
        model.addAttribute("channelList", channelList);
        return "static/content";
    }

    @RequestMapping(value={"/static/o_content.do"})
    public void contentSubmit(Integer channelId, Date startDate, HttpServletRequest request, HttpServletResponse response) {
        String msg;
        try {
            Integer siteId = null;
            if (channelId == null) {
                siteId = CmsUtils.getSiteId(request);
            }
            int count = this.staticPageSvc.content(siteId, channelId, startDate);
            msg = "{'success':true,'count':" + count + "}";
        }
        catch (IOException e) {
            log.error("static channel error!", (Throwable)e);
            msg = "{'success':false,'msg':'" + e.getMessage() + "'}";
        }
        catch (TemplateException e) {
            log.error("static channel error!", (Throwable)e);
            msg = "{'success':false,'msg':'" + e.getMessage() + "'}";
        }
        ResponseUtils.renderJson((HttpServletResponse)response, (String)msg);
    }
}

