/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.staticpage;

import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.Content;
import com.jeecms.cms.manager.assist.CmsKeywordMng;
import com.jeecms.cms.staticpage.StaticPageDao;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.common.hibernate3.Finder;
import com.jeecms.common.hibernate3.HibernateSimpleDao;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.web.springmvc.RealPathResolver;
import com.jeecms.core.web.front.URLHelper;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.hibernate.CacheMode;
import org.hibernate.Query;
import org.hibernate.ScrollMode;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class StaticPageDaoImpl
extends HibernateSimpleDao
implements StaticPageDao {
    private CmsKeywordMng cmsKeywordMng;
    private RealPathResolver realPathResolver;

    @Override
    public int channelStatic(Integer siteId, Integer channelId, boolean containChild, Configuration conf, Map<String, Object> data) throws IOException, TemplateException {
        Finder finder = Finder.create((String)"select bean from Channel bean");
        if (channelId != null) {
            if (containChild) {
                finder.append(",Channel parent where").append(" bean.lft between parent.lft and parent.rgt").append(" and parent.site.id=bean.site.id").append(" and parent.id=:channelId");
                finder.setParam("channelId", (Object)channelId);
            } else {
                finder.append(" where bean.id=:channelId");
                finder.setParam("channelId", (Object)channelId);
            }
        } else if (siteId != null) {
            finder.append(" where bean.site.id=:siteId");
            finder.setParam("siteId", (Object)siteId);
        }
        Session session = this.getSession();
        ScrollableResults channels = finder.createQuery(session).setCacheMode(CacheMode.IGNORE).scroll(ScrollMode.FORWARD_ONLY);
        int count = 0;
        Writer out = null;
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        while (channels.next()) {
            int totalPage;
            Channel c = (Channel)channels.get(0);
            CmsSite site = c.getSite();
            FrontUtils.frontData(data, site, null, null, null);
            if (!StringUtils.isBlank((String)c.getLink()) || !c.getStaticChannel().booleanValue()) continue;
            int childs = this.childsOfChannel((Integer)c.getId());
            if (!c.getModel().getHasContent().booleanValue() || !c.getListChild().booleanValue() && childs > 0) {
                totalPage = 1;
            } else {
                int quantity = c.getListChild() != false ? childs : this.contentsOfChannel((Integer)c.getId());
                totalPage = quantity <= 0 ? 1 : (quantity - 1) / c.getPageSize() + 1;
            }
            int i = 1;
            while (i <= totalPage) {
                String filename = c.getStaticFilename(i);
                String real = this.realPathResolver.get(filename.toString());
                File f = new File(real);
                File parent = f.getParentFile();
                if (!parent.exists()) {
                    parent.mkdirs();
                }
                Template tpl = conf.getTemplate(c.getTplChannelOrDef());
                String urlStatic = c.getUrlStatic(i);
                URLHelper.PageInfo info = URLHelper.getPageInfo((String)filename.substring(filename.lastIndexOf("/")), null);
                FrontUtils.frontPageData(i, info.getHref(), info.getHrefFormer(), info.getHrefLatter(), data);
                FrontUtils.putLocation(data, urlStatic);
                data.put("channel", c);
                try {
                    out = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
                    tpl.process(data, out);
                    this.log.info("create static file: {}", (Object)f.getAbsolutePath());
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
                ++i;
            }
            if (++count % 20 != 0) continue;
            session.clear();
        }
        return count;
    }

    @Override
    public void channelStatic(Channel c, boolean firstOnly, Configuration conf, Map<String, Object> data) throws IOException, TemplateException {
        int totalPage;
        if (!StringUtils.isBlank((String)c.getLink()) || !c.getStaticChannel().booleanValue()) {
            return;
        }
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        int childs = this.childsOfChannel((Integer)c.getId());
        if (firstOnly || !c.getModel().getHasContent().booleanValue() || !c.getListChild().booleanValue() && childs > 0) {
            totalPage = 1;
        } else {
            int quantity = c.getListChild() != false ? childs : this.contentsOfChannel((Integer)c.getId());
            totalPage = quantity <= 0 ? 1 : (quantity - 1) / c.getPageSize() + 1;
        }
        Writer out = null;
        CmsSite site = c.getSite();
        FrontUtils.frontData(data, site, null, null, null);
        int i = 1;
        while (i <= totalPage) {
            String filename = c.getStaticFilename(i);
            String real = this.realPathResolver.get(filename.toString());
            File f = new File(real);
            File parent = f.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            Template tpl = conf.getTemplate(c.getTplChannelOrDef());
            String urlStatic = c.getUrlStatic(i);
            URLHelper.PageInfo info = URLHelper.getPageInfo((String)filename.substring(filename.lastIndexOf("/")), null);
            FrontUtils.frontPageData(i, info.getHref(), info.getHrefFormer(), info.getHrefLatter(), data);
            FrontUtils.putLocation(data, urlStatic);
            data.put("channel", c);
            try {
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
                tpl.process(data, out);
                this.log.info("create static file: {}", (Object)f.getAbsolutePath());
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            ++i;
        }
    }

    @Override
    public int contentsOfChannel(Integer channelId) {
        String hql = "select count(*) from Content bean join bean.channels as channel where channel.id=:channelId and bean.status=2";
        Query query = this.getSession().createQuery(hql);
        query.setParameter("channelId", (Object)channelId);
        return ((Number)query.iterate().next()).intValue();
    }

    @Override
    public int childsOfChannel(Integer channelId) {
        String hql = "select count(*) from Channel bean where bean.parent.id=:channelId";
        Query query = this.getSession().createQuery(hql);
        query.setParameter("channelId", (Object)channelId);
        return ((Number)query.iterate().next()).intValue();
    }

    @Override
    public int contentStatic(Integer siteId, Integer channelId, Date start, Configuration conf, Map<String, Object> data) throws IOException, TemplateException {
        Finder f = Finder.create((String)"select bean from Content bean");
        if (channelId != null) {
            f.append(" join bean.channel node,Channel parent");
            f.append(" where node.lft between parent.lft and parent.rgt");
            f.append(" and parent.id=:channelId");
            f.append(" and node.site.id=parent.site.id");
            f.setParam("channelId", (Object)channelId);
        } else if (siteId != null) {
            f.append(" where bean.site.id=:siteId");
            f.setParam("siteId", (Object)siteId);
        } else {
            f.append(" where 1=1");
        }
        if (start != null) {
            f.append(" and bean.sortDate>=:start");
            f.setParam("start", (Object)start);
        }
        f.append(" and bean.status=2");
        Session session = this.getSession();
        ScrollableResults contents = f.createQuery(session).setCacheMode(CacheMode.IGNORE).scroll(ScrollMode.FORWARD_ONLY);
        int count = 0;
        Writer out = null;
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        while (contents.next()) {
            Content c = (Content)contents.get(0);
            Channel chnl = c.getChannel();
            if (!StringUtils.isBlank((String)c.getLink()) || !chnl.getStaticContent().booleanValue() || !c.getNeedRegenerate().booleanValue()) continue;
            CmsSite site = c.getSite();
            Template tpl = conf.getTemplate(c.getTplContentOrDef());
            FrontUtils.frontData(data, site, null, null, null);
            data.put("content", c);
            data.put("channel", c.getChannel());
            int totalPage = c.getPageCount();
            int pageNo = 1;
            while (pageNo <= totalPage) {
                File file;
                String real;
                String txt = c.getTxtByNo(pageNo);
                txt = this.cmsKeywordMng.attachKeyword(site.getId(), txt);
                SimplePage pagination = new SimplePage(pageNo, 1, c.getPageCount());
                data.put("pagination", pagination);
                String url = c.getUrlStatic(pageNo);
                URLHelper.PageInfo info = URLHelper.getPageInfo((String)url.substring(url.lastIndexOf("/")), null);
                FrontUtils.putLocation(data, url);
                FrontUtils.frontPageData(pageNo, info.getHref(), info.getHrefFormer(), info.getHrefLatter(), data);
                data.put("title", c.getTitleByNo(pageNo));
                data.put("txt", txt);
                data.put("pic", c.getPictureByNo(pageNo));
                if (pageNo == 1) {
                    real = this.realPathResolver.get(c.getStaticFilename(pageNo));
                    file = new File(real);
                    File parent = file.getParentFile();
                    if (!parent.exists()) {
                        parent.mkdirs();
                    }
                } else {
                    real = this.realPathResolver.get(c.getStaticFilename(pageNo));
                    file = new File(real);
                }
                try {
                    out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                    tpl.process(data, out);
                    this.log.info("create static file: {}", (Object)file.getAbsolutePath());
                }
                finally {
                    if (out != null) {
                        out.close();
                    }
                }
                ++pageNo;
            }
            c.setNeedRegenerate(false);
            if (++count % 20 != 0) continue;
            session.clear();
        }
        return count;
    }

    @Override
    public boolean contentStatic(Content c, Configuration conf, Map<String, Object> data) throws IOException, TemplateException {
        Channel chnl = c.getChannel();
        if (!StringUtils.isBlank((String)c.getLink()) || !chnl.getStaticContent().booleanValue()) {
            return false;
        }
        if (!c.getNeedRegenerate().booleanValue()) {
            return false;
        }
        if (data == null) {
            data = new HashMap<String, Object>();
        }
        Writer out = null;
        CmsSite site = c.getSite();
        Template tpl = conf.getTemplate(c.getTplContentOrDef());
        FrontUtils.frontData(data, site, null, null, null);
        data.put("content", c);
        data.put("channel", chnl);
        int totalPage = c.getPageCount();
        int pageNo = 1;
        while (pageNo <= totalPage) {
            File parent;
            String txt = c.getTxtByNo(pageNo);
            txt = this.cmsKeywordMng.attachKeyword(site.getId(), txt);
            SimplePage pagination = new SimplePage(pageNo, 1, c.getPageCount());
            data.put("pagination", pagination);
            String url = c.getUrlStatic(pageNo);
            URLHelper.PageInfo info = URLHelper.getPageInfo((String)url.substring(url.lastIndexOf("/")), null);
            FrontUtils.putLocation(data, url);
            FrontUtils.frontPageData(pageNo, info.getHref(), info.getHrefFormer(), info.getHrefLatter(), data);
            data.put("title", c.getTitleByNo(pageNo));
            data.put("txt", txt);
            data.put("pic", c.getPictureByNo(pageNo));
            String real = this.realPathResolver.get(c.getStaticFilename(pageNo));
            File file = new File(real);
            if (pageNo == 1 && !(parent = file.getParentFile()).exists()) {
                parent.mkdirs();
            }
            try {
                out = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
                tpl.process(data, out);
                this.log.info("create static file: {}", (Object)file.getAbsolutePath());
            }
            finally {
                if (out != null) {
                    out.close();
                }
            }
            ++pageNo;
        }
        c.setNeedRegenerate(false);
        return true;
    }

    @Autowired
    public void setCmsKeywordMng(CmsKeywordMng cmsKeywordMng) {
        this.cmsKeywordMng = cmsKeywordMng;
    }

    @Autowired
    public void setRealPathResolver(RealPathResolver realPathResolver) {
        this.realPathResolver = realPathResolver;
    }
}

