/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.staticpage;

import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.Content;
import com.jeecms.cms.staticpage.StaticPageDao;
import com.jeecms.cms.staticpage.StaticPageSvc;
import com.jeecms.cms.web.FrontUtils;
import com.jeecms.common.web.springmvc.RealPathResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.servlet.view.freemarker.FreeMarkerConfigurer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
public class StaticPageSvcImpl
implements StaticPageSvc,
InitializingBean {
    private Logger log = LoggerFactory.getLogger(StaticPageSvcImpl.class);
    private MessageSource tplMessageSource;
    private RealPathResolver realPathResolver;
    private StaticPageDao staticPageDao;
    private Configuration conf;

    @Override
    @Transactional
    public int content(Integer siteId, Integer channelId, Date start) throws IOException, TemplateException {
        long time = System.currentTimeMillis();
        HashMap<String, Object> data = new HashMap<String, Object>();
        int count = this.staticPageDao.contentStatic(siteId, channelId, start, this.conf, data);
        time = System.currentTimeMillis() - time;
        this.log.info("create content page count {}, in {} ms", (Object)count, (Object)time);
        return count;
    }

    @Override
    @Transactional
    public boolean content(Content content) throws IOException, TemplateException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        long time = System.currentTimeMillis();
        boolean generated = this.staticPageDao.contentStatic(content, this.conf, data);
        time = System.currentTimeMillis() - time;
        this.log.info("create content page in {} ms", (Object)time);
        return generated;
    }

    @Override
    @Transactional(readOnly=true)
    public void contentRelated(Content content) throws IOException, TemplateException {
        this.content(content);
        Channel channel = content.getChannel();
        while (channel != null) {
            this.channel(channel, true);
            channel = channel.getParent();
        }
        if (content.getSite().getStaticIndex().booleanValue()) {
            this.index(content.getSite());
        }
    }

    @Override
    @Transactional(readOnly=true)
    public void deleteContent(Content content) {
        int totalPage = content.getPageCount();
        int pageNo = 1;
        while (pageNo <= totalPage) {
            String real = this.realPathResolver.get(content.getStaticFilename(pageNo));
            File file = new File(real);
            file.delete();
            ++pageNo;
        }
    }

    @Override
    @Transactional(readOnly=true)
    public int channel(Integer siteId, Integer channelId, boolean containChild) throws IOException, TemplateException {
        long time = System.currentTimeMillis();
        HashMap<String, Object> data = new HashMap<String, Object>();
        int count = this.staticPageDao.channelStatic(siteId, channelId, containChild, this.conf, data);
        time = System.currentTimeMillis() - time;
        this.log.info("create channel page count {}, in {} ms", (Object)count, (Object)time);
        return count;
    }

    @Override
    @Transactional(readOnly=true)
    public void channel(Channel channel, boolean firstOnly) throws IOException, TemplateException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        long time = System.currentTimeMillis();
        this.staticPageDao.channelStatic(channel, firstOnly, this.conf, data);
        time = System.currentTimeMillis() - time;
        this.log.info("create channel page in {} ms", (Object)time);
    }

    @Override
    @Transactional(readOnly=true)
    public void deleteChannel(Channel channel) {
        int totalPage;
        if (!StringUtils.isBlank((String)channel.getLink()) || !channel.getStaticChannel().booleanValue()) {
            return;
        }
        int childs = this.staticPageDao.childsOfChannel((Integer)channel.getId());
        if (!channel.getModel().getHasContent().booleanValue() || !channel.getListChild().booleanValue() && childs > 0) {
            totalPage = 1;
        } else {
            int quantity = channel.getListChild() != false ? childs : this.staticPageDao.contentsOfChannel((Integer)channel.getId());
            totalPage = quantity <= 0 ? 1 : (quantity - 1) / channel.getPageSize() + 1;
        }
        int i = 1;
        while (i <= totalPage) {
            String filename = channel.getStaticFilename(i);
            String real = this.realPathResolver.get(filename.toString());
            File f = new File(real);
            f.delete();
            ++i;
        }
    }

    @Override
    @Transactional(readOnly=true)
    public void index(CmsSite site) throws IOException, TemplateException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        FrontUtils.frontData(data, site, null, site.getUrlStatic(), null);
        String tpl = FrontUtils.getTplPath(this.tplMessageSource, site.getLocaleAdmin(), site.getSolutionPath(), "index", "tpl.index");
        this.index(site, tpl, data);
    }

    @Override
    @Transactional(readOnly=true)
    public void index(CmsSite site, String tpl, Map<String, Object> data) throws IOException, TemplateException {
        long time = System.currentTimeMillis();
        File f = new File(this.getIndexPath(site));
        File parent = f.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        Writer out = null;
        try {
            out = new OutputStreamWriter((OutputStream)new FileOutputStream(f), "UTF-8");
            Template template = this.conf.getTemplate(tpl);
            template.process(data, out);
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
        time = System.currentTimeMillis() - time;
        this.log.info("create index page, in {} ms", (Object)time);
    }

    @Override
    @Transactional(readOnly=true)
    public boolean deleteIndex(CmsSite site) {
        File f = new File(this.getIndexPath(site));
        return f.delete();
    }

    private String getIndexPath(CmsSite site) {
        StringBuilder pathBuff = new StringBuilder();
        if (!site.getIndexToRoot().booleanValue() && !StringUtils.isBlank((String)site.getStaticDir())) {
            pathBuff.append(site.getStaticDir());
        }
        pathBuff.append("/").append("index").append(site.getStaticSuffix());
        return this.realPathResolver.get(pathBuff.toString());
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.conf, (String)"freemarker configuration cannot be null!");
        Assert.notNull((Object)this.tplMessageSource, (String)"tplMessageSource configuration cannot be null!");
    }

    public void setFreeMarkerConfigurer(FreeMarkerConfigurer freeMarkerConfigurer) {
        this.conf = freeMarkerConfigurer.getConfiguration();
    }

    public void setTplMessageSource(MessageSource tplMessageSource) {
        this.tplMessageSource = tplMessageSource;
    }

    @Autowired
    public void setStaticPageDao(StaticPageDao staticPageDao) {
        this.staticPageDao = staticPageDao;
    }

    @Autowired
    public void setRealPathResolver(RealPathResolver realPathResolver) {
        this.realPathResolver = realPathResolver;
    }
}

