/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.statistic;

import java.text.NumberFormat;
import java.util.Date;

public class CmsStatistic {
    public static final String JOIN = "-";
    public static final String TIMEPATTERN = "HH:mm:ss";
    public static final String PERCENTSIGN = "%";
    public static final double COEFFICIENT = 0.8;
    public static final int MEMBER = 1;
    public static final int CONTENT = 2;
    public static final int COMMENT = 3;
    public static final int GUESTBOOK = 4;
    public static final int PV = 11;
    public static final int UNIQUEIP = 12;
    public static final int UNIQUEVISITOR = 13;
    public static final int AVGVIEWS = 14;
    public static final int TODAY = 21;
    public static final int YESTERDAY = 22;
    public static final int THISWEEK = 23;
    public static final int THISMONTH = 24;
    public static final int THISYEAR = 25;
    public static final String REFERER_WEBSITE = "refererWebSite";
    public static final String REFERER_PAGE = "refererPage";
    public static final String REFERER_KEYWORD = "refererKeyword";
    public static final String ACCESS_PAGE = "accessPage";
    public static final String AREA = "area";
    public static final String SITEID = "siteId";
    public static final String ISREPLYED = "isReplyed";
    public static final String USERID = "userId";
    public static final String CHANNELID = "channelId";
    private String description;
    private String vice;
    private Long count;
    private Long total;

    public CmsStatistic() {
    }

    public CmsStatistic(Long count) {
        this.count = count;
    }

    public CmsStatistic(String description, Long count) {
        this(count);
        this.description = description;
    }

    public CmsStatistic(String description, Long count, Long total) {
        this(description, count);
        this.total = total;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getCount() {
        return this.count;
    }

    public void setCount(Long count) {
        this.count = count;
    }

    public Long getTotal() {
        return this.total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public String getVice() {
        return this.vice;
    }

    public void setVice(String vice) {
        this.vice = vice;
    }

    public String getPercent() {
        return NumberFormat.getPercentInstance().format((double)this.count.longValue() / (this.total == 0L ? 1.0 : (double)this.total.longValue() + 0.0));
    }

    public String getBarWidth() {
        return String.valueOf((int)((double)Integer.parseInt(this.getPercent().replace(PERCENTSIGN, "")) * 0.8)) + PERCENTSIGN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CmsStatisticModel {
        day,
        week,
        month,
        year;

    }

    public static class TimeRange {
        private final Date begin;
        private final Date end;

        public Date getBegin() {
            return this.begin;
        }

        public Date getEnd() {
            return this.end;
        }

        private TimeRange(Date begin, Date end) {
            this.begin = begin;
            this.end = end;
        }

        public static TimeRange getInstance(Date begin, Date end) {
            if (begin == null || end == null) {
                throw new IllegalArgumentException("Params begin and end cannot be null!");
            }
            return new TimeRange(begin, end);
        }
    }
}

