/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.statistic;

import com.jeecms.cms.entity.main.Channel;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.manager.main.ChannelMng;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.statistic.CmsStatistic;
import com.jeecms.cms.statistic.CmsStatisticSvc;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.page.SimplePage;
import com.jeecms.common.web.CookieUtils;
import com.jeecms.common.web.RequestUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Controller
public class CmsStatisticAct {
    @Autowired
    private ChannelMng channelMng;
    @Autowired
    private CmsUserMng cmsUserMng;
    @Autowired
    private CmsStatisticSvc cmsStatisticSvc;

    @RequestMapping(value={"/statistic_member/v_list.do"})
    public String memberList(String queryModel, Integer year, Integer month, Integer day, ModelMap model) {
        CmsStatistic.CmsStatisticModel statisticModel = this.getStatisticModel(queryModel);
        List<CmsStatistic> list = this.cmsStatisticSvc.statisticByModel(1, statisticModel, year, month, day, null);
        this.putCommonData(statisticModel, list, year, month, day, model);
        return "statistic/member/list";
    }

    @RequestMapping(value={"/statistic_content/v_list.do"})
    public String contentList(HttpServletRequest request, String queryModel, Integer channelId, Integer year, Integer month, Integer day, ModelMap model) {
        String queryInputUsername = RequestUtils.getQueryParam((HttpServletRequest)request, (String)"queryInputUsername");
        Number queryInputUserId = null;
        if (!StringUtils.isBlank((String)queryInputUsername)) {
            CmsUser u = this.cmsUserMng.findByUsername(queryInputUsername);
            if (u != null) {
                queryInputUserId = u.getId();
            } else {
                queryInputUsername = null;
            }
        }
        HashMap<String, Object> restrictions = new HashMap<String, Object>();
        Integer siteId = CmsUtils.getSiteId(request);
        restrictions.put("siteId", siteId);
        restrictions.put("userId", queryInputUserId);
        restrictions.put("channelId", channelId);
        CmsStatistic.CmsStatisticModel statisticModel = this.getStatisticModel(queryModel);
        List<CmsStatistic> list = this.cmsStatisticSvc.statisticByModel(2, statisticModel, year, month, day, restrictions);
        List<Channel> topList = this.channelMng.getTopList(siteId, true);
        List<Channel> channelList = Channel.getListForSelect(topList, null, true);
        this.putCommonData(statisticModel, list, year, month, day, model);
        model.addAttribute("queryInputUsername", (Object)queryInputUsername);
        model.addAttribute("channelList", channelList);
        model.addAttribute("channelId", (Object)channelId);
        return "statistic/content/list";
    }

    @RequestMapping(value={"/statistic_comment/v_list.do"})
    public String commentList(HttpServletRequest request, String queryModel, Integer year, Integer month, Integer day, Boolean isReplyed, ModelMap model) {
        HashMap<String, Object> restrictions = new HashMap<String, Object>();
        Integer siteId = CmsUtils.getSiteId(request);
        restrictions.put("siteId", siteId);
        restrictions.put("isReplyed", isReplyed);
        CmsStatistic.CmsStatisticModel statisticModel = this.getStatisticModel(queryModel);
        List<CmsStatistic> list = this.cmsStatisticSvc.statisticByModel(3, statisticModel, year, month, day, restrictions);
        this.putCommonData(statisticModel, list, year, month, day, model);
        model.addAttribute("isReplyed", (Object)isReplyed);
        return "statistic/comment/list";
    }

    @RequestMapping(value={"/statistic_guestbook/v_list.do"})
    public String guestbookList(HttpServletRequest request, String queryModel, Integer year, Integer month, Integer day, Boolean isReplyed, ModelMap model) {
        HashMap<String, Object> restrictions = new HashMap<String, Object>();
        Integer siteId = CmsUtils.getSiteId(request);
        restrictions.put("siteId", siteId);
        restrictions.put("isReplyed", isReplyed);
        CmsStatistic.CmsStatisticModel statisticModel = this.getStatisticModel(queryModel);
        List<CmsStatistic> list = this.cmsStatisticSvc.statisticByModel(4, statisticModel, year, month, day, restrictions);
        this.putCommonData(statisticModel, list, year, month, day, model);
        model.addAttribute("isReplyed", (Object)isReplyed);
        return "statistic/guestbook/list";
    }

    @RequestMapping(value={"/flow_pv/v_list.do"})
    public String pageViewList(HttpServletRequest request, ModelMap model) {
        Integer siteId = CmsUtils.getSiteId(request);
        List<CmsStatistic> list = this.cmsStatisticSvc.flowStatistic(11, siteId);
        model.addAttribute("list", list);
        return "statistic/pv/list";
    }

    @RequestMapping(value={"/flow_uniqueIp/v_list.do"})
    public String uniqueIpList(HttpServletRequest request, ModelMap model) {
        Integer siteId = CmsUtils.getSiteId(request);
        List<CmsStatistic> list = this.cmsStatisticSvc.flowStatistic(12, siteId);
        model.addAttribute("list", list);
        return "statistic/uniqueIp/list";
    }

    @RequestMapping(value={"/flow_uniqueVisitor/v_list.do"})
    public String uniqueVisitorList(HttpServletRequest request, ModelMap model) {
        Integer siteId = CmsUtils.getSiteId(request);
        List<CmsStatistic> list = this.cmsStatisticSvc.flowStatistic(13, siteId);
        model.addAttribute("list", list);
        return "statistic/uniqueVisitor/list";
    }

    @RequestMapping(value={"/flow_avgViews/v_list.do"})
    public String avgViewsList(HttpServletRequest request, ModelMap model) {
        Integer siteId = CmsUtils.getSiteId(request);
        List<CmsStatistic> list = this.cmsStatisticSvc.flowStatistic(14, siteId);
        model.addAttribute("list", list);
        return "statistic/avgViews/list";
    }

    @RequestMapping(value={"/flow_refererWebSite/v_list.do"})
    public String refererWebSite(HttpServletRequest request, Integer pageNo, ModelMap model) {
        Integer siteId = CmsUtils.getSiteId(request);
        Pagination pagination = this.cmsStatisticSvc.flowAnalysisPage("refererWebSite", siteId, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("total", (Object)this.getTotal(pagination.getList()));
        return "statistic/refererWebSite/list";
    }

    @RequestMapping(value={"/flow_refererPage/v_list.do"})
    public String refererPage(HttpServletRequest request, Integer pageNo, ModelMap model) {
        Integer siteId = CmsUtils.getSiteId(request);
        Pagination pagination = this.cmsStatisticSvc.flowAnalysisPage("refererPage", siteId, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("total", (Object)this.getTotal(pagination.getList()));
        return "statistic/refererPage/list";
    }

    @RequestMapping(value={"/flow_accessPage/v_list.do"})
    public String accessPage(HttpServletRequest request, Integer pageNo, ModelMap model) {
        Integer siteId = CmsUtils.getSiteId(request);
        Pagination pagination = this.cmsStatisticSvc.flowAnalysisPage("accessPage", siteId, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("total", (Object)this.getTotal(pagination.getList()));
        return "statistic/accessPage/list";
    }

    @RequestMapping(value={"/flow_area/v_list.do"})
    public String area(HttpServletRequest request, Integer pageNo, ModelMap model) {
        Integer siteId = CmsUtils.getSiteId(request);
        Pagination pagination = this.cmsStatisticSvc.flowAnalysisPage("area", siteId, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("total", (Object)this.getTotal(pagination.getList()));
        return "statistic/area/list";
    }

    @RequestMapping(value={"/flow_refererKeyword/v_list.do"})
    public String refererKeyword(HttpServletRequest request, Integer pageNo, ModelMap model) {
        Integer siteId = CmsUtils.getSiteId(request);
        Pagination pagination = this.cmsStatisticSvc.flowAnalysisPage("refererKeyword", siteId, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("total", (Object)this.getTotal(pagination.getList()));
        return "statistic/refererKeyword/list";
    }

    @RequestMapping(value={"/statistic_flow/v_init.do"})
    public String flowInitView(HttpServletRequest request, Integer pageNo, ModelMap model) {
        return "statistic/init";
    }

    @RequestMapping(value={"/statistic_flow/o_init.do"})
    public String flowInit(HttpServletRequest request, Date startDate, Date endDate, Integer pageNo, ModelMap model) {
        Integer siteId = CmsUtils.getSiteId(request);
        this.cmsStatisticSvc.flowInit(siteId, startDate, endDate);
        model.addAttribute("message", (Object)"global.success");
        return "statistic/init";
    }

    private CmsStatistic.CmsStatisticModel getStatisticModel(String queryModel) {
        if (!StringUtils.isBlank((String)queryModel)) {
            return CmsStatistic.CmsStatisticModel.valueOf(queryModel);
        }
        return CmsStatistic.CmsStatisticModel.year;
    }

    private void putCommonData(CmsStatistic.CmsStatisticModel statisticModel, List<CmsStatistic> list, Integer year, Integer month, Integer day, ModelMap model) {
        model.addAttribute("list", list);
        model.addAttribute("total", (Object)this.getTotal(list));
        model.addAttribute("statisticModel", (Object)statisticModel.name());
        model.addAttribute("year", (Object)year);
        model.addAttribute("month", (Object)month);
        model.addAttribute("day", (Object)day);
    }

    private Long getTotal(List<CmsStatistic> list) {
        return list.size() > 0 ? list.iterator().next().getTotal() : 0L;
    }
}

