/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.statistic;

import com.jeecms.cms.statistic.CmsStatistic;
import com.jeecms.cms.statistic.CmsStatisticDao;
import com.jeecms.common.hibernate3.Finder;
import com.jeecms.common.hibernate3.HibernateSimpleDao;
import com.jeecms.common.page.Pagination;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Repository
public class CmsStatisticDaoImpl
extends HibernateSimpleDao
implements CmsStatisticDao {
    @Override
    public long memberStatistic(CmsStatistic.TimeRange timeRange) {
        Finder f = this.createCacheableFinder("select count(*) from CmsUser bean where 1=1");
        if (timeRange != null) {
            f.append(" and bean.registerTime >= :begin");
            f.append(" and bean.registerTime < :end");
            f.setParam("begin", (Object)timeRange.getBegin());
            f.setParam("end", (Object)timeRange.getEnd());
        }
        return (Long)this.find(f).iterator().next();
    }

    @Override
    public long contentStatistic(CmsStatistic.TimeRange timeRange, Map<String, Object> restrictions) {
        Finder f = this.createCacheableFinder("select count(*) from Content bean");
        Integer userId = (Integer)restrictions.get("userId");
        Integer channelId = (Integer)restrictions.get("channelId");
        if (channelId != null) {
            f.append(" join bean.channel channel,Channel parent");
            f.append(" where channel.lft between parent.lft and parent.rgt");
            f.append(" and channel.site.id=parent.site.id");
            f.append(" and parent.id=:parentId");
            f.setParam("parentId", (Object)channelId);
        } else {
            f.append(" where bean.site.id=:siteId").setParam("siteId", restrictions.get("siteId"));
        }
        if (timeRange != null) {
            f.append(" and bean.contentExt.releaseDate >= :begin");
            f.append(" and bean.contentExt.releaseDate < :end");
            f.setParam("begin", (Object)timeRange.getBegin());
            f.setParam("end", (Object)timeRange.getEnd());
        }
        if (userId != null) {
            f.append(" and bean.user.id=:userId").setParam("userId", (Object)userId);
        }
        return (Long)this.find(f).iterator().next();
    }

    @Override
    public long commentStatistic(CmsStatistic.TimeRange timeRange, Map<String, Object> restrictions) {
        Boolean isReplyed;
        Finder f = this.createCacheableFinder("select count(*) from CmsComment bean where bean.site.id=:siteId");
        f.setParam("siteId", restrictions.get("siteId"));
        if (timeRange != null) {
            f.append(" and bean.createTime >= :begin");
            f.append(" and bean.createTime < :end");
            f.setParam("begin", (Object)timeRange.getBegin());
            f.setParam("end", (Object)timeRange.getEnd());
        }
        if ((isReplyed = (Boolean)restrictions.get("isReplyed")) != null) {
            if (isReplyed.booleanValue()) {
                f.append(" and bean.replayTime is not null");
            } else {
                f.append(" and bean.replayTime is null");
            }
        }
        return (Long)this.find(f).iterator().next();
    }

    @Override
    public long guestbookStatistic(CmsStatistic.TimeRange timeRange, Map<String, Object> restrictions) {
        Boolean isReplyed;
        Finder f = this.createCacheableFinder("select count(*) from CmsGuestbook bean where bean.site.id=:siteId");
        f.setParam("siteId", restrictions.get("siteId"));
        if (timeRange != null) {
            f.append(" and bean.createTime >= :begin");
            f.append(" and bean.createTime < :end");
            f.setParam("begin", (Object)timeRange.getBegin());
            f.setParam("end", (Object)timeRange.getEnd());
        }
        if ((isReplyed = (Boolean)restrictions.get("isReplyed")) != null) {
            if (isReplyed.booleanValue()) {
                f.append(" and bean.replayTime is not null");
            } else {
                f.append(" and bean.replayTime is null");
            }
        }
        return (Long)this.find(f).iterator().next();
    }

    @Override
    public List<Object[]> getPvCountByGroup(Integer siteId) {
        Finder f = this.createCacheableFinder("select count(*),bean.accessDate from CmsSiteFlow bean where bean.site.id=:siteId group by bean.accessDate");
        f.setParam("siteId", (Object)siteId);
        return this.find(f);
    }

    @Override
    public long getPvCountByTimeRange(Integer siteId, CmsStatistic.TimeRange timeRange) {
        Finder f = this.createCacheableFinder("select count(*) from CmsSiteFlow bean");
        return this.byTimeRange(f, siteId, timeRange);
    }

    @Override
    public long getPvCount(Integer siteId) {
        return this.getPvCountByTimeRange(siteId, null);
    }

    @Override
    public List<Object[]> getUniqueIpCountByGroup(Integer siteId) {
        Finder f = this.createCacheableFinder("select count(distinct bean.accessIp),bean.accessDate from CmsSiteFlow bean where bean.site.id=:siteId group by bean.accessDate");
        f.setParam("siteId", (Object)siteId);
        return this.find(f);
    }

    @Override
    public long getUniqueIpCountByTimeRange(Integer siteId, CmsStatistic.TimeRange timeRange) {
        Finder f = this.createCacheableFinder("select count(distinct bean.accessIp) from CmsSiteFlow bean");
        return this.byTimeRange(f, siteId, timeRange);
    }

    @Override
    public long getUniqueIpCount(Integer siteId) {
        return this.getUniqueIpCountByTimeRange(siteId, null);
    }

    @Override
    public List<Object[]> getUniqueVisitorCountByGroup(Integer siteId) {
        Finder f = this.createCacheableFinder("select count(distinct bean.sessionId),bean.accessDate from CmsSiteFlow bean where bean.site.id=:siteId group by bean.accessDate");
        f.setParam("siteId", (Object)siteId);
        return this.find(f);
    }

    @Override
    public long getUniqueVisitorCountByTimeRange(Integer siteId, CmsStatistic.TimeRange timeRange) {
        Finder f = this.createCacheableFinder("select count(distinct bean.sessionId) from CmsSiteFlow bean");
        return this.byTimeRange(f, siteId, timeRange);
    }

    @Override
    public long getUniqueVisitorCount(Integer siteId) {
        return this.getUniqueVisitorCountByTimeRange(siteId, null);
    }

    @Override
    public Pagination flowAnalysisPage(String groupCondition, Integer siteId, Integer pageNo, Integer pageSize) {
        Finder f = this.createCacheableFinder("select count(*),bean." + groupCondition + " from CmsSiteFlow bean where bean.site.id=:siteId group by bean." + groupCondition + " order by count(*) desc");
        f.setParam("siteId", (Object)siteId);
        f.setMaxResults(pageSize.intValue());
        f.setFirstResult((pageNo - 1) * pageSize);
        return new Pagination(pageNo.intValue(), pageSize.intValue(), this.getTotalCount(f.getOrigHql(), siteId), this.find(f));
    }

    @Override
    public void flowInit(Integer siteId, Date startDate, Date endDate) {
        Finder f = Finder.create((String)"delete from CmsSiteFlow bean where bean.site.id=:siteId");
        f.setParam("siteId", (Object)siteId);
        if (startDate != null) {
            f.append(" and bean.accessTime >= :startDate");
            f.setParam("startDate", (Object)startDate);
        }
        if (endDate != null) {
            f.append(" and bean.accessTime <= :endDate");
            f.setParam("endDate", (Object)endDate);
        }
        Query query = f.createQuery(this.getSession());
        query.executeUpdate();
    }

    @Override
    public long flowAnalysisTotal(Integer siteId) {
        Finder f = this.createCacheableFinder("select count(*) from CmsSiteFlow bean where bean.site.id=:siteId");
        f.setParam("siteId", (Object)siteId);
        return (Long)this.find(f).iterator().next();
    }

    private int getTotalCount(String hql, Integer siteId) {
        Finder f = this.createCacheableFinder(hql);
        f.setParam("siteId", (Object)siteId);
        return this.find(f).size();
    }

    private long byTimeRange(Finder f, Integer siteId, CmsStatistic.TimeRange timeRange) {
        f.append(" where bean.site.id=:siteId").setParam("siteId", (Object)siteId);
        if (timeRange != null) {
            f.append(" and bean.accessTime >= :begin");
            f.append(" and bean.accessTime < :end");
            f.setParam("begin", (Object)timeRange.getBegin());
            f.setParam("end", (Object)timeRange.getEnd());
        }
        return (Long)this.find(f).iterator().next();
    }

    private Finder createCacheableFinder(String hql) {
        Finder finder = Finder.create((String)hql);
        finder.setCacheable(true);
        return finder;
    }
}

