/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.statistic;

import com.jeecms.cms.statistic.CmsStatistic;
import com.jeecms.cms.statistic.CmsStatisticDao;
import com.jeecms.cms.statistic.CmsStatisticSvc;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.util.ArithmeticUtils;
import com.jeecms.common.util.DateFormatUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional(readOnly=true)
public class CmsStatisticSvcImpl
implements CmsStatisticSvc {
    @Autowired
    private CmsStatisticDao dao;

    @Override
    public List<CmsStatistic> statisticByModel(int type, CmsStatistic.CmsStatisticModel statisticModel, Integer year, Integer month, Integer day, Map<String, Object> restrictions) {
        month = month == null ? Integer.valueOf(0) : Integer.valueOf(month - 1);
        if (day == null) {
            day = 1;
        }
        GregorianCalendar calendar = year == null ? new GregorianCalendar() : new GregorianCalendar(year, month, day);
        return this.statisticByModel(type, statisticModel, calendar, restrictions);
    }

    private List<CmsStatistic> statisticByModel(int type, CmsStatistic.CmsStatisticModel statisticModel, Calendar calendar, Map<String, Object> restrictions) {
        switch (statisticModel) {
            case day: {
                return this.statisticByDay(type, calendar, restrictions);
            }
            case week: {
                return this.statisticByWeek(type, calendar, restrictions);
            }
            case month: {
                return this.statisticByMonth(type, calendar, restrictions);
            }
            case year: {
                return this.statisticByYear(type, calendar, restrictions);
            }
        }
        return new ArrayList<CmsStatistic>();
    }

    private List<CmsStatistic> statisticByDay(int type, Calendar calendar, Map<String, Object> restrictions) {
        calendar = this.clearTime(calendar);
        ArrayList<CmsStatistic> list = new ArrayList<CmsStatistic>();
        long total = 0L;
        long count = 0L;
        Calendar clone = (Calendar)calendar.clone();
        total = this.statistic(type, this.getTimeRange(21, clone), restrictions);
        int i = 0;
        while (i < 24) {
            calendar.set(11, i);
            Date begin = calendar.getTime();
            calendar.set(11, i + 1);
            Date end = calendar.getTime();
            count = this.statistic(type, CmsStatistic.TimeRange.getInstance(begin, end), restrictions);
            CmsStatistic bean = new CmsStatistic(this.format(i), count, total);
            list.add(bean);
            ++i;
        }
        return list;
    }

    private List<CmsStatistic> statisticByWeek(int type, Calendar calendar, Map<String, Object> restrictions) {
        calendar = this.clearTime(calendar);
        this.flush(calendar);
        ArrayList<CmsStatistic> list = new ArrayList<CmsStatistic>();
        long total = 0L;
        long count = 0L;
        Calendar clone = (Calendar)calendar.clone();
        total = this.statistic(type, this.getTimeRange(23, clone), restrictions);
        int i = 1;
        while (i <= 7) {
            calendar.set(7, i);
            Date begin = calendar.getTime();
            if (i == 7) {
                calendar.add(7, 1);
            } else {
                calendar.set(7, i + 1);
            }
            Date end = calendar.getTime();
            count = this.statistic(type, CmsStatistic.TimeRange.getInstance(begin, end), restrictions);
            CmsStatistic bean = new CmsStatistic(String.valueOf(i), count, total);
            list.add(bean);
            ++i;
        }
        return list;
    }

    private List<CmsStatistic> statisticByMonth(int type, Calendar calendar, Map<String, Object> restrictions) {
        ArrayList<CmsStatistic> list = new ArrayList<CmsStatistic>();
        int year = this.getYear(calendar);
        int month = this.getMonth(calendar);
        long total = 0L;
        long count = 0L;
        int day = 1;
        calendar = new GregorianCalendar(year, month, day);
        total = this.statistic(type, this.getTimeRange(24, (Calendar)calendar.clone()), restrictions);
        Calendar clone = (Calendar)calendar.clone();
        clone.set(2, month + 1);
        Date end = clone.getTime();
        clone.add(5, -1);
        int days = this.getDay(clone);
        int i = 1;
        while (i <= days) {
            calendar.set(5, i);
            Date begin = calendar.getTime();
            calendar.set(5, i + 1);
            end = calendar.getTime();
            count = this.statistic(type, CmsStatistic.TimeRange.getInstance(begin, end), restrictions);
            CmsStatistic bean = new CmsStatistic(String.valueOf(i), count, total);
            list.add(bean);
            ++i;
        }
        return list;
    }

    private List<CmsStatistic> statisticByYear(int type, Calendar calendar, Map<String, Object> restrictions) {
        ArrayList<CmsStatistic> list = new ArrayList<CmsStatistic>();
        int year = this.getYear(calendar);
        long total = 0L;
        long count = 0L;
        int day = 1;
        int month = 0;
        calendar = new GregorianCalendar(year, month, day);
        Calendar clone = (Calendar)calendar.clone();
        total = this.statistic(type, this.getTimeRange(25, clone), restrictions);
        int i = 0;
        while (i < 12) {
            calendar.set(2, i);
            Date begin = calendar.getTime();
            calendar.set(2, i + 1);
            Date end = calendar.getTime();
            count = this.statistic(type, CmsStatistic.TimeRange.getInstance(begin, end), restrictions);
            CmsStatistic bean = new CmsStatistic(String.valueOf(i + 1), count, total);
            list.add(bean);
            ++i;
        }
        return list;
    }

    private long statistic(int type, CmsStatistic.TimeRange timeRange, Map<String, Object> restrictions) {
        switch (type) {
            case 1: {
                return this.dao.memberStatistic(timeRange);
            }
            case 2: {
                return this.dao.contentStatistic(timeRange, restrictions);
            }
            case 3: {
                return this.dao.commentStatistic(timeRange, restrictions);
            }
            case 4: {
                return this.dao.guestbookStatistic(timeRange, restrictions);
            }
        }
        return 0L;
    }

    private List<CmsStatistic> pvStatistic(Integer siteId) {
        ArrayList<CmsStatistic> list = new ArrayList<CmsStatistic>();
        Calendar calendar = new GregorianCalendar();
        calendar = this.clearTime(calendar);
        Date begin = calendar.getTime();
        long count = this.dao.getPvCountByTimeRange(siteId, this.getTimeRange(21));
        CmsStatistic today = new CmsStatistic("statistic.pv.today", count);
        today.setVice(DateFormatUtils.formatDate((Date)begin));
        list.add(today);
        calendar.add(5, -2);
        begin = calendar.getTime();
        count = this.dao.getPvCountByTimeRange(siteId, this.getTimeRange(22));
        CmsStatistic yesterday = new CmsStatistic("statistic.pv.yesterday", count);
        yesterday.setVice(DateFormatUtils.formatDate((Date)begin));
        list.add(yesterday);
        count = this.avg(this.dao.getPvCountByGroup(siteId));
        CmsStatistic avg = new CmsStatistic("statistic.pv.avg", count);
        list.add(avg);
        Object[] objs = this.max(this.dao.getPvCountByGroup(siteId));
        count = ((Integer)objs[0]).intValue();
        CmsStatistic max = new CmsStatistic("statistic.pv.max", count);
        max.setVice((String)objs[1]);
        list.add(max);
        count = this.dao.getPvCount(siteId);
        CmsStatistic total = new CmsStatistic("statistic.pv.total", count);
        list.add(total);
        return list;
    }

    private List<CmsStatistic> uniqueIpStatistic(Integer siteId) {
        ArrayList<CmsStatistic> list = new ArrayList<CmsStatistic>();
        Calendar calendar = new GregorianCalendar();
        calendar = this.clearTime(calendar);
        Date begin = calendar.getTime();
        long count = this.dao.getUniqueIpCountByTimeRange(siteId, this.getTimeRange(21));
        CmsStatistic today = new CmsStatistic("statistic.uniqueIp.today", count);
        today.setVice(DateFormatUtils.formatDate((Date)begin));
        list.add(today);
        calendar.add(5, -2);
        begin = calendar.getTime();
        count = this.dao.getUniqueIpCountByTimeRange(siteId, this.getTimeRange(22));
        CmsStatistic yesterday = new CmsStatistic("statistic.uniqueIp.yesterday", count);
        yesterday.setVice(DateFormatUtils.formatDate((Date)begin));
        list.add(yesterday);
        count = this.avg(this.dao.getUniqueIpCountByGroup(siteId));
        CmsStatistic avg = new CmsStatistic("statistic.uniqueIp.avg", count);
        list.add(avg);
        Object[] objs = this.max(this.dao.getUniqueIpCountByGroup(siteId));
        count = ((Integer)objs[0]).intValue();
        CmsStatistic max = new CmsStatistic("statistic.uniqueIp.max", count);
        max.setVice((String)objs[1]);
        list.add(max);
        count = this.dao.getUniqueIpCount(siteId);
        CmsStatistic total = new CmsStatistic("statistic.uniqueIp.total", count);
        list.add(total);
        return list;
    }

    private List<CmsStatistic> uniqueVisitorStatistic(Integer siteId) {
        ArrayList<CmsStatistic> list = new ArrayList<CmsStatistic>();
        Calendar calendar = new GregorianCalendar();
        calendar = this.clearTime(calendar);
        Date begin = calendar.getTime();
        long count = this.dao.getUniqueVisitorCountByTimeRange(siteId, this.getTimeRange(21));
        CmsStatistic today = new CmsStatistic("statistic.uniqueVisitor.today", count);
        today.setVice(DateFormatUtils.formatDate((Date)begin));
        list.add(today);
        calendar.add(5, -2);
        begin = calendar.getTime();
        count = this.dao.getUniqueVisitorCountByTimeRange(siteId, this.getTimeRange(22));
        CmsStatistic yesterday = new CmsStatistic("statistic.uniqueVisitor.yesterday", count);
        yesterday.setVice(DateFormatUtils.formatDate((Date)begin));
        list.add(yesterday);
        count = this.avg(this.dao.getUniqueVisitorCountByGroup(siteId));
        CmsStatistic avg = new CmsStatistic("statistic.uniqueVisitor.avg", count);
        list.add(avg);
        Object[] objs = this.max(this.dao.getUniqueVisitorCountByGroup(siteId));
        count = ((Integer)objs[0]).intValue();
        CmsStatistic max = new CmsStatistic("statistic.uniqueVisitor.max", count);
        max.setVice((String)objs[1]);
        list.add(max);
        count = this.dao.getUniqueVisitorCount(siteId);
        CmsStatistic total = new CmsStatistic("statistic.uniqueVisitor.total", count);
        list.add(total);
        return list;
    }

    private List<CmsStatistic> avgViewsStatistic(Integer siteId) {
        ArrayList<CmsStatistic> list = new ArrayList<CmsStatistic>();
        Calendar calendar = new GregorianCalendar();
        calendar = this.clearTime(calendar);
        Date begin = calendar.getTime();
        long pvs = this.dao.getPvCountByTimeRange(siteId, this.getTimeRange(21));
        long visitors = this.dao.getUniqueVisitorCountByTimeRange(siteId, this.getTimeRange(21));
        CmsStatistic today = new CmsStatistic("statistic.avgViews.today", pvs / ArithmeticUtils.dividend((long)visitors));
        today.setVice(DateFormatUtils.formatDate((Date)begin));
        list.add(today);
        calendar.add(5, -2);
        begin = calendar.getTime();
        pvs = this.dao.getPvCountByTimeRange(siteId, this.getTimeRange(22));
        visitors = this.dao.getUniqueVisitorCountByTimeRange(siteId, this.getTimeRange(22));
        CmsStatistic yesterday = new CmsStatistic("statistic.avgViews.yesterday", pvs / ArithmeticUtils.dividend((long)visitors));
        yesterday.setVice(DateFormatUtils.formatDate((Date)begin));
        list.add(yesterday);
        long count = this.avg(this.dao.getPvCountByGroup(siteId), this.dao.getUniqueVisitorCountByGroup(siteId));
        CmsStatistic avg = new CmsStatistic("statistic.avgViews.avg", count);
        list.add(avg);
        Object[] objs = this.max(this.dao.getPvCountByGroup(siteId), this.dao.getUniqueVisitorCountByGroup(siteId));
        count = ((Integer)objs[0]).intValue();
        CmsStatistic max = new CmsStatistic("statistic.avgViews.max", count);
        max.setVice((String)objs[1]);
        list.add(max);
        pvs = this.dao.getPvCount(siteId);
        visitors = this.dao.getUniqueVisitorCount(siteId);
        CmsStatistic total = new CmsStatistic("statistic.avgViews.total", pvs / ArithmeticUtils.dividend((long)visitors));
        list.add(total);
        return list;
    }

    @Override
    public List<CmsStatistic> flowStatistic(int type, Integer siteId) {
        ArrayList<CmsStatistic> list = new ArrayList<CmsStatistic>();
        switch (type) {
            case 11: {
                return this.pvStatistic(siteId);
            }
            case 12: {
                return this.uniqueIpStatistic(siteId);
            }
            case 13: {
                return this.uniqueVisitorStatistic(siteId);
            }
            case 14: {
                return this.avgViewsStatistic(siteId);
            }
        }
        return list;
    }

    @Override
    public Pagination flowAnalysisPage(String groupCondition, Integer siteId, Integer pageNo, Integer pageSize) {
        ArrayList<CmsStatistic> list = new ArrayList<CmsStatistic>();
        Pagination pagination = this.dao.flowAnalysisPage(groupCondition, siteId, pageNo, pageSize);
        long total = this.dao.flowAnalysisTotal(siteId);
        for (Object[] objArr : pagination.getList()) {
            CmsStatistic cmsStatistic = new CmsStatistic((String)objArr[1], (Long)objArr[0], total);
            list.add(cmsStatistic);
        }
        pagination.setList(list);
        return pagination;
    }

    @Override
    public Map<String, List<CmsStatistic>> getWelcomeSiteFlowData(Integer siteId) {
        HashMap<String, List<CmsStatistic>> map = new HashMap<String, List<CmsStatistic>>();
        map.put("today", this.getListByTimeRange(siteId, this.getTimeRange(21)));
        map.put("yesterday", this.getListByTimeRange(siteId, this.getTimeRange(22)));
        map.put("thisweek", this.getListByTimeRange(siteId, this.getTimeRange(23)));
        map.put("thismonth", this.getListByTimeRange(siteId, this.getTimeRange(24)));
        map.put("total", this.getListByTimeRange(siteId, this.getTimeRange(-1)));
        return map;
    }

    @Override
    @Transactional
    public void flowInit(Integer siteId, Date startDate, Date endDate) {
        this.dao.flowInit(siteId, startDate, endDate);
    }

    private List<CmsStatistic> getListByTimeRange(Integer siteId, CmsStatistic.TimeRange timeRange) {
        ArrayList<CmsStatistic> list = new ArrayList<CmsStatistic>();
        list.add(new CmsStatistic(this.getPvCountByTimeRange(siteId, timeRange)));
        list.add(new CmsStatistic(this.getUniqueIpCountByTimeRange(siteId, timeRange)));
        list.add(new CmsStatistic(this.getUniqueVisitorCountByTimeRange(siteId, timeRange)));
        return list;
    }

    private long getPvCountByTimeRange(Integer siteId, CmsStatistic.TimeRange timeRange) {
        return this.dao.getPvCountByTimeRange(siteId, timeRange);
    }

    private long getUniqueIpCountByTimeRange(Integer siteId, CmsStatistic.TimeRange timeRange) {
        return this.dao.getUniqueIpCountByTimeRange(siteId, timeRange);
    }

    private long getUniqueVisitorCountByTimeRange(Integer siteId, CmsStatistic.TimeRange timeRange) {
        return this.dao.getUniqueVisitorCountByTimeRange(siteId, timeRange);
    }

    private String format(int time) {
        Calendar calendar = this.clearTime(new GregorianCalendar());
        calendar.set(11, time);
        String begin = DateFormatUtils.format((Date)calendar.getTime(), (String)"HH:mm:ss");
        calendar.add(11, 1);
        String end = DateFormatUtils.format((Date)calendar.getTime(), (String)"HH:mm:ss");
        return String.valueOf(begin) + "-" + end;
    }

    private int getYear(Calendar calendar) {
        return calendar.get(1);
    }

    private int getMonth(Calendar calendar) {
        return calendar.get(2);
    }

    private int getDay(Calendar calendar) {
        return calendar.get(5);
    }

    private Calendar clearTime(Calendar calendar) {
        return new GregorianCalendar(this.getYear(calendar), this.getMonth(calendar), this.getDay(calendar));
    }

    private void flush(Calendar calendar) {
        calendar.getTime();
    }

    private int avg(List<Object[]> list) {
        int count = 0;
        for (Object[] obj : list) {
            count = (int)((long)count + (Long)obj[0]);
        }
        return count / ArithmeticUtils.dividend((int)list.size());
    }

    private int avg(List<Object[]> pvList, List<Object[]> visitorsList) {
        int count = 0;
        if (pvList.size() != visitorsList.size()) {
            return count;
        }
        int i = 0;
        while (i < pvList.size()) {
            long pvCount = (Long)pvList.get(i)[0];
            long visitorCount = (Long)visitorsList.get(i)[0];
            count = (int)((long)count + pvCount / visitorCount);
            ++i;
        }
        return count / ArithmeticUtils.dividend((int)pvList.size());
    }

    private Object[] max(List<Object[]> list) {
        int max = 0;
        String date = null;
        for (Object[] objs : list) {
            long curr = (Long)objs[0];
            if ((long)max >= curr) continue;
            max = (int)curr;
            date = (String)objs[1];
        }
        return new Object[]{max, date};
    }

    private Object[] max(List<Object[]> pvList, List<Object[]> visitorsList) {
        int max = 0;
        String date = null;
        if (pvList.size() != visitorsList.size()) {
            return new Object[]{max, date};
        }
        int i = 0;
        while (i < pvList.size()) {
            long visitorCount;
            long pvCount = (Long)pvList.get(i)[0];
            long curr = pvCount / (visitorCount = ((Long)visitorsList.get(i)[0]).longValue());
            if ((long)max < curr) {
                max = (int)curr;
                date = (String)pvList.get(i)[1];
            }
            ++i;
        }
        return new Object[]{max, date};
    }

    private CmsStatistic.TimeRange getTimeRange(int type) {
        return this.getTimeRange(type, new GregorianCalendar());
    }

    private CmsStatistic.TimeRange getTimeRange(int type, Calendar calendar) {
        calendar = this.clearTime(calendar);
        switch (type) {
            case 21: {
                Date begin = calendar.getTime();
                calendar.add(5, 1);
                Date end = calendar.getTime();
                return CmsStatistic.TimeRange.getInstance(begin, end);
            }
            case 22: {
                calendar.add(5, -1);
                Date begin = calendar.getTime();
                calendar.add(5, 1);
                Date end = calendar.getTime();
                return CmsStatistic.TimeRange.getInstance(begin, end);
            }
            case 23: {
                this.flush(calendar);
                calendar.set(7, 1);
                Date begin = calendar.getTime();
                calendar.add(7, 7);
                Date end = calendar.getTime();
                return CmsStatistic.TimeRange.getInstance(begin, end);
            }
            case 24: {
                int month = calendar.get(2);
                calendar.set(5, 1);
                Date begin = calendar.getTime();
                calendar.set(2, month + 1);
                Date end = calendar.getTime();
                return CmsStatistic.TimeRange.getInstance(begin, end);
            }
            case 25: {
                int year = calendar.get(1);
                calendar.set(2, 0);
                calendar.set(5, 1);
                Date begin = calendar.getTime();
                calendar.set(1, year + 1);
                Date end = calendar.getTime();
                return CmsStatistic.TimeRange.getInstance(begin, end);
            }
        }
        return null;
    }
}

