/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.web;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.manager.main.CmsSiteMng;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.web.CmsThreadVariable;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.common.web.CookieUtils;
import com.jeecms.common.web.session.SessionProvider;
import com.jeecms.common.web.springmvc.MessageResolver;
import com.jeecms.core.manager.AuthenticationMng;
import java.util.List;
import java.util.Set;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;
import org.springframework.web.util.UrlPathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminContextInterceptor
extends HandlerInterceptorAdapter {
    private static final Logger log = Logger.getLogger(AdminContextInterceptor.class);
    public static final String SITE_PARAM = "_site_id_param";
    public static final String SITE_COOKIE = "_site_id_cookie";
    public static final String PERMISSION_MODEL = "_permission_key";
    private SessionProvider session;
    private AuthenticationMng authMng;
    private CmsSiteMng cmsSiteMng;
    private CmsUserMng cmsUserMng;
    private Integer adminId;
    private boolean auth = true;
    private String[] excludeUrls;
    private String loginUrl;
    private String processUrl;
    private String returnUrl;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        CmsSite site = this.getSite(request, response);
        CmsUtils.setSite(request, site);
        CmsThreadVariable.setSite(site);
        CmsUser user = null;
        if (this.adminId != null) {
            user = this.cmsUserMng.findById(this.adminId);
            if (user == null) {
                throw new IllegalStateException("User ID=" + this.adminId + " not found!");
            }
        } else {
            Integer userId = this.authMng.retrieveUserIdFromSession(this.session, request);
            if (userId != null) {
                user = this.cmsUserMng.findById(userId);
            }
        }
        CmsUtils.setUser(request, user);
        CmsThreadVariable.setUser(user);
        String uri = AdminContextInterceptor.getURI(request);
        if (this.exclude(uri)) {
            return true;
        }
        if (user == null) {
            response.sendRedirect(this.getLoginUrl(request));
            return false;
        }
        if (!user.getAdmin().booleanValue()) {
            request.setAttribute("message", (Object)MessageResolver.getMessage((HttpServletRequest)request, (String)"login.notAdmin", (Object[])new Object[0]));
            response.sendError(403);
            return false;
        }
        if (!user.getSites().contains(site)) {
            request.setAttribute("message", (Object)MessageResolver.getMessage((HttpServletRequest)request, (String)"login.notInSite", (Object[])new Object[0]));
            response.sendError(403);
            return false;
        }
        boolean viewonly = user.getViewonlyAdmin();
        if (this.auth && !user.isSuper() && !this.permistionPass(uri, user.getPerms(), viewonly)) {
            request.setAttribute("message", (Object)MessageResolver.getMessage((HttpServletRequest)request, (String)"login.notPermission", (Object[])new Object[0]));
            response.sendError(403);
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView mav) throws Exception {
        CmsUser user = CmsUtils.getUser(request);
        if (this.auth && user != null && !user.isSuper() && mav != null && mav.getModelMap() != null && mav.getViewName() != null && !mav.getViewName().startsWith("redirect:")) {
            mav.getModelMap().addAttribute(PERMISSION_MODEL, user.getPerms());
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        CmsThreadVariable.removeUser();
        CmsThreadVariable.removeSite();
    }

    private String getLoginUrl(HttpServletRequest request) {
        String ctx;
        StringBuilder buff = new StringBuilder();
        if (this.loginUrl.startsWith("/") && !StringUtils.isBlank((String)(ctx = request.getContextPath()))) {
            buff.append(ctx);
        }
        buff.append(this.loginUrl).append("?");
        buff.append("returnUrl").append("=").append(this.returnUrl);
        if (!StringUtils.isBlank((String)this.processUrl)) {
            buff.append("&").append("processUrl").append("=").append(this.getProcessUrl(request));
        }
        return buff.toString();
    }

    private String getProcessUrl(HttpServletRequest request) {
        String ctx;
        StringBuilder buff = new StringBuilder();
        if (this.loginUrl.startsWith("/") && !StringUtils.isBlank((String)(ctx = request.getContextPath()))) {
            buff.append(ctx);
        }
        buff.append(this.processUrl);
        return buff.toString();
    }

    private CmsSite getSite(HttpServletRequest request, HttpServletResponse response) {
        CmsSite site = this.getByParams(request, response);
        if (site == null) {
            site = this.getByCookie(request);
        }
        if (site == null) {
            site = this.getByDomain(request);
        }
        if (site == null) {
            site = this.getByDefault();
        }
        if (site == null) {
            throw new RuntimeException("cannot get site!");
        }
        return site;
    }

    private CmsSite getByParams(HttpServletRequest request, HttpServletResponse response) {
        String p = request.getParameter(SITE_PARAM);
        if (!StringUtils.isBlank((String)p)) {
            try {
                Integer siteId = Integer.parseInt(p);
                CmsSite site = this.cmsSiteMng.findById(siteId);
                if (site != null) {
                    CookieUtils.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)SITE_COOKIE, (String)site.getId().toString(), null, null);
                    return site;
                }
            }
            catch (NumberFormatException e) {
                log.warn((Object)"param site id format exception", (Throwable)e);
            }
        }
        return null;
    }

    private CmsSite getByCookie(HttpServletRequest request) {
        String v;
        Cookie cookie = CookieUtils.getCookie((HttpServletRequest)request, (String)SITE_COOKIE);
        if (cookie != null && !StringUtils.isBlank((String)(v = cookie.getValue()))) {
            try {
                Integer siteId = Integer.parseInt(v);
                return this.cmsSiteMng.findById(siteId);
            }
            catch (NumberFormatException e) {
                log.warn((Object)"cookie site id format exception", (Throwable)e);
            }
        }
        return null;
    }

    private CmsSite getByDomain(HttpServletRequest request) {
        String domain = request.getServerName();
        if (!StringUtils.isBlank((String)domain)) {
            return this.cmsSiteMng.findByDomain(domain, true);
        }
        return null;
    }

    private CmsSite getByDefault() {
        List<CmsSite> list = this.cmsSiteMng.getListFromCache();
        if (list.size() > 0) {
            return list.get(0);
        }
        return null;
    }

    private boolean exclude(String uri) {
        if (this.excludeUrls != null) {
            String[] stringArray = this.excludeUrls;
            int n = this.excludeUrls.length;
            int n2 = 0;
            while (n2 < n) {
                String exc = stringArray[n2];
                if (exc.equals(uri)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private boolean permistionPass(String uri, Set<String> perms, boolean viewOnly) {
        String u = null;
        for (String perm : perms) {
            if (!uri.startsWith(perm)) continue;
            if (viewOnly) {
                int i = uri.lastIndexOf("/");
                if (i == -1) {
                    throw new RuntimeException("uri must start width '/':" + uri);
                }
                u = uri.substring(i + 1);
                if (u.startsWith("o_")) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static String getURI(HttpServletRequest request) throws IllegalStateException {
        UrlPathHelper helper = new UrlPathHelper();
        String uri = helper.getOriginatingRequestUri(request);
        String ctxPath = helper.getOriginatingContextPath(request);
        int start = 0;
        int i = 0;
        int count = 2;
        if (!StringUtils.isBlank((String)ctxPath)) {
            ++count;
        }
        while (i < count && start != -1) {
            start = uri.indexOf(47, start + 1);
            ++i;
        }
        if (start <= 0) {
            throw new IllegalStateException("admin access path not like '/jeeadmin/jspgou/...' pattern: " + uri);
        }
        return uri.substring(start);
    }

    @Autowired
    public void setSession(SessionProvider session) {
        this.session = session;
    }

    @Autowired
    public void setCmsSiteMng(CmsSiteMng cmsSiteMng) {
        this.cmsSiteMng = cmsSiteMng;
    }

    @Autowired
    public void setCmsUserMng(CmsUserMng cmsUserMng) {
        this.cmsUserMng = cmsUserMng;
    }

    @Autowired
    public void setAuthMng(AuthenticationMng authMng) {
        this.authMng = authMng;
    }

    public void setAuth(boolean auth) {
        this.auth = auth;
    }

    public void setExcludeUrls(String[] excludeUrls) {
        this.excludeUrls = excludeUrls;
    }

    public void setAdminId(Integer adminId) {
        this.adminId = adminId;
    }

    public void setLoginUrl(String loginUrl) {
        this.loginUrl = loginUrl;
    }

    public void setProcessUrl(String processUrl) {
        this.processUrl = processUrl;
    }

    public void setReturnUrl(String returnUrl) {
        this.returnUrl = returnUrl;
    }
}

