/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.web;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.manager.main.CmsSiteMng;
import com.jeecms.cms.manager.main.CmsUserMng;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.SiteNotFoundException;
import com.jeecms.common.web.session.SessionProvider;
import com.jeecms.core.manager.AuthenticationMng;
import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class FrontContextInterceptor
extends HandlerInterceptorAdapter {
    private SessionProvider session;
    private CmsSiteMng cmsSiteMng;
    private CmsUserMng cmsUserMng;
    private AuthenticationMng authMng;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws ServletException {
        CmsSite site = null;
        List<CmsSite> list = this.cmsSiteMng.getListFromCache();
        int size = list.size();
        if (size == 0) {
            throw new RuntimeException("no site record in database!");
        }
        if (size == 1) {
            site = list.get(0);
        } else {
            String server = request.getServerName();
            for (CmsSite s : list) {
                String redirect;
                int n;
                int n2;
                String[] stringArray;
                if (s.getDomain().equals(server)) {
                    site = s;
                    break;
                }
                String alias = s.getDomainAlias();
                if (!StringUtils.isBlank((String)alias)) {
                    stringArray = StringUtils.split((String)alias, (char)',');
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        String a = stringArray[n];
                        if (a.equals(server)) {
                            site = s;
                            break;
                        }
                        ++n;
                    }
                }
                if (StringUtils.isBlank((String)(redirect = s.getDomainRedirect()))) continue;
                stringArray = StringUtils.split((String)redirect, (char)',');
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    String r = stringArray[n];
                    if (r.equals(server)) {
                        try {
                            response.sendRedirect(s.getUrl());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        return false;
                    }
                    ++n;
                }
            }
            if (site == null) {
                throw new SiteNotFoundException(server);
            }
        }
        CmsUtils.setSite(request, site);
        CmsUser user = null;
        Integer userId = this.authMng.retrieveUserIdFromSession(this.session, request);
        if (userId != null) {
            user = this.cmsUserMng.findById(userId);
        }
        if (user != null) {
            CmsUtils.setUser(request, user);
        }
        return true;
    }

    @Autowired
    public void setSession(SessionProvider session) {
        this.session = session;
    }

    @Autowired
    public void setCmsSiteMng(CmsSiteMng cmsSiteMng) {
        this.cmsSiteMng = cmsSiteMng;
    }

    @Autowired
    public void setCmsUserMng(CmsUserMng cmsUserMng) {
        this.cmsUserMng = cmsUserMng;
    }

    @Autowired
    public void setAuthMng(AuthenticationMng authMng) {
        this.authMng = authMng;
    }
}

