/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.web;

import com.jeecms.cms.entity.main.CmsSite;
import com.jeecms.cms.entity.main.CmsUser;
import com.jeecms.cms.web.CmsUtils;
import com.jeecms.cms.web.WebErrors;
import com.jeecms.common.web.RequestUtils;
import com.jeecms.common.web.freemarker.DirectiveUtils;
import com.jeecms.common.web.springmvc.MessageResolver;
import com.jeecms.core.web.front.URLHelper;
import freemarker.core.Environment;
import freemarker.template.AdapterTemplateModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateNumberModel;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.propertyeditors.LocaleEditor;
import org.springframework.context.MessageSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrontUtils {
    public static final String PAGE_NOT_FOUND = "tpl.pageNotFound";
    public static final String SUCCESS_PAGE = "tpl.successPage";
    public static final String ERROR_PAGE = "tpl.errorPage";
    public static final String MESSAGE_PAGE = "tpl.messagePage";
    public static final String RES_SYS = "resSys";
    public static final String RES_TPL = "res";
    public static final String RES_EXP = "${res}";
    public static final String BASE = "base";
    public static final String SITE = "site";
    public static final String USER = "user";
    public static final String PAGE_NO = "pageNo";
    public static final String COUNT = "count";
    public static final String FIRST = "first";
    public static final String LOCATION = "location";
    public static final String HREF = "href";
    public static final String HREF_FORMER = "hrefFormer";
    public static final String HREF_LATTER = "hrefLatter";
    public static final String PARAM_STYLE_LIST = "styleList";
    public static final String PARAM_SYS_PAGE = "sysPage";
    public static final String PARAM_USER_PAGE = "userPage";
    public static final String RETURN_URL = "returnUrl";
    public static final String ARGS = "args";

    public static String getTplPath(HttpServletRequest request, String solution, String dir, String name) {
        return String.valueOf(solution) + "/" + dir + "/" + MessageResolver.getMessage((HttpServletRequest)request, (String)name, (Object[])new Object[0]) + ".html";
    }

    public static String getTplPath(MessageSource messageSource, String lang, String solution, String dir, String name) {
        LocaleEditor localeEditor = new LocaleEditor();
        localeEditor.setAsText(lang);
        Locale locale = (Locale)localeEditor.getValue();
        return String.valueOf(solution) + "/" + dir + "/" + messageSource.getMessage(name, null, locale) + ".html";
    }

    public static String getTplPath(String solution, String dir, String name) {
        return String.valueOf(solution) + "/" + dir + "/" + name + ".html";
    }

    public static String pageNotFound(HttpServletRequest request, HttpServletResponse response, Map<String, Object> model) {
        response.setStatus(404);
        CmsSite site = CmsUtils.getSite(request);
        FrontUtils.frontData(request, model, site);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "common", PAGE_NOT_FOUND);
    }

    public static String showSuccess(HttpServletRequest request, Map<String, Object> model, String nextUrl) {
        CmsSite site = CmsUtils.getSite(request);
        FrontUtils.frontData(request, model, site);
        if (!StringUtils.isBlank((String)nextUrl)) {
            model.put("nextUrl", nextUrl);
        }
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "common", SUCCESS_PAGE);
    }

    public static String showError(HttpServletRequest request, HttpServletResponse response, Map<String, Object> model, WebErrors errors) {
        CmsSite site = CmsUtils.getSite(request);
        FrontUtils.frontData(request, model, site);
        errors.toModel(model);
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "common", ERROR_PAGE);
    }

    public static String showMessage(HttpServletRequest request, Map<String, Object> model, String message, String ... args) {
        CmsSite site = CmsUtils.getSite(request);
        FrontUtils.frontData(request, model, site);
        model.put("message", message);
        if (args != null) {
            model.put(ARGS, args);
        }
        return FrontUtils.getTplPath(request, site.getSolutionPath(), "common", MESSAGE_PAGE);
    }

    public static String showLogin(HttpServletRequest request, Map<String, Object> model, CmsSite site, String message) {
        if (!StringUtils.isBlank((String)message)) {
            model.put("message", message);
        }
        StringBuilder buff = new StringBuilder("redirect:");
        buff.append(site.getLoginUrl()).append("?");
        buff.append(RETURN_URL).append("=");
        buff.append(RequestUtils.getLocation((HttpServletRequest)request));
        if (!StringUtils.isBlank((String)site.getProcessUrl())) {
            buff.append("&").append("processUrl").append(site.getProcessUrl());
        }
        return buff.toString();
    }

    public static String showLogin(HttpServletRequest request, Map<String, Object> model, CmsSite site) {
        return FrontUtils.showLogin(request, model, site, "true");
    }

    public static void frontData(HttpServletRequest request, Map<String, Object> map, CmsSite site) {
        CmsUser user = CmsUtils.getUser(request);
        String location = RequestUtils.getLocation((HttpServletRequest)request);
        Long startTime = (Long)request.getAttribute("_start_time");
        FrontUtils.frontData(map, site, user, location, startTime);
    }

    public static void frontData(Map<String, Object> map, CmsSite site, CmsUser user, String location, Long startTime) {
        if (startTime != null) {
            map.put("_start_time", startTime);
        }
        if (user != null) {
            map.put(USER, user);
        }
        map.put(SITE, site);
        String ctx = site.getContextPath() == null ? "" : site.getContextPath();
        map.put(BASE, ctx);
        map.put(RES_SYS, String.valueOf(ctx) + "/r/cms");
        String res = String.valueOf(ctx) + "/r/cms" + "/" + site.getPath() + "/" + site.getTplSolution();
        map.put(RES_TPL, res.substring(1));
        map.put(LOCATION, location);
    }

    public static void putLocation(Map<String, Object> map, String location) {
        map.put(LOCATION, location);
    }

    public static void frontPageData(HttpServletRequest request, Map<String, Object> map) {
        int pageNo = URLHelper.getPageNo((HttpServletRequest)request);
        URLHelper.PageInfo info = URLHelper.getPageInfo((HttpServletRequest)request);
        String href = info.getHref();
        String hrefFormer = info.getHrefFormer();
        String hrefLatter = info.getHrefLatter();
        FrontUtils.frontPageData(pageNo, href, hrefFormer, hrefLatter, map);
    }

    public static void frontPageData(int pageNo, String href, String hrefFormer, String hrefLatter, Map<String, Object> map) {
        map.put(PAGE_NO, pageNo);
        map.put(HREF, href);
        map.put(HREF_FORMER, hrefFormer);
        map.put(HREF_LATTER, hrefLatter);
    }

    public static CmsSite getSite(Environment env) throws TemplateModelException {
        TemplateModel model = env.getGlobalVariable(SITE);
        if (model instanceof AdapterTemplateModel) {
            return (CmsSite)((AdapterTemplateModel)model).getAdaptedObject(CmsSite.class);
        }
        throw new TemplateModelException("'site' not found in DataModel");
    }

    public static int getPageNo(Environment env) throws TemplateException {
        TemplateModel pageNo = env.getGlobalVariable(PAGE_NO);
        if (pageNo instanceof TemplateNumberModel) {
            return ((TemplateNumberModel)pageNo).getAsNumber().intValue();
        }
        throw new TemplateModelException("'pageNo' not found in DataModel.");
    }

    public static int getFirst(Map<String, TemplateModel> params) throws TemplateException {
        Integer first = DirectiveUtils.getInt((String)FIRST, params);
        if (first == null || first <= 0) {
            return 0;
        }
        return first - 1;
    }

    public static int getCount(Map<String, TemplateModel> params) throws TemplateException {
        Integer count = DirectiveUtils.getInt((String)COUNT, params);
        if (count == null || count <= 0 || count >= 5000) {
            return 5000;
        }
        return count;
    }

    public static void includePagination(CmsSite site, Map<String, TemplateModel> params, Environment env) throws TemplateException, IOException {
        String sysPage = DirectiveUtils.getString((String)PARAM_SYS_PAGE, params);
        String userPage = DirectiveUtils.getString((String)PARAM_USER_PAGE, params);
        if (!StringUtils.isBlank((String)sysPage)) {
            String tpl = "/WEB-INF/t/cms_sys_defined/style_page/channel_" + sysPage + ".html";
            env.include(tpl, "UTF-8", true);
        } else if (!StringUtils.isBlank((String)userPage)) {
            String tpl = FrontUtils.getTplPath(site.getSolutionPath(), "style_list", userPage);
            env.include(tpl, "UTF-8", true);
        }
    }

    public static void includeTpl(String tplName, CmsSite site, Map<String, TemplateModel> params, Environment env) throws IOException, TemplateException {
        String subTpl = DirectiveUtils.getString((String)"tplSub", params);
        String tpl = StringUtils.isBlank((String)subTpl) ? FrontUtils.getTplPath(site.getSolutionPath(), "tag", tplName) : FrontUtils.getTplPath(site.getSolutionPath(), "tag", String.valueOf(tplName) + "_" + subTpl);
        env.include(tpl, "UTF-8", true);
    }

    public static void includeTpl(String listStyle, CmsSite site, Environment env) throws IOException, TemplateException {
        String tpl = FrontUtils.getTplPath(site.getSolutionPath(), "style_list", listStyle);
        env.include(tpl, "UTF-8", true);
    }
}

