/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.cms.web;

import com.jeecms.common.web.freemarker.DirectiveUtils;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import freemarker.template.TemplateScalarModel;
import freemarker.template.TemplateSequenceModel;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class PermistionDirective
implements TemplateDirectiveModel {
    public static final String PARAM_URL = "url";

    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        String url = DirectiveUtils.getString((String)PARAM_URL, (Map)params);
        boolean pass = false;
        if (StringUtils.isBlank((String)url)) {
            pass = true;
        } else {
            TemplateSequenceModel perms = this.getPerms(env);
            if (perms == null) {
                pass = true;
            } else {
                int i = 0;
                int len = perms.size();
                while (i < len) {
                    String perm = ((TemplateScalarModel)perms.get(i)).getAsString();
                    if (url.startsWith(perm)) {
                        pass = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        if (pass) {
            body.render(env.getOut());
        }
    }

    private TemplateSequenceModel getPerms(Environment env) throws TemplateModelException {
        TemplateModel model = env.getDataModel().get("_permission_key");
        if (model == null) {
            return null;
        }
        if (model instanceof TemplateSequenceModel) {
            return (TemplateSequenceModel)model;
        }
        throw new TemplateModelException("'perms' in data model not a TemplateSequenceModel");
    }
}

