/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.core.action.front;

import com.jeecms.core.entity.DbFile;
import com.jeecms.core.manager.DbFileMng;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DbFileServlet
extends HttpServlet {
    public static final String PARAM_NAME = "n";
    private DbFileMng dbFileMng;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String filename;
        int index;
        String name = request.getParameter(PARAM_NAME);
        if (StringUtils.isBlank((String)name)) {
            response.sendError(404);
            return;
        }
        DbFile file = this.dbFileMng.findById(name);
        if (file == null) {
            response.sendError(404);
            return;
        }
        String mimeType = this.getServletContext().getMimeType(name);
        if (mimeType != null) {
            response.setContentType(mimeType);
        }
        if ((index = (filename = file.getId()).lastIndexOf("/")) != -1) {
            filename = filename.substring(index + 1);
        }
        response.addHeader("Content-disposition", "filename=" + filename);
        response.setContentLength(file.getLength().intValue());
        ServletOutputStream out = response.getOutputStream();
        out.write(file.getContent());
        out.flush();
        out.close();
    }

    public void init() throws ServletException {
        WebApplicationContext appCtx = WebApplicationContextUtils.getWebApplicationContext((ServletContext)this.getServletContext());
        this.dbFileMng = (DbFileMng)BeanFactoryUtils.beanOfTypeIncludingAncestors((ListableBeanFactory)appCtx, DbFileMng.class);
    }
}

