/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.core.action.front;

import com.jeecms.common.security.BadCredentialsException;
import com.jeecms.common.security.UsernameNotFoundException;
import com.jeecms.common.web.RequestUtils;
import com.jeecms.common.web.session.SessionProvider;
import com.jeecms.core.entity.Authentication;
import com.jeecms.core.manager.AuthenticationMng;
import com.jeecms.core.web.WebErrors;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
public class LoginAct {
    public static final String PROCESS_URL = "processUrl";
    public static final String RETURN_URL = "returnUrl";
    public static final String MESSAGE = "message";
    public static final String LOGIN_INPUT = "/WEB-INF/t/jeecore/login.html";
    public static final String LOGIN_SUCCESS = "/WEB-INF/t/jeecore/login_success.html";
    @Autowired
    private AuthenticationMng authMng;
    @Autowired
    private SessionProvider session;

    @RequestMapping(value={"/login.jspx"}, method={RequestMethod.GET})
    public String input(HttpServletRequest request, ModelMap model) {
        Authentication auth;
        String processUrl = RequestUtils.getQueryParam((HttpServletRequest)request, (String)PROCESS_URL);
        String returnUrl = RequestUtils.getQueryParam((HttpServletRequest)request, (String)RETURN_URL);
        String message = RequestUtils.getQueryParam((HttpServletRequest)request, (String)MESSAGE);
        String authId = (String)((Object)this.session.getAttribute(request, "auth_key"));
        if (authId != null && (auth = this.authMng.retrieve(authId)) != null) {
            String view = this.getView(processUrl, returnUrl, auth.getId());
            if (view != null) {
                return view;
            }
            model.addAttribute("auth", (Object)auth);
            return LOGIN_SUCCESS;
        }
        if (!StringUtils.isBlank((String)processUrl)) {
            model.addAttribute(PROCESS_URL, (Object)processUrl);
        }
        if (!StringUtils.isBlank((String)returnUrl)) {
            model.addAttribute(RETURN_URL, (Object)returnUrl);
        }
        if (!StringUtils.isBlank((String)message)) {
            model.addAttribute(MESSAGE, (Object)message);
        }
        return LOGIN_INPUT;
    }

    @RequestMapping(value={"/login.jspx"}, method={RequestMethod.POST})
    public String submit(String username, String password, String processUrl, String returnUrl, String message, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        WebErrors errors = this.validateSubmit(username, password, request);
        if (!errors.hasErrors()) {
            try {
                Authentication auth = this.authMng.login(username, password, RequestUtils.getIpAddr((HttpServletRequest)request), request, response, this.session);
                String view = this.getView(processUrl, returnUrl, auth.getId());
                if (view != null) {
                    return view;
                }
                model.addAttribute("auth", (Object)auth);
                return LOGIN_SUCCESS;
            }
            catch (UsernameNotFoundException e) {
                errors.addErrorString(e.getMessage());
            }
            catch (BadCredentialsException e) {
                errors.addErrorString(e.getMessage());
            }
        }
        errors.toModel((Map)model);
        if (!StringUtils.isBlank((String)processUrl)) {
            model.addAttribute(PROCESS_URL, (Object)processUrl);
        }
        if (!StringUtils.isBlank((String)returnUrl)) {
            model.addAttribute(RETURN_URL, (Object)returnUrl);
        }
        if (!StringUtils.isBlank((String)message)) {
            model.addAttribute(MESSAGE, (Object)message);
        }
        return LOGIN_INPUT;
    }

    @RequestMapping(value={"/logout.jspx"})
    public String logout(HttpServletRequest request, HttpServletResponse response) {
        String returnUrl;
        String processUrl;
        String view;
        String authId = (String)((Object)this.session.getAttribute(request, "auth_key"));
        if (authId != null) {
            this.authMng.deleteById(authId);
            this.session.logout(request, response);
        }
        if ((view = this.getView(processUrl = RequestUtils.getQueryParam((HttpServletRequest)request, (String)PROCESS_URL), returnUrl = RequestUtils.getQueryParam((HttpServletRequest)request, (String)RETURN_URL), authId)) != null) {
            return view;
        }
        return "redirect:login.jspx";
    }

    private String getView(String processUrl, String returnUrl, String authId) {
        if (!StringUtils.isBlank((String)processUrl)) {
            StringBuilder sb = new StringBuilder("redirect:");
            sb.append(processUrl).append("?").append("auth_key").append("=").append(authId);
            if (!StringUtils.isBlank((String)returnUrl)) {
                sb.append("&").append(RETURN_URL).append("=").append(returnUrl);
            }
            return sb.toString();
        }
        if (!StringUtils.isBlank((String)returnUrl)) {
            StringBuilder sb = new StringBuilder("redirect:");
            sb.append(returnUrl);
            if (!StringUtils.isBlank((String)authId)) {
                sb.append("?").append("auth_key").append("=").append(authId);
            }
            return sb.toString();
        }
        return null;
    }

    private WebErrors validateSubmit(String username, String password, HttpServletRequest request) {
        WebErrors errors = WebErrors.create(request);
        if (errors.ifOutOfLength(username, "username", 3, 100)) {
            return errors;
        }
        if (errors.ifOutOfLength(password, "password", 3, 32)) {
            return errors;
        }
        return errors;
    }
}

