/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.core.entity;

import com.jeecms.common.email.EmailSender;
import com.jeecms.common.email.MessageTemplate;
import com.jeecms.core.entity.base.BaseConfig;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;

public class Config
extends BaseConfig {
    private static final long serialVersionUID = 1L;

    public Config() {
    }

    public Config(String id) {
        super(id);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigEmailSender
    implements EmailSender {
        public static String EMAIL_HOST = "email_host";
        public static String EMAIL_PORT = "email_port";
        public static String EMAIL_ENCODING = "email_encoding";
        public static String EMAIL_USERNAME = "email_username";
        public static String EMAIL_PASSWORD = "email_password";
        public static String EMAIL_PERSONAL = "email_personal";
        private Map<String, String> attr;

        public static ConfigEmailSender create(Map<String, String> map) {
            if (map == null || StringUtils.isBlank((String)map.get(EMAIL_HOST)) || StringUtils.isBlank((String)map.get(EMAIL_USERNAME))) {
                return null;
            }
            ConfigEmailSender sender = new ConfigEmailSender();
            sender.attr = map;
            return sender;
        }

        public Map<String, String> getAttr() {
            if (this.attr == null) {
                this.attr = new HashMap<String, String>();
            }
            return this.attr;
        }

        public String getHost() {
            return this.getAttr().get(EMAIL_HOST);
        }

        public void setHost(String host) {
            this.getAttr().put(EMAIL_HOST, host);
        }

        public Integer getPort() {
            String port = this.getAttr().get(EMAIL_HOST);
            if (StringUtils.isNotBlank((String)port) && NumberUtils.isDigits((String)port)) {
                return Integer.parseInt(port);
            }
            return null;
        }

        public void setPort(Integer port) {
            this.getAttr().put(EMAIL_PORT, port != null ? port.toString() : null);
        }

        public String getEncoding() {
            String encoding = this.getAttr().get(EMAIL_ENCODING);
            return StringUtils.isNotBlank((String)encoding) ? encoding : null;
        }

        public void setEncoding(String encoding) {
            this.getAttr().put(EMAIL_ENCODING, encoding);
        }

        public String getUsername() {
            return this.getAttr().get(EMAIL_USERNAME);
        }

        public void setUsername(String username) {
            this.getAttr().put(EMAIL_USERNAME, username);
        }

        public String getPassword() {
            String password = this.getAttr().get(EMAIL_PASSWORD);
            return StringUtils.isNotBlank((String)password) ? password : null;
        }

        public void setPassword(String password) {
            this.getAttr().put(EMAIL_PASSWORD, password);
        }

        public String getPersonal() {
            String personal = this.getAttr().get(EMAIL_PERSONAL);
            return StringUtils.isNotBlank((String)personal) ? personal : null;
        }

        public void setPersonal(String personal) {
            this.getAttr().put(EMAIL_PERSONAL, personal);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigLogin {
        public static String LOGIN_ERROR_INTERVAL = "login_error_interval";
        public static String LOGIN_ERROR_TIMES = "login_error_times";
        private Map<String, String> attr;

        public static ConfigLogin create(Map<String, String> map) {
            ConfigLogin configLogin = new ConfigLogin();
            configLogin.setAttr(map);
            return configLogin;
        }

        public Map<String, String> getAttr() {
            if (this.attr == null) {
                this.attr = new HashMap<String, String>();
            }
            return this.attr;
        }

        public void setAttr(Map<String, String> attr) {
            this.attr = attr;
        }

        public Integer getErrorInterval() {
            String interval = this.getAttr().get(LOGIN_ERROR_INTERVAL);
            if (NumberUtils.isDigits((String)interval)) {
                return Integer.parseInt(interval);
            }
            return 30;
        }

        public void setErrorInterval(Integer errorInterval) {
            if (errorInterval != null) {
                this.getAttr().put(LOGIN_ERROR_INTERVAL, errorInterval.toString());
            } else {
                this.getAttr().put(LOGIN_ERROR_INTERVAL, null);
            }
        }

        public Integer getErrorTimes() {
            String times = this.getAttr().get(LOGIN_ERROR_TIMES);
            if (NumberUtils.isDigits((String)times)) {
                return Integer.parseInt(times);
            }
            return 3;
        }

        public void setErrorTimes(Integer errorTimes) {
            if (errorTimes != null) {
                this.getAttr().put(LOGIN_ERROR_TIMES, errorTimes.toString());
            } else {
                this.getAttr().put(LOGIN_ERROR_TIMES, null);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfigMessageTemplate
    implements MessageTemplate {
        public static String MESSAGE_FORGOTPASSWORD_SUBJECT = "message_forgotpassword_subject";
        public static String MESSAGE_FORGOTPASSWORD_TEXT = "message_forgotpassword_text";
        public static String MESSAGE_REGISTER_SUBJECT = "message_register_subject";
        public static String MESSAGE_REGISTER_TEXT = "message_register_text";
        private Map<String, String> attr;

        public static ConfigMessageTemplate createForgotPasswordMessageTemplate(Map<String, String> map) {
            if (map == null || StringUtils.isBlank((String)map.get(MESSAGE_FORGOTPASSWORD_SUBJECT)) || StringUtils.isBlank((String)map.get(MESSAGE_FORGOTPASSWORD_TEXT))) {
                return null;
            }
            ConfigMessageTemplate tpl = new ConfigMessageTemplate();
            tpl.setAttr(map);
            return tpl;
        }

        public static ConfigMessageTemplate createRegisterMessageTemplate(Map<String, String> map) {
            if (map == null || StringUtils.isBlank((String)map.get(MESSAGE_REGISTER_SUBJECT)) || StringUtils.isBlank((String)map.get(MESSAGE_REGISTER_TEXT))) {
                return null;
            }
            ConfigMessageTemplate tpl = new ConfigMessageTemplate();
            tpl.setAttr(map);
            return tpl;
        }

        public Map<String, String> getAttr() {
            if (this.attr == null) {
                this.attr = new HashMap<String, String>();
            }
            return this.attr;
        }

        public void setAttr(Map<String, String> attr) {
            this.attr = attr;
        }

        public String getForgotPasswordSubject() {
            return this.getAttr().get(MESSAGE_FORGOTPASSWORD_SUBJECT);
        }

        public void setForgotPasswordSubject(String subject) {
            this.getAttr().put(MESSAGE_FORGOTPASSWORD_SUBJECT, subject);
        }

        public String getForgotPasswordText() {
            return this.getAttr().get(MESSAGE_FORGOTPASSWORD_TEXT);
        }

        public void setForgotPasswordText(String text) {
            this.getAttr().put(MESSAGE_FORGOTPASSWORD_TEXT, text);
        }

        public String getRegisterSubject() {
            return this.getAttr().get(MESSAGE_REGISTER_SUBJECT);
        }

        public void setRegisterSubject(String subject) {
            this.getAttr().put(MESSAGE_REGISTER_SUBJECT, subject);
        }

        public String getRegisterText() {
            return this.getAttr().get(MESSAGE_REGISTER_TEXT);
        }

        public void setRegisterText(String text) {
            this.getAttr().put(MESSAGE_REGISTER_TEXT, text);
        }
    }
}

