/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.core.entity;

import com.jeecms.core.entity.base.BaseDbTpl;
import com.jeecms.core.tpl.Tpl;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

public class DbTpl
extends BaseDbTpl
implements Tpl {
    private static final long serialVersionUID = 1L;

    public static String[] getParentDir(String path) {
        Assert.notNull((Object)path);
        if (!path.startsWith("/")) {
            throw new IllegalArgumentException("path must start with /");
        }
        ArrayList<String> list = new ArrayList<String>();
        int index = path.indexOf("/", 1);
        while (index >= 0) {
            list.add(path.substring(0, index));
            index = path.indexOf("/", index + 1);
        }
        String[] arr = new String[list.size()];
        return list.toArray(arr);
    }

    public String getName() {
        return this.getId();
    }

    public String getPath() {
        String name = this.getId();
        return this.getId().substring(0, name.lastIndexOf("/"));
    }

    public String getFilename() {
        int index;
        String name = this.getId();
        if (!StringUtils.isBlank((String)name) && (index = name.lastIndexOf("/")) != -1) {
            return name.substring(index + 1, name.length());
        }
        return name;
    }

    public long getLength() {
        if (this.isDirectory() || this.getSource() == null) {
            return 128L;
        }
        return (long)((double)this.getSource().length() * 1.5);
    }

    public int getSize() {
        return (int)(this.getLength() / 1024L) + 1;
    }

    public Date getLastModifiedDate() {
        return new Timestamp(this.getLastModified());
    }

    public DbTpl() {
    }

    public DbTpl(String id) {
        super(id);
    }

    public DbTpl(String id, long lastModified, boolean directory) {
        super(id, lastModified, directory);
    }
}

