/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.core.entity;

import com.jeecms.common.upload.UploadUtils;
import com.jeecms.core.entity.base.BaseFtp;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.SocketException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Ftp
extends BaseFtp {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(Ftp.class);

    public String storeByExt(String path, String ext, InputStream in) throws IOException {
        String filename = UploadUtils.generateFilename((String)path, (String)ext);
        this.store(filename, in);
        return filename;
    }

    public String storeByFilename(String filename, InputStream in) throws IOException {
        this.store(filename, in);
        return filename;
    }

    public File retrieve(String name) throws IOException {
        String path = System.getProperty("java.io.tmpdir");
        File file = new File(path, name);
        file = UploadUtils.getUniqueFile((File)file);
        FTPClient ftp = this.getClient();
        FileOutputStream output = new FileOutputStream(file);
        ftp.retrieveFile(String.valueOf(this.getPath()) + name, (OutputStream)output);
        ((OutputStream)output).close();
        ftp.logout();
        ftp.disconnect();
        return file;
    }

    public boolean restore(String name, File file) throws IOException {
        this.store(name, FileUtils.openInputStream((File)file));
        file.deleteOnExit();
        return true;
    }

    private int store(String remote, InputStream in) {
        try {
            FTPClient ftp = this.getClient();
            if (ftp != null) {
                String filename = String.valueOf(this.getPath()) + remote;
                String name = FilenameUtils.getName((String)filename);
                String path = FilenameUtils.getFullPath((String)filename);
                if (!ftp.changeWorkingDirectory(path)) {
                    String[] ps = StringUtils.split((String)path, (char)'/');
                    String p = "/";
                    ftp.changeWorkingDirectory(p);
                    String[] stringArray = ps;
                    int n = ps.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String s = stringArray[n2];
                        if (!ftp.changeWorkingDirectory(p = String.valueOf(p) + s + "/")) {
                            ftp.makeDirectory(s);
                            ftp.changeWorkingDirectory(p);
                        }
                        ++n2;
                    }
                }
                ftp.storeFile(name, in);
                ftp.logout();
                ftp.disconnect();
            }
            in.close();
            return 0;
        }
        catch (SocketException e) {
            log.error("ftp store error", (Throwable)e);
            return 3;
        }
        catch (IOException e) {
            log.error("ftp store error", (Throwable)e);
            return 4;
        }
    }

    private FTPClient getClient() throws SocketException, IOException {
        FTPClient ftp = new FTPClient();
        ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out)));
        ftp.setDefaultPort(this.getPort().intValue());
        ftp.connect(this.getIp());
        int reply = ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            log.warn("FTP server refused connection: {}", (Object)this.getIp());
            ftp.disconnect();
            return null;
        }
        if (!ftp.login(this.getUsername(), this.getPassword())) {
            log.warn("FTP server refused login: {}, user: {}", (Object)this.getIp(), (Object)this.getUsername());
            ftp.logout();
            ftp.disconnect();
            return null;
        }
        ftp.setControlEncoding(this.getEncoding());
        ftp.setFileType(2);
        ftp.enterLocalPassiveMode();
        return ftp;
    }

    public Ftp() {
    }

    public Ftp(Integer id) {
        super(id);
    }

    public Ftp(Integer id, String name, String ip, Integer port, String encoding, String url) {
        super(id, name, ip, port, encoding, url);
    }
}

