/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.core.manager.impl;

import com.jeecms.common.page.Pagination;
import com.jeecms.common.security.BadCredentialsException;
import com.jeecms.common.security.UsernameNotFoundException;
import com.jeecms.common.web.session.SessionProvider;
import com.jeecms.core.dao.AuthenticationDao;
import com.jeecms.core.entity.Authentication;
import com.jeecms.core.entity.UnifiedUser;
import com.jeecms.core.manager.AuthenticationMng;
import com.jeecms.core.manager.UnifiedUserMng;
import java.io.Serializable;
import java.sql.Timestamp;
import java.util.Date;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AuthenticationMngImpl
implements AuthenticationMng {
    private Logger log = LoggerFactory.getLogger(AuthenticationMngImpl.class);
    private int timeout = 1800000;
    private int interval = 14400000;
    private long refreshTime = this.getNextRefreshTime(System.currentTimeMillis(), this.interval);
    private UnifiedUserMng unifiedUserMng;
    private AuthenticationDao dao;

    public Authentication login(String username, String password, String ip, HttpServletRequest request, HttpServletResponse response, SessionProvider session) throws UsernameNotFoundException, BadCredentialsException {
        UnifiedUser user = this.unifiedUserMng.login(username, password, ip);
        Authentication auth = new Authentication();
        auth.setUid(user.getId());
        auth.setUsername(user.getUsername());
        auth.setEmail(user.getEmail());
        auth.setLoginIp(ip);
        this.save(auth);
        session.setAttribute(request, response, "auth_key", (Serializable)((Object)auth.getId()));
        return auth;
    }

    public Authentication activeLogin(UnifiedUser user, String ip, HttpServletRequest request, HttpServletResponse response, SessionProvider session) {
        this.unifiedUserMng.activeLogin(user, ip);
        Authentication auth = new Authentication();
        auth.setUid(user.getId());
        auth.setUsername(user.getUsername());
        auth.setEmail(user.getEmail());
        auth.setLoginIp(ip);
        this.save(auth);
        session.setAttribute(request, response, "auth_key", (Serializable)((Object)auth.getId()));
        return auth;
    }

    public Authentication retrieve(String authId) {
        Authentication auth;
        long current = System.currentTimeMillis();
        if (this.refreshTime < current) {
            this.refreshTime = this.getNextRefreshTime(current, this.interval);
            int count = this.dao.deleteExpire(new Date(current - (long)this.timeout));
            this.log.info("refresh Authentication, delete count: {}", (Object)count);
        }
        if ((auth = this.findById(authId)) != null && auth.getUpdateTime().getTime() + (long)this.timeout > current) {
            auth.setUpdateTime(new Timestamp(current));
            return auth;
        }
        return null;
    }

    public Integer retrieveUserIdFromSession(SessionProvider session, HttpServletRequest request) {
        String authId = (String)((Object)session.getAttribute(request, "auth_key"));
        if (authId == null) {
            return null;
        }
        Authentication auth = this.retrieve(authId);
        if (auth == null) {
            return null;
        }
        return auth.getUid();
    }

    public void storeAuthIdToSession(SessionProvider session, HttpServletRequest request, HttpServletResponse response, String authId) {
        session.setAttribute(request, response, "auth_key", (Serializable)((Object)authId));
    }

    @Transactional(readOnly=true)
    public Pagination getPage(int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(pageNo, pageSize);
        return page;
    }

    @Transactional(readOnly=true)
    public Authentication findById(String id) {
        Authentication entity = this.dao.findById(id);
        return entity;
    }

    public Authentication save(Authentication bean) {
        bean.setId(StringUtils.remove((String)UUID.randomUUID().toString(), (char)'-'));
        bean.init();
        this.dao.save(bean);
        return bean;
    }

    public Authentication deleteById(String id) {
        Authentication bean = this.dao.deleteById(id);
        return bean;
    }

    public Authentication[] deleteByIds(String[] ids) {
        Authentication[] beans = new Authentication[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(AuthenticationDao dao) {
        this.dao = dao;
    }

    @Autowired
    public void setUserMng(UnifiedUserMng unifiedUserMng) {
        this.unifiedUserMng = unifiedUserMng;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout * 60 * 1000;
    }

    public void setInterval(int interval) {
        this.interval = interval * 60 * 1000;
        this.refreshTime = this.getNextRefreshTime(System.currentTimeMillis(), this.interval);
    }

    private long getNextRefreshTime(long current, int interval) {
        return current + (long)interval;
    }
}

