/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.core.manager.impl;

import com.jeecms.common.email.EmailSender;
import com.jeecms.common.email.MessageTemplate;
import com.jeecms.core.dao.ConfigDao;
import com.jeecms.core.entity.Config;
import com.jeecms.core.manager.ConfigMng;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class ConfigMngImpl
implements ConfigMng {
    private ConfigDao dao;

    @Override
    @Transactional(readOnly=true)
    public Map<String, String> getMap() {
        List<Config> list = this.dao.getList();
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        for (Config config : list) {
            map.put(config.getId(), config.getValue());
        }
        return map;
    }

    @Override
    @Transactional(readOnly=true)
    public String getValue(String id) {
        Config entity = this.dao.findById(id);
        if (entity != null) {
            return entity.getValue();
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public Config.ConfigLogin getConfigLogin() {
        return Config.ConfigLogin.create(this.getMap());
    }

    @Override
    @Transactional(readOnly=true)
    public EmailSender getEmailSender() {
        return Config.ConfigEmailSender.create(this.getMap());
    }

    @Override
    @Transactional(readOnly=true)
    public MessageTemplate getForgotPasswordMessageTemplate() {
        return Config.ConfigMessageTemplate.createForgotPasswordMessageTemplate(this.getMap());
    }

    @Override
    @Transactional(readOnly=true)
    public MessageTemplate getRegisterMessageTemplate() {
        return Config.ConfigMessageTemplate.createRegisterMessageTemplate(this.getMap());
    }

    @Override
    public void updateOrSave(Map<String, String> map) {
        if (map != null && map.size() > 0) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.updateOrSave(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public Config updateOrSave(String key, String value) {
        Config config = this.dao.findById(key);
        if (config != null) {
            config.setValue(value);
        } else {
            config = new Config(key);
            config.setValue(value);
            this.dao.save(config);
        }
        return config;
    }

    @Override
    public Config deleteById(String id) {
        Config bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public Config[] deleteByIds(String[] ids) {
        Config[] beans = new Config[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(ConfigDao dao) {
        this.dao = dao;
    }
}

