/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.core.manager.impl;

import com.jeecms.common.upload.UploadUtils;
import com.jeecms.core.dao.DbFileDao;
import com.jeecms.core.entity.DbFile;
import com.jeecms.core.manager.DbFileMng;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class DbFileMngImpl
implements DbFileMng {
    private DbFileDao dao;

    @Transactional(readOnly=true)
    public DbFile findById(String id) {
        DbFile entity = this.dao.findById(id);
        return entity;
    }

    public String storeByExt(String path, String ext, InputStream in) throws IOException {
        String filename;
        DbFile file;
        while ((file = this.findById(filename = UploadUtils.generateFilename((String)path, (String)ext))) != null) {
        }
        this.save(filename, in);
        return filename;
    }

    public String storeByFilename(String filename, InputStream in) throws IOException {
        DbFile file = this.findById(filename);
        if (file != null) {
            this.update(file, in);
        } else {
            this.save(filename, in);
        }
        return filename;
    }

    public File retrieve(String name) throws IOException {
        String path = System.getProperty("java.io.tmpdir");
        File file = new File(path, name);
        file = UploadUtils.getUniqueFile((File)file);
        DbFile df = this.findById(name);
        FileUtils.writeByteArrayToFile((File)file, (byte[])df.getContent());
        return file;
    }

    public boolean restore(String name, File file) throws FileNotFoundException, IOException {
        this.storeByFilename(name, new FileInputStream(file));
        file.deleteOnExit();
        return true;
    }

    private DbFile update(DbFile file, InputStream in) throws IOException {
        byte[] content = IOUtils.toByteArray((InputStream)in);
        file.setContent(content);
        file.setLastModified(System.currentTimeMillis());
        file.setLength(content.length);
        in.close();
        return file;
    }

    private DbFile save(String filename, InputStream in) throws IOException {
        byte[] content = IOUtils.toByteArray((InputStream)in);
        DbFile file = new DbFile(filename, content.length, System.currentTimeMillis(), content);
        this.dao.save(file);
        in.close();
        return file;
    }

    public DbFile deleteById(String id) {
        DbFile bean = this.dao.deleteById(id);
        return bean;
    }

    public DbFile[] deleteByIds(String[] ids) {
        DbFile[] beans = new DbFile[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(DbFileDao dao) {
        this.dao = dao;
    }
}

