/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.core.manager.impl;

import com.jeecms.core.dao.DbTplDao;
import com.jeecms.core.entity.DbTpl;
import com.jeecms.core.tpl.ParentDirIsFileExceptioin;
import com.jeecms.core.tpl.Tpl;
import com.jeecms.core.tpl.TplManager;
import freemarker.cache.TemplateLoader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class DbTplMngImpl
implements TemplateLoader,
TplManager {
    private static final Logger log = LoggerFactory.getLogger(DbTplMngImpl.class);
    private String[] ignoreLocales = new String[]{"_zh_CN.", "_zh.", "_en_US.", "_en."};
    private DbTplDao dao;

    public Object findTemplateSource(String name) throws IOException {
        String[] stringArray = this.ignoreLocales;
        int n = this.ignoreLocales.length;
        int n2 = 0;
        while (n2 < n) {
            String ignore = stringArray[n2];
            if (name.indexOf(ignore) != -1) {
                log.debug("templete ignore: {}", (Object)name);
                return null;
            }
            ++n2;
        }
        Tpl tpl = this.get(name = "/" + name);
        if (tpl == null) {
            log.debug("templete not found: {}", (Object)name);
            return null;
        }
        if (tpl.isDirectory()) {
            log.warn("template is a directory,not a file!");
            return null;
        }
        log.debug("templete loaded: {}", (Object)name);
        return tpl;
    }

    public long getLastModified(Object templateSource) {
        return ((DbTpl)templateSource).getLastModified();
    }

    public Reader getReader(Object templateSource, String encoding) throws IOException {
        return new StringReader(((DbTpl)templateSource).getSource());
    }

    public void closeTemplateSource(Object templateSource) throws IOException {
    }

    @Override
    @Transactional(readOnly=true)
    public Tpl get(String name) {
        DbTpl entity = this.dao.findById(name);
        return entity;
    }

    @Override
    public void save(String name, String source, boolean isDirectory) {
        DbTpl bean = new DbTpl();
        bean.setId(name);
        if (!isDirectory && source == null) {
            source = "";
        }
        bean.setSource(source);
        bean.setLastModified(System.currentTimeMillis());
        bean.setDirectory(isDirectory);
        this.dao.save(bean);
        this.createParentDir(name);
    }

    @Override
    public void save(String path, MultipartFile file) {
        String name = String.valueOf(path) + "/" + file.getOriginalFilename();
        try {
            String source = new String(file.getBytes(), "UTF-8");
            this.save(name, source, false);
        }
        catch (UnsupportedEncodingException e) {
            log.error("upload template error!", (Throwable)e);
        }
        catch (IOException e) {
            log.error("upload template error!", (Throwable)e);
        }
    }

    private void createParentDir(String name) {
        String[] dirs;
        String[] stringArray = dirs = DbTpl.getParentDir(name);
        int n = dirs.length;
        int n2 = 0;
        while (n2 < n) {
            String dir = stringArray[n2];
            Tpl parentDir = this.get(dir);
            if (parentDir != null && !parentDir.isDirectory()) {
                throw new ParentDirIsFileExceptioin("parent directory is a file: " + parentDir.getName());
            }
            if (parentDir == null) {
                DbTpl dirTpl = new DbTpl();
                dirTpl.setId(dir);
                dirTpl.setDirectory(true);
                this.dao.save(dirTpl);
            }
            ++n2;
        }
    }

    @Override
    public void update(String name, String source) {
        DbTpl entity = (DbTpl)this.get(name);
        entity.setSource(source);
        entity.setLastModified(System.currentTimeMillis());
    }

    @Override
    public int delete(String[] names) {
        int count = 0;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            DbTpl tpl = this.dao.deleteById(name);
            ++count;
            if (tpl.isDirectory()) {
                count += this.deleteByDir(tpl.getName());
            }
            ++n2;
        }
        return names.length;
    }

    private int deleteByDir(String dir) {
        dir = String.valueOf(dir) + "/";
        List<? extends Tpl> list = this.getListByPrefix(dir);
        for (Tpl tpl : list) {
            this.dao.deleteById(tpl.getName());
        }
        return list.size();
    }

    @Override
    public List<? extends Tpl> getListByPrefix(String prefix) {
        return this.dao.getStartWith(prefix);
    }

    @Override
    public List<String> getNameListByPrefix(String prefix) {
        LinkedList<String> list = new LinkedList<String>();
        for (Tpl tpl : this.getListByPrefix(prefix)) {
            list.add(tpl.getName());
        }
        return list;
    }

    @Override
    public List<? extends Tpl> getChild(String path) {
        List<DbTpl> dirs = this.dao.getChild(path, true);
        List<DbTpl> files = this.dao.getChild(path, false);
        dirs.addAll(files);
        return dirs;
    }

    @Override
    public void rename(String orig, String dist) {
        DbTpl tpl = this.dao.deleteById(orig);
        if (tpl == null) {
            return;
        }
        this.dao.deleteById(orig);
        String name = StringUtils.replace((String)tpl.getId(), (String)orig, (String)dist, (int)1);
        this.save(name, tpl.getSource(), tpl.isDirectory());
        this.createParentDir(name);
        if (tpl.isDirectory()) {
            List<DbTpl> list = this.dao.getStartWith(String.valueOf(orig) + "/");
            for (DbTpl t : list) {
                this.dao.deleteById(t.getId());
                name = StringUtils.replace((String)t.getId(), (String)orig, (String)dist, (int)1);
                this.save(name, t.getSource(), t.isDirectory());
            }
        }
    }

    public void setIgnoreLocales(String[] ignoreLocales) {
        this.ignoreLocales = ignoreLocales;
    }

    @Autowired
    public void setDao(DbTplDao dao) {
        this.dao = dao;
    }
}

