/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.core.manager.impl;

import com.jeecms.common.email.EmailSender;
import com.jeecms.common.email.MessageTemplate;
import com.jeecms.common.page.Pagination;
import com.jeecms.common.security.BadCredentialsException;
import com.jeecms.common.security.UsernameNotFoundException;
import com.jeecms.common.security.encoder.PwdEncoder;
import com.jeecms.core.dao.UnifiedUserDao;
import com.jeecms.core.entity.Config;
import com.jeecms.core.entity.UnifiedUser;
import com.jeecms.core.manager.ConfigMng;
import com.jeecms.core.manager.UnifiedUserMng;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Service
@Transactional
public class UnifiedUserMngImpl
implements UnifiedUserMng {
    private ConfigMng configMng;
    private PwdEncoder pwdEncoder;
    private UnifiedUserDao dao;

    @Override
    public UnifiedUser passwordForgotten(Integer userId, EmailSender email, MessageTemplate tpl) {
        UnifiedUser user = this.findById(userId);
        String uuid = StringUtils.remove((String)UUID.randomUUID().toString(), (char)'-');
        user.setResetKey(uuid);
        String resetPwd = RandomStringUtils.randomNumeric((int)10);
        user.setResetPwd(resetPwd);
        this.senderEmail(user.getId(), user.getUsername(), user.getEmail(), user.getResetKey(), user.getResetPwd(), email, tpl);
        return user;
    }

    private void senderEmail(final Integer uid, final String username, final String to, final String resetKey, final String resetPwd, final EmailSender email, final MessageTemplate tpl) {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(email.getHost());
        sender.setUsername(email.getUsername());
        sender.setPassword(email.getPassword());
        sender.send(new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws MessagingException, UnsupportedEncodingException {
                MimeMessageHelper msg = new MimeMessageHelper(mimeMessage, false, email.getEncoding());
                msg.setSubject(tpl.getForgotPasswordSubject());
                msg.setTo(to);
                msg.setFrom(email.getUsername(), email.getPersonal());
                String text = tpl.getForgotPasswordText();
                text = StringUtils.replace((String)text, (String)"${uid}", (String)String.valueOf(uid));
                text = StringUtils.replace((String)text, (String)"${username}", (String)username);
                text = StringUtils.replace((String)text, (String)"${resetKey}", (String)resetKey);
                text = StringUtils.replace((String)text, (String)"${resetPwd}", (String)resetPwd);
                msg.setText(text);
            }
        });
    }

    private void senderEmail(final String username, final String to, final String activationCode, final EmailSender email, final MessageTemplate tpl) {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(email.getHost());
        sender.setUsername(email.getUsername());
        sender.setPassword(email.getPassword());
        sender.send(new MimeMessagePreparator(){

            public void prepare(MimeMessage mimeMessage) throws MessagingException, UnsupportedEncodingException {
                MimeMessageHelper msg = new MimeMessageHelper(mimeMessage, false, email.getEncoding());
                msg.setSubject(tpl.getRegisterSubject());
                msg.setTo(to);
                msg.setFrom(email.getUsername(), email.getPersonal());
                String text = tpl.getRegisterText();
                text = StringUtils.replace((String)text, (String)"${username}", (String)username);
                text = StringUtils.replace((String)text, (String)"${activationCode}", (String)activationCode);
                msg.setText(text);
            }
        });
    }

    @Override
    public UnifiedUser resetPassword(Integer userId) {
        UnifiedUser user = this.findById(userId);
        user.setPassword(this.pwdEncoder.encodePassword(user.getResetPwd()));
        user.setResetKey(null);
        user.setResetPwd(null);
        return user;
    }

    @Override
    public Integer errorRemaining(String username) {
        if (StringUtils.isBlank((String)username)) {
            return null;
        }
        UnifiedUser user = this.getByUsername(username);
        if (user == null) {
            return null;
        }
        long now = System.currentTimeMillis();
        Config.ConfigLogin configLogin = this.configMng.getConfigLogin();
        int maxErrorTimes = configLogin.getErrorTimes();
        int maxErrorInterval = configLogin.getErrorInterval() * 60 * 1000;
        Integer errorCount = user.getErrorCount();
        Date errorTime = user.getErrorTime();
        if (errorCount <= 0 || errorTime == null || errorTime.getTime() + (long)maxErrorInterval < now) {
            return maxErrorTimes;
        }
        return maxErrorTimes - errorCount;
    }

    @Override
    public UnifiedUser login(String username, String password, String ip) throws UsernameNotFoundException, BadCredentialsException {
        UnifiedUser user = this.getByUsername(username);
        if (user == null) {
            throw new UsernameNotFoundException("username not found: " + username);
        }
        if (!this.pwdEncoder.isPasswordValid(user.getPassword(), password)) {
            this.updateLoginError(user.getId(), ip);
            throw new BadCredentialsException("password invalid");
        }
        if (!user.getActivation().booleanValue()) {
            throw new BadCredentialsException("account not activated");
        }
        this.updateLoginSuccess(user.getId(), ip);
        return user;
    }

    public void updateLoginSuccess(Integer userId, String ip) {
        UnifiedUser user = this.findById(userId);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        user.setLoginCount(user.getLoginCount() + 1);
        user.setLastLoginIp(ip);
        user.setLastLoginTime(now);
        user.setErrorCount(0);
        user.setErrorTime(null);
        user.setErrorIp(null);
    }

    public void updateLoginError(Integer userId, String ip) {
        UnifiedUser user = this.findById(userId);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        Config.ConfigLogin configLogin = this.configMng.getConfigLogin();
        int errorInterval = configLogin.getErrorInterval();
        Date errorTime = user.getErrorTime();
        user.setErrorIp(ip);
        if (errorTime == null || errorTime.getTime() + (long)(errorInterval * 60 * 1000) < ((Date)now).getTime()) {
            user.setErrorTime(now);
            user.setErrorCount(1);
        } else {
            user.setErrorCount(user.getErrorCount() + 1);
        }
    }

    @Override
    public boolean usernameExist(String username) {
        return this.getByUsername(username) != null;
    }

    @Override
    public boolean emailExist(String email) {
        return this.dao.countByEmail(email) > 0;
    }

    @Override
    public UnifiedUser getByUsername(String username) {
        return this.dao.getByUsername(username);
    }

    @Override
    public List<UnifiedUser> getByEmail(String email) {
        return this.dao.getByEmail(email);
    }

    @Override
    @Transactional(readOnly=true)
    public Pagination getPage(int pageNo, int pageSize) {
        Pagination page = this.dao.getPage(pageNo, pageSize);
        return page;
    }

    @Override
    @Transactional(readOnly=true)
    public UnifiedUser findById(Integer id) {
        UnifiedUser entity = this.dao.findById(id);
        return entity;
    }

    @Override
    public UnifiedUser save(String username, String email, String password, String ip) {
        return this.save(username, email, password, ip, true, null, null);
    }

    @Override
    public UnifiedUser save(String username, String email, String password, String ip, Boolean activation, EmailSender sender, MessageTemplate msgTpl) {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        UnifiedUser user = new UnifiedUser();
        user.setUsername(username);
        user.setEmail(email);
        user.setPassword(this.pwdEncoder.encodePassword(password));
        user.setRegisterIp(ip);
        user.setRegisterTime(now);
        user.setLastLoginIp(ip);
        user.setLastLoginTime(now);
        user.setActivation(activation);
        user.init();
        this.dao.save(user);
        if (!activation.booleanValue()) {
            String uuid = StringUtils.remove((String)UUID.randomUUID().toString(), (char)'-');
            user.setActivationCode(uuid);
            this.senderEmail(username, email, uuid, sender, msgTpl);
        }
        return user;
    }

    @Override
    public UnifiedUser update(Integer id, String password, String email) {
        UnifiedUser user = this.findById(id);
        if (!StringUtils.isBlank((String)email)) {
            user.setEmail(email);
        } else {
            user.setEmail(null);
        }
        if (!StringUtils.isBlank((String)password)) {
            user.setPassword(this.pwdEncoder.encodePassword(password));
        }
        return user;
    }

    @Override
    public boolean isPasswordValid(Integer id, String password) {
        UnifiedUser user = this.findById(id);
        return this.pwdEncoder.isPasswordValid(user.getPassword(), password);
    }

    @Override
    public UnifiedUser deleteById(Integer id) {
        UnifiedUser bean = this.dao.deleteById(id);
        return bean;
    }

    @Override
    public UnifiedUser[] deleteByIds(Integer[] ids) {
        UnifiedUser[] beans = new UnifiedUser[ids.length];
        int i = 0;
        int len = ids.length;
        while (i < len) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public UnifiedUser active(String username, String activationCode) {
        UnifiedUser bean = this.getByUsername(username);
        bean.setActivation(true);
        bean.setActivationCode(null);
        return bean;
    }

    @Override
    public UnifiedUser activeLogin(UnifiedUser user, String ip) {
        this.updateLoginSuccess(user.getId(), ip);
        return user;
    }

    @Autowired
    public void setConfigMng(ConfigMng configMng) {
        this.configMng = configMng;
    }

    @Autowired
    public void setPwdEncoder(PwdEncoder pwdEncoder) {
        this.pwdEncoder = pwdEncoder;
    }

    @Autowired
    public void setDao(UnifiedUserDao dao) {
        this.dao = dao;
    }
}

