/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.core.tpl;

import com.jeecms.core.tpl.Tpl;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.io.FileUtils;

public class FileTpl
implements Tpl {
    private File file;
    private String root;

    public FileTpl(File file, String root) {
        this.file = file;
        this.root = root;
    }

    public String getName() {
        String ap = this.file.getAbsolutePath().substring(this.root.length());
        if (!(ap = ap.replace(File.separatorChar, '/')).startsWith("/")) {
            ap = "/" + ap;
        }
        return ap;
    }

    public String getPath() {
        String name = this.getName();
        return name.substring(0, name.lastIndexOf(47));
    }

    public String getFilename() {
        return this.file.getName();
    }

    public String getSource() {
        if (this.file.isDirectory()) {
            return null;
        }
        try {
            return FileUtils.readFileToString((File)this.file, (String)"UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public long getLastModified() {
        return this.file.lastModified();
    }

    public Date getLastModifiedDate() {
        return new Timestamp(this.getLastModified());
    }

    public long getLength() {
        return this.file.length();
    }

    public int getSize() {
        return (int)(this.getLength() / 1024L) + 1;
    }

    public boolean isDirectory() {
        return this.file.isDirectory();
    }
}

