/*
 * Decompiled with CFR 0.152.
 */
package com.jeecms.core.tpl;

import com.jeecms.common.web.springmvc.RealPathResolver;
import com.jeecms.core.tpl.FileTpl;
import com.jeecms.core.tpl.Tpl;
import com.jeecms.core.tpl.TplManager;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.multipart.MultipartFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileTplManagerImpl
implements TplManager {
    private static Logger log = LoggerFactory.getLogger(FileTplManagerImpl.class);
    private String root;
    private RealPathResolver realPathResolver;

    @Override
    public int delete(String[] names) {
        int count = 0;
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            File f = new File(this.realPathResolver.get(name));
            if (f.isDirectory()) {
                if (FileUtils.deleteQuietly((File)f)) {
                    ++count;
                }
            } else if (f.delete()) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    @Override
    public Tpl get(String name) {
        File f = new File(this.realPathResolver.get(name));
        if (f.exists()) {
            return new FileTpl(f, this.root);
        }
        return null;
    }

    public List<Tpl> getListByPrefix(String prefix) {
        File parent;
        File f = new File(this.realPathResolver.get(prefix));
        String name = prefix.substring(prefix.lastIndexOf("/") + 1);
        if (prefix.endsWith("/")) {
            name = "";
            parent = f;
        } else {
            parent = f.getParentFile();
        }
        if (parent.exists()) {
            File[] files = parent.listFiles(new PrefixFilter(name));
            if (files != null) {
                ArrayList<Tpl> list = new ArrayList<Tpl>();
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    list.add(new FileTpl(file, this.root));
                    ++n2;
                }
                return list;
            }
            return new ArrayList<Tpl>(0);
        }
        return new ArrayList<Tpl>(0);
    }

    @Override
    public List<String> getNameListByPrefix(String prefix) {
        List<Tpl> list = this.getListByPrefix(prefix);
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (Tpl tpl : list) {
            result.add(tpl.getName());
        }
        return result;
    }

    public List<Tpl> getChild(String path) {
        File file = new File(this.realPathResolver.get(path));
        File[] child = file.listFiles();
        if (child != null) {
            ArrayList<Tpl> list = new ArrayList<Tpl>(child.length);
            File[] fileArray = child;
            int n = child.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                list.add(new FileTpl(f, this.root));
                ++n2;
            }
            return list;
        }
        return new ArrayList<Tpl>(0);
    }

    @Override
    public void rename(String orig, String dist) {
        String os = this.realPathResolver.get(orig);
        File of = new File(os);
        String ds = this.realPathResolver.get(dist);
        File df = new File(ds);
        try {
            if (of.isDirectory()) {
                FileUtils.moveDirectory((File)of, (File)df);
            } else {
                FileUtils.moveFile((File)of, (File)df);
            }
        }
        catch (IOException e) {
            log.error("Move template error: " + orig + " to " + dist, (Throwable)e);
        }
    }

    @Override
    public void save(String name, String source, boolean isDirectory) {
        String real = this.realPathResolver.get(name);
        File f = new File(real);
        if (isDirectory) {
            f.mkdirs();
        } else {
            try {
                FileUtils.writeStringToFile((File)f, (String)source, (String)"UTF-8");
            }
            catch (IOException e) {
                log.error("Save template error: " + name, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void save(String path, MultipartFile file) {
        File f = new File(this.realPathResolver.get(path), file.getOriginalFilename());
        try {
            file.transferTo(f);
        }
        catch (IllegalStateException e) {
            log.error("upload template error!", (Throwable)e);
        }
        catch (IOException e) {
            log.error("upload template error!", (Throwable)e);
        }
    }

    @Override
    public void update(String name, String source) {
        String real = this.realPathResolver.get(name);
        File f = new File(real);
        try {
            FileUtils.writeStringToFile((File)f, (String)source, (String)"UTF-8");
        }
        catch (IOException e) {
            log.error("Save template error: " + name, (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    @Autowired
    public void setRealPathResolver(RealPathResolver realPathResolver) {
        this.realPathResolver = realPathResolver;
        this.root = realPathResolver.get("");
    }

    private static class PrefixFilter
    implements FileFilter {
        private String prefix;

        public PrefixFilter(String prefix) {
            this.prefix = prefix;
        }

        public boolean accept(File file) {
            String name = file.getName();
            return file.isFile() && name.startsWith(this.prefix);
        }
    }
}

